/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.terasoluna.fw.ex.unit.mock.Callback;
import jp.terasoluna.fw.ex.unit.mock.DaoParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMockDao {
    protected final LinkedList<Object> results = new LinkedList();
    protected final List<DaoParam> params = new ArrayList<DaoParam>();

    protected Object poll() {
        Object result = this.results.poll();
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        return result;
    }

    protected int pollInt() throws ClassCastException {
        Object result = this.poll();
        if (result != null && result instanceof Integer) {
            return (Integer)result;
        }
        throw new ClassCastException("Integer was expected but the actual was " + result);
    }

    protected Object[] pollArray() throws ClassCastException {
        Object result = this.poll();
        if (result == null || !result.getClass().isArray()) {
            throw new ClassCastException("Array was expected but the actual was " + result);
        }
        return (Object[])result;
    }

    protected List<?> pollList() throws ClassCastException {
        Object result = this.poll();
        if (!(result instanceof List)) {
            throw new ClassCastException("java.util.List was expected but the actual was " + result);
        }
        return (List)result;
    }

    protected Map<String, Object> pollMap() throws ClassCastException {
        Object result = this.poll();
        if (!(result instanceof Map)) {
            throw new ClassCastException("java.util.Map was expected but the actual was " + result);
        }
        return (Map)result;
    }

    protected Map<String, Object>[] pollMapArray() throws ClassCastException {
        return (Map[])this.pollArray();
    }

    protected List<Map<String, Object>> pollMapList() throws ClassCastException {
        return this.pollList();
    }

    protected void pollAndExecuteIfCallback(Object[] args) throws ClassCastException {
        Object first = this.results.peek();
        if (first instanceof Callback) {
            ((Callback)this.poll()).execute(args);
        } else if (first instanceof RuntimeException) {
            this.poll();
        }
    }

    protected void addParam(DaoParam param) {
        String methodName = null;
        StackTraceElement[] stacTraceElements = new Throwable().getStackTrace();
        if (stacTraceElements != null && stacTraceElements.length > 0) {
            methodName = stacTraceElements[1].getMethodName();
        }
        param.setMethodName(methodName);
        this.params.add(param);
    }

    public void addResult(Object result) {
        this.results.add(result);
    }

    public void addResults(Collection<?> results) {
        this.results.addAll(results);
    }

    public List<DaoParam> getParams() {
        return this.params;
    }

    public void clear() {
        this.results.clear();
        this.params.clear();
    }
}

