/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfo;
import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfoMapping;
import jp.terasoluna.fw.ex.web.struts.action.FlowTerminateActionMapping;
import jp.terasoluna.fw.ex.web.struts.action.FlowTerminateActionMappingExtendPropertyHolder;
import jp.terasoluna.fw.web.struts.actions.ActionEx;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * ʉʃt[Ip̃ANVNXB
 */
public class FlowTerminateAction extends ActionEx {

    /**
     * I_NGXgɊi[ۂ̃L[
     */
    public static final String TERMINAL_KEY = FlowTerminateAction.class
            .getName()
            + ".TERMINAL";

    /**
     * ʉʃt[IpANVsB
     * <p>
     * ȉ̏sB
     * <pre>
     * EHttpSessionAʉʃt[Ƌʉʃt[Iɗp{@link FlowCallbackInfo}̃}bsOێ
     *   {@link FlowCallbackInfoMapping}̃CX^X擾B
     * EcurrentFlowvpeBŎw肳Ă錻ݎs̋ʉʃt[L[ɂāA
     *   {@link FlowCallbackInfoMapping}̃CX^XAʉʃt[Iɗp{@link FlowCallbackInfo}̃CX^X擾B
     * E擾{@link FlowCallbackInfo}CX^XgetActionForward\bhsāAJ(R[obN)ActionForward擾B
     * ENGXgɁAʉʃt[IANVterminalŐݒ肳ꂽlݒ肷B
     * Eʉʃt[NANVɑJ(R[obN)B
     * </pre>
     * </p>
     * @param mapping
     *            ʉʃt[Íiʉʃt[IANV́jactionvf\ActionMapping (nullȊO)
     * @param form
     *            ANVtH[
     * @param request
     *            NGXg (nullȊO)
     * @param response
     *            X|X (nullȊO)
     * @throws IllegalArgumentException
     *             mapping {@link FlowTerminateActionMapping}^{@link FlowTerminateActionMappingExtendPropertyHolder}NXłȂꍇ
     * @throws IllegalArgumentException
     *             {@link FlowTerminateActionMapping#getCurrentFlow}
     *             ({@link FlowTerminateActionMappingExtendPropertyHolder#getCurrentFlow})
     *             null̏ꍇ
     * @throws FlowTerminateFailureException
     *             HttpSession{@link FlowCallbackInfoMapping}
     *             ̃CX^X擾łȂꍇ
     * @throws FlowTerminateFailureException
     *             currentFlowvpeBŎw肳Ă錻ݎs̋ʉʃt[R[obN邽߂̏({@link FlowCallbackInfo})
     *             {@link FlowCallbackInfoMapping}CX^X擾łȂꍇ
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
                                                                     throws Exception {
        if (!(mapping instanceof FlowTerminateActionMappingExtendPropertyHolder)) {
            throw new IllegalArgumentException(
                    "Argument mapping must be an instance of "
                            + FlowTerminateActionMapping.class.getName()
                            + " or "
                            + FlowTerminateActionMappingExtendPropertyHolder.class
                                    .getName() + ".");
        }
        FlowTerminateActionMappingExtendPropertyHolder flowTerminateActionMapping = (FlowTerminateActionMappingExtendPropertyHolder) mapping;
        String currentFlow = flowTerminateActionMapping.getCurrentFlow();
        if (StringUtils.isBlank(currentFlow)) {
            throw new IllegalArgumentException("The value of currentFlow at "
                    + mapping.getClass().getName() + " must be specified.");
        }
        HttpSession session = request.getSession();
        FlowCallbackInfoMapping callBackInfoMapping = (FlowCallbackInfoMapping) session
                .getAttribute(FlowCallbackInfoMapping.class.getName());
        if (callBackInfoMapping == null) {
            throw new FlowTerminateFailureException(
                    "Failed to find FlowCallbackInfoMapping in session. Session attribute name is \""
                            + FlowCallbackInfoMapping.class.getName() + "\".");
        }
        FlowCallbackInfo callBackInfo = callBackInfoMapping
                .findFlowCallbackInfo(currentFlow);
        if (callBackInfo == null) {
            throw new FlowTerminateFailureException(
                    "Failed to find FlowCallbackInfo in FlowCallbackInfoMapping. Flow name is \""
                            + currentFlow + "\".");
        }

        request.setAttribute(FlowTerminateAction.TERMINAL_KEY,
                flowTerminateActionMapping.getTerminal());

        return callBackInfo.getActionForward(mapping, form, request, response);
    }
}
