/*
 * Copyright (c) 2016 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.formex.web.action;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

import jp.terasoluna.fw.web.struts.actions.ActionEx;
import jp.terasoluna.thin.functionsample.formex.bean.ValidatorResultsImpl;

/**
 * Struts̐Ǝ㐫(CVE-2016-1182)΍̃`FbNpANVNX(DynaActionFormp)
 * @version 2016/07/21
 */
public class VrDynaAction extends ActionEx {

    /**
     * LOGGER
     */
    private Log log = LogFactory.getLog(VrDynaAction.class);

    /**
     * DynaActionForm̏OɏƂƂɁAʕ\̂߂ɃNGXgXR[v֊i[B
     * @see jp.terasoluna.fw.web.struts.actions.ActionEx#doExecute(org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     * @param mapping ActionMapping
     * @param form DynaValidatorActionFormEx(DynaActionForm)
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @return ActionForward
     * @throws Exception O
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res)
                                                                                                                           throws Exception {
        // OActionForm̓eo͂Asvȃp[^XLbvĂȂƂmFł悤ɂB
        // form check: p[^=p[^l
        DynaActionForm vrDynaForm = (DynaActionForm) form;
        String strVrText1 = ((ValidatorResultsImpl)vrDynaForm.get("validatorResults")).getTextLower();
        String strVrText2 = ((ValidatorResultsImpl)vrDynaForm.get("ValidatorResults")).getTextUpper();
        String strRvmText1 = (String)((ConcurrentHashMap)vrDynaForm.get("resultValueMap")).get("key1");
        String strRvmText2 = (String)((ConcurrentHashMap)vrDynaForm.get("ResultValueMap")).get("key2");
        String strRvmText3 = (String)((ConcurrentHashMap)vrDynaForm.get("resultValueMap")).get("key3");
        String strRvmText4 = (String)((ConcurrentHashMap)vrDynaForm.get("ResultValueMap")).get("key4");
        String strxxxMap1 = (String)((ConcurrentHashMap)vrDynaForm.get("xxxmap")).get("aaa");
        String strxxxMap2 = (String)((ConcurrentHashMap)vrDynaForm.get("xxxmap")).get("bbb");

        log.info("validatorResults.textLower=" + strVrText1);
        log.info("ValidatorResults.textUpper=" + strVrText2);
        log.info("resultValueMap.key1=" + strRvmText1);
        log.info("ResultValueMap.key2=" + strRvmText2);
        log.info("resultValueMap(key3)=" + strRvmText3);
        log.info("ResultValueMap(key4)=" + strRvmText4);
        log.info("form check: xxxmap.aaa=" + strxxxMap1);
        log.info("form check: xxxmap(bbb)=" + strxxxMap2);
        log.info("form check: userId=" + Arrays.toString((String[]) vrDynaForm.get("userId")));

        // ʕ\pActionForm̓eNGXgXR[vɊi[
        Map<String, String> resultMap = new TreeMap<String, String>();

        resultMap.put("form-type", "DynaActionForm");
        resultMap.put("validatorResults.textLower", strVrText1);
        resultMap.put("ValidatorResults.textUpper", strVrText2);
        resultMap.put("resultValueMap.key1", strRvmText1);
        resultMap.put("ResultValueMap.key2", strRvmText2);
        resultMap.put("resultValueMap(key3)", strRvmText3);
        resultMap.put("ResultValueMap(key4)", strRvmText4);
        resultMap.put("xxxmap.aaa", strxxxMap1);
        resultMap.put("xxxmap(bbb)", strxxxMap2);

        String[] userIds = (String[]) vrDynaForm.get("userId");
        if (userIds.length == 0) {
            // '[]'Əo͂̂
            resultMap.put("userId", "");
        } else {
            resultMap.put("userId", Arrays.toString((String[]) vrDynaForm.get("userId")));
        }
        req.setAttribute("resultMap", resultMap);

        // ʑJ
        return mapping.findForward("success");
    }

}
