/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.VariableInfo;

/**
 * <p>{@link StringFormatterTagBase} NX̂߂
 * <code>TagExtraInfo</code> NXB</p>
 *
 * <p>{@link StringFormatterTagBase} NX쐬
 * XNveBOϐɂĂ̏񋟂B</p>
 *
 * <p>쐬XNveBOϐ̕ϐ^AуXR[vɂẮA
 * {@link StringFormatterTagBase} NX̃hLgQƂ̂ƁB</p>
 *
 * @see jp.terasoluna.fw.web.taglib.StringFormatterTagBase
 *
 */
public abstract class StringFormatterTeiBase extends TagExtraInfo {

    /**
     * <p>{@link StringFormatterTagBase} NXpTuNX
     * T|[gJX^^OɂāA<code>id</code> ɑΉ
     * XNveBOϐ擾B</p>
     *
     * @param data JX^^ȎAт̒l̏
     * @return JX^^ÕXNveBOϐ
     */
    @Override
    public VariableInfo[] getVariableInfo(TagData data) {

        if (data.getId() != null) {
            return new VariableInfo [] {
                new VariableInfo(data.getId(),
                                    "java.lang.String",
                                    true,
                                    VariableInfo.AT_BEGIN)};
        }
        return new VariableInfo [] {};
    }
}
