/*
 * Copyright (c) 2016 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.formex.web.action;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import jp.terasoluna.fw.web.struts.actions.ActionEx;
import jp.terasoluna.thin.functionsample.formex.web.form.VrForm;

/**
 * Struts̐Ǝ㐫(CVE-2016-1182)΍̃`FbNpANVNX(ActionFormp)
 * @version 2016/07/21
 */
public class VrAction extends ActionEx {

    /**
     * LOGGER
     */
    private Log log = LogFactory.getLog(VrAction.class);

    /**
     * ActionForm̏OɏƂƂɁAʕ\̂߂ɃNGXgXR[v֊i[B
     * @see jp.terasoluna.fw.web.struts.actions.ActionEx#doExecute(org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     * @param mapping ActionMapping
     * @param form SecurityForm(ActionForm)
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @return ActionForward
     * @throws Exception O
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res)
                                                                                                                           throws Exception {
        // OActionForm̓eo͂Asvȃp[^XLbvĂȂƂmFł悤ɂB
        // form check: p[^=p[^l
        VrForm vrForm = (VrForm) form;

        String strVrText1 = vrForm.getValidatorResults().getTextLower();
        String strVrText2 = vrForm.getValidatorResults().getTextUpper();
        String strRvmText1 =  (String)vrForm.getResultValueMap().get("key1");
        String[] strRvmText2 =  (String[])vrForm.getResultValueMap().get("key2");
        String[] strRvmText3 =  (String[])vrForm.getResultValueMap().get("key3");
        String[] strRvmText4 =  (String[])vrForm.getResultValueMap().get("key4");
        String strXxxmapKey1 = (String)vrForm.getXxxmap().get("aaa");
        String[] strXxxmapKey2 = (String[])vrForm.getXxxmap().get("bbb");

       	log.info("form check: validatorResults.textLower=" + strVrText1);
       	log.info("form check: ValidatorResults.textUpper=" + strVrText2);
       	log.info("form check: resultValueMap.key1=" + strRvmText1);
        if (strRvmText2 != null ) {
            log.info("form check: ResultValueMap.key2=" + strRvmText2[0]);
        } else {
            log.info("form check: ResultValueMap.key2=" + null);
        }
        if (strRvmText3 != null ) {
            log.info("form check: resultValueMap(key3)=" + strRvmText3[0]);
        } else {
            log.info("form check: resultValueMap(key3)=" + null);
        }
        if (strRvmText4 != null ) {
            log.info("form check: ResultValueMap(key4)=" + strRvmText4[0]);
        } else {
            log.info("form check: ResultValueMap(key4)=" + null);
        }
       	log.info("form check: xxxmap.aaa=" + strXxxmapKey1);
        if (strXxxmapKey2 != null ) {
            log.info("form check: xxxmap(bbb)=" + strXxxmapKey2[0]);
        } else {
            log.info("form check: xxxmap(bbb)=" + null);
        }

        log.info("form check: userId=" + Arrays.toString(vrForm.getUserId()));

        // ʕ\pActionForm̓eNGXgXR[vɊi[
        Map<String, String> resultMap = new TreeMap<String, String>();

        resultMap.put("form-type", "ActionForm");

        resultMap.put("validatorResults.textLower", strVrText1);
        resultMap.put("ValidatorResults.textUpper", strVrText2);
        resultMap.put("resultValueMap.key1", strRvmText1);
        if (strRvmText2 != null ) {
            resultMap.put("ResultValueMap.key2", strRvmText2[0]);
        } else {
            resultMap.put("ResultValueMap.key2", null);
        }
        if (strRvmText3 != null ) {
            resultMap.put("resultValueMap(key3)", strRvmText3[0]);
        } else {
            resultMap.put("resultValueMap(key3)", null);
        }
        if (strRvmText4 != null ) {
            resultMap.put("ResultValueMap(key4)", strRvmText4[0]);
        } else {
            resultMap.put("ResultValueMap(key4)", null);
        }

        resultMap.put("xxxmap.aaa", strXxxmapKey1);
        if (strXxxmapKey2 != null) {
        	resultMap.put("xxxmap(bbb)", strXxxmapKey2[0]);
        } else {
        	resultMap.put("xxxmap(bbb)", null);
        }

        if (vrForm.getUserId() == null) {
            // 'null'Əo͂̂
            resultMap.put("userId", "");
        } else {
            resultMap.put("userId", Arrays.toString(vrForm.getUserId()));
        }
        req.setAttribute("resultMap", resultMap);

        // ʑJ
        return mapping.findForward("success");
    }

}
