/*
 * Copyright (c) 2015 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin.patch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * gq`FbNsB
 *
 * <p>
 * Filteȑp[^<code>access.control.prohibited.extension</code>Ŏw肳ꂽA
 * ֎~gqpXւ̃ANZXvɑ΂SC_NOT_FOUND(404)G[ԂB<br>
 * ɂAYgqt@Cւ̒ڃANZX֎~B<br>
 * ֎~gqւ̃ANZXsꍇł̃`FbNΏۂO
 * ʂȃpX΁AFilteȑp[^<code>restrictionEscape</code>
 * ̒lƂĒ`邱ƂŁA`FbNΏۂ̃pX`łB<br>
 * ڃANZX֎~Ώۂ̊gqAуANZX֎~ΏۂOpX
 * ꍇAs؂Ŏw肷邱ƁB
 * </p>
 *
 * <h5>gp@</h5>
 * <p>
 * ̋@\gpɂ fvCgfBXNv^iweb.xmlj
 * ȉ̂悤ɐݒ肷B<br>
 * <code><pre>
 * &lt;filter&gt;
 *   &lt;filter-name&gt;extensionFilter&lt;/filter-name&gt;
 *   &lt;filter-class&gt;jp.terasoluna.fw.web.thin.patch.ExtensionFilter&lt;/filter-class&gt;
 *   &lt;!-- (1) ANZX֎~ƂȂgq̈ꗗ --&gt;
 *   &lt;init-param&gt;
 *     &lt;param-name&gt;access.control.prohibited.extension&lt;/param-name&gt;
 *     &lt;param-value&gt;
 *       .jsp
 *       .csv
 *       .pdf
 *     &lt;/param-value&gt;
 *   &lt;/init-param&gt;
 *   &lt;!-- (2) `FbNΏۊOƂȂ郊NGXgpẌꗗ --&gt;
 *   &lt;init-param&gt;
 *     &lt;param-name&gt;restrictionEscape&lt;/param-name&gt;
 *     &lt;param-value&gt;
 *       /sample/logon/index.jsp
 *       /sample/error/error.jsp
 *     &lt;/param-value&gt;
 *   &lt;/init-param&gt;
 * &lt;/filter&gt;
 *
 * &lt;filter-mapping&gt;
 *   &lt;filter-name&gt;extensionFilter&lt;/filter-name&gt;
 *   &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 * </pre></code>
 * </p>
 */
public class ExtensionFilter implements Filter {

    /**
     * NGXgtB^ʉ߂ƂNGXg̃L[B
     */
    public static final String EXTENSION_THRU_KEY = "EXTENSION_THRU_KEY";

    /**
     * Filteȑp[^擾Agq`FbNΏۊOɂpX̃L[B
     */
    public static final String RESTRICTION_ESCAPE_KEY = "restrictionEscape";

    /**
     * ONXB
     */
    private static Log log
        = LogFactory.getLog(ExtensionFilter.class);

    /**
     * Filteȑp[^擾AڃANZX֎~gq̃L[B
     */
    private static final String PROHIBITED_EXTENSION_KEY
            = "access.control.prohibited.extension";

    /**
     * WebuEU̒ڃANZX֎~gq̃XgB
     */
    private List prohibitedExtensionList = new ArrayList();

    /**
     * gq`FbN̑ΏۊOƂȂpX̃XgB
     */
    private List restrictionEscapePaths = new ArrayList();

    /**
     * tB^T[rXJnԂɂȂۂɁAReiɂČĂяoB
     *  
     * ReíAFilterCX^XɁAinit \bh
     * 1 񂾂ĂяoB<br>
     * FilterɃtB^Ƃs悤ɗvɂ́A
     * init \bh IĂȂ΂ȂȂB
     * init\bh ̂ꂩ̏Ԃ̏ꍇARei
     * FilterT[rXԂɂłȂB<br>
     * <ul>
     *  <li>ServletException X[B </li>
     *  <li>ReiɂĒ`ꂽԓɁAAȂB</li>
     * </ul>
     * 
     * @param config FilterConfigCX^XB
     * 
     * @throws javax.servlet.ServletException ُ펞ɃX[OB
     *             
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    public void init(FilterConfig config) throws ServletException {

        //ڃANZX֎~gq̃Xg擾B
        String prohibitedExtensionsStr = config.getInitParameter(PROHIBITED_EXTENSION_KEY);
        if (prohibitedExtensionsStr == null || prohibitedExtensionsStr.trim().length() == 0) {
            log.warn("Init parameter[" + PROHIBITED_EXTENSION_KEY + "] isn't set or is empty.");
            return;
        }
        StringTokenizer st = new StringTokenizer(prohibitedExtensionsStr, "\r\n");
        while (st.hasMoreTokens()) {
            String extension = st.nextToken().trim();
            if (extension.length() == 0) {
                continue;
            }
            // gq.Ŏn܂ĂȂƂ.t
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            if (log.isDebugEnabled()) {
                log.debug("prohibitedExtension:" + extension);
            }
            prohibitedExtensionList.add(extension);
        }

        //ڃANZX֎~sȂpX擾B
        String extensionCheckEscapePathsStr = config.getInitParameter(RESTRICTION_ESCAPE_KEY);
        if (extensionCheckEscapePathsStr == null || extensionCheckEscapePathsStr.trim().length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("Init parameter[" + RESTRICTION_ESCAPE_KEY + "] isn't set or is empty.");
            }
            return;
        }

        st = new StringTokenizer(extensionCheckEscapePathsStr, "\r\n");
        while (st.hasMoreTokens()) {
            String extensionCheckEscapePath = st.nextToken().trim();
            if (extensionCheckEscapePath.length() == 0) {
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("extensionCheckEscapePath:["
                        + extensionCheckEscapePath + "]");
            }
            restrictionEscapePaths.add(extensionCheckEscapePath);
        }
    }

    /**
     * gq`FbNsB
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain tB^`F[
     * 
     * @throws IOException I/OG[
     * @throws ServletException T[ubgO
     * 
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
     */
    public void doFilter(ServletRequest req,
                         ServletResponse res,
                         FilterChain chain)
            throws IOException, ServletException {

        //NGXgtB^ʉ߂ǂ𔻒B
        if (req.getAttribute(EXTENSION_THRU_KEY) == null) {

            //tB^̒ʉߏZbg
            req.setAttribute(EXTENSION_THRU_KEY, "true");

            //NGXgpXgq`FbNsȂpXXg
            //vĂꍇ͏I
            Set pathInfoSet = resolveAccessControlPath(req);
            Iterator pathInfoIt = pathInfoSet.iterator();
            while(pathInfoIt.hasNext()) {
                String pathInfo = (String) pathInfoIt.next();
                if (restrictionEscapePaths.contains(pathInfo)) {
                    continue;
                }

                //gq`FbNs
                //NGXgpX̊gq擾B
                String extension = getExtension(pathInfo);
                if (prohibitedExtensionList.contains(extension)) {

                    if (log.isDebugEnabled()) {
                        log.debug("requestURI[" + pathInfo
                                + "] has prohibited extension");
                    }

                    // HTTPG[404Ԃ
                    ((HttpServletResponse) res)
                            .sendError(HttpServletResponse.SC_NOT_FOUND);
                    return; // ȍ~͎sȂ
                }
            }
        }

        // ̃tB^܂̓T[ubg
        chain.doFilter(req, res);
    }

    /**
     * tB^ɌĂяoB<br>
     * ̃NXł͏͍sȂȂB
     * 
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy() {
        // ɂȂ
    }

    /**
     * w肳ꂽ񂩂疖̊gq擾B
     *
     * gqȂꍇ͋󕶎ԂB
     * namenull̏ꍇnullԂB
     *
     * @param name gq̖O
     * @return gq
     */
    protected String getExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf('.');
        return (index < 0) ? "" : name.substring(index);
    }

    /**
     * NGXgAANZXp̃pXB
     *
     * ̃\bhԋpSetɊi[ꂽpXAgq`FbN̑ΏۂƂȂB<br>
     * <br>
     * ȉ̕@ŃpXB<br>
     * 1. {@link HttpServletRequest#getServletPath()}<br>
     * 2. {@link HttpServletRequest#getServletPath()} + {@link HttpServletRequest#getPathInfo()}<br>
     * {@link HttpServletRequest#getPathInfo()}null̏ꍇ́A1݂̂߂lSetɊ܂ށB<br>
     * {@link HttpServletRequest#getPathInfo()}nullłȂꍇ́A12̗߂lSetɊ܂ށB<br>
     *<br>
     * <b>{\bhg̒ӓ_F
     * {\bhԋp<code>Set</code><code>not null</code>ł邱ƁB</b>
     *
     * @param request HTTPNGXg
     * @return ANZXp̃pXSet (not null)
     */
    protected Set resolveAccessControlPath(ServletRequest request) {
        Set accessControlPaths = new HashSet();
        HttpServletRequest httpServletRequest  = (HttpServletRequest) request;
        String servletPath = httpServletRequest.getServletPath();
        accessControlPaths.add(servletPath);
        String pathInfo = httpServletRequest.getPathInfo();
        if (pathInfo != null) {
            accessControlPaths.add(servletPath + pathInfo);
        }
        return accessControlPaths;
    }
}
