/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.examples.mailreader.memory;

import java.util.HashMap;
import org.apache.struts.examples.mailreader.Subscription;
import org.apache.struts.examples.mailreader.User;
import org.apache.struts.examples.mailreader.UserDatabase;
import org.apache.struts.examples.mailreader.memory.MemorySubscription;
import org.apache.struts.examples.mailreader.memory.MemoryUserDatabase;

public final class MemoryUser
implements User {
    private MemoryUserDatabase database = null;
    private HashMap subscriptions = new HashMap();
    private String username = null;
    private String fromAddress = null;
    private String fullName = null;
    private String password = null;
    private String replyToAddress = null;

    public MemoryUser(MemoryUserDatabase database, String username) {
        this.database = database;
        this.username = username;
    }

    public UserDatabase getDatabase() {
        return this.database;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getReplyToAddress() {
        return this.replyToAddress;
    }

    public void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    public Subscription[] getSubscriptions() {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            Subscription[] results = new Subscription[this.subscriptions.size()];
            Subscription[] subscriptionArray = this.subscriptions.values().toArray(results);
            return subscriptionArray;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Subscription createSubscription(String host) {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            if (this.subscriptions.get(host) != null) {
                throw new IllegalArgumentException("Duplicate host '" + host + "' for user '" + this.username + "'");
            }
            MemorySubscription subscription = new MemorySubscription(this, host);
            HashMap hashMap2 = this.subscriptions;
            synchronized (hashMap2) {
                this.subscriptions.put(host, subscription);
            }
            MemorySubscription memorySubscription = subscription;
            return memorySubscription;
        }
    }

    public Subscription findSubscription(String host) {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            Subscription subscription = (Subscription)this.subscriptions.get(host);
            return subscription;
        }
    }

    public void removeSubscription(Subscription subscription) {
        if (this != subscription.getUser()) {
            throw new IllegalArgumentException("Subscription not associated with this user");
        }
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            this.subscriptions.remove(subscription.getHost());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<user username=\"");
        sb.append(this.username);
        sb.append("\"");
        if (this.fromAddress != null) {
            sb.append(" fromAddress=\"");
            sb.append(this.fromAddress);
            sb.append("\"");
        }
        if (this.fullName != null) {
            sb.append(" fullName=\"");
            sb.append(this.fullName);
            sb.append("\"");
        }
        if (this.password != null) {
            sb.append(" password=\"");
            sb.append(this.password);
            sb.append("\"");
        }
        if (this.replyToAddress != null) {
            sb.append(" replyToAddress=\"");
            sb.append(this.replyToAddress);
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }
}

