/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import java.util.Map;
import java.util.TreeMap;

import jp.terasoluna.fw.util.PropertyUtil;

/**
 * TERASOLUNA񋟂{@link PropertyUtil}̓ɕێĂvpeB𒼐ڑ삷邽߂̃[eBeBłB
 * 
 * <pre>
 * TerasolunaPropertyUtils.saveProperties(); // PropertyUtil̓ɕێĂvpeBۑ
 * TerasolunaPropertyUtils.addProperty(&quot;property.key&quot;, &quot;ύX̒l&quot;);
 * xxx.execute(); // s (property.key΂vpeBlgp)
 * TerasolunaPropertyUtils.restoreProperties(); // PropertyUtil̓ɕێĂvpeB𕜌
 * </pre>
 * 
 */
public final class TerasolunaPropertyUtils {

    /**
     * vpeB}bv̕ۑ}bvB
     */
    protected static final Map<String, String> savedMap = new TreeMap<String, String>();

    static {
        // [h_PropertyUtilsɕێĂ͕̂ۑMapɕۑ
        savedMap.putAll(getPropertiesMap());
    }

    /**
     * {@link PropertyUtil}̓ɕێĂvpeB}bvԋp܂B
     * 
     * @return vpeB}bv
     */
    public synchronized static Map<String, String> getPropertiesMap() {
        return ReflectionUtils.<Map<String, String>> getField(
                PropertyUtil.class, "props");
    }

    /**
     * {@link PropertyUtil}̓ɕێĂvpeB}bvɃvpeBǉ܂B
     * 
     * @param key
     *            ǉvpeB̃L[B
     * @param value
     *            ǉvpeB̒lB
     */
    public synchronized static void addProperty(String key, String value) {
        if (!savedMap.containsKey(key) && getPropertiesMap().containsKey(key)) {
            // ۑf[^̏ꍇ͕ۑ
            savedMap.put(key, getPropertiesMap().get(key));
        }
        getPropertiesMap().put(key, value);
    }

    /**
     * {@link PropertyUtil}̓ɕێĂvpeB}bvɃvpeBǉ܂B
     * 
     * @param properties
     *            ǉvpeB̃}bvB
     */
    public synchronized static void addProperties(Map<String, String> properties) {
        getPropertiesMap().putAll(properties);
    }

    /**
     * {@link PropertyUtil}̓ɕێĂvpeB}bvvpeB폜܂B
     * 
     * @param key
     *            폜vpeB̃L[B
     */
    public synchronized static void removeProperty(String key) {
        getPropertiesMap().remove(key);
    }

    /**
     * {@link PropertyUtil}̓ɕێĂvpeB}bvɂ܂B
     */
    public synchronized static void clearProperties() {
        getPropertiesMap().clear();
    }

    /**
     * {@link PropertyUtil}̓ɕێĂvpeB}bvۑ܂B
     */
    public synchronized static void saveProperties() {
        savedMap.clear();
        savedMap.putAll(getPropertiesMap());
    }

    /**
     * ۑĂvpeB}bv{@link PropertyUtil}̓ɕێĂvpeB}bvɖ߂܂B
     */
    public synchronized static void restoreProperties() {
        getPropertiesMap().clear();
        getPropertiesMap().putAll(savedMap);
    }
}
