/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * O`FbNs[eBeBNX
 * TestCase#setUp()\bhŐ邱ƂOƂ
 * 
 */
public class TestLogUtil {

    private final static Log log = LogFactory.getLog(TestLogUtil.class);

    private final String hash;

    private final String logFilePath;

    public TestLogUtil(String logFilePath) {
        // get log file path
        this.logFilePath = logFilePath;
        // get hash
        this.hash = "hash=" + new Random().nextLong() + this.hashCode();
        // mark
        this.mark();
    }

    public boolean contains(String message) throws IOException {

        // read
        String logData = this.read();

        // get hash index
        int hashIndex = logData.indexOf(this.hash);

        // check
        int index = logData.indexOf(message, hashIndex);

        return (index > 0);
    }

    protected void mark() {
        // logging
        log.fatal(this.hash);
    }

    protected String read() throws IOException {

        BufferedReader reader = null;
        try {
            //create stream
            reader =
                new BufferedReader(new FileReader(new File(this.logFilePath)));
            // create buffer
            StringBuffer fileBuffer = new StringBuffer();
            String lineBuffer = null;

            // file read
            while ((lineBuffer = reader.readLine()) != null) {
                // append
                fileBuffer.append(lineBuffer);
            }

            return fileBuffer.toString();
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

}
