/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.context;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.context.RequestContext}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * NGXgEƖvpeBێ邽߂̃NXB<br>
 * OF
 * <p>
 *
 * @see jp.terasoluna.fw.web.rich.context.RequestContext
 */
public class RequestContextTest extends TestCase {

    private RequestContext context = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(RequestContextTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        context = new RequestContext();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public RequestContextTest(String name) {
        super(name);
    }

    /**
     * testGetRequestName01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() this.requestName:"sum"<br>
     *
     * <br>
     * ҒlF(߂l) String:this.requestName<br>
     *
     * <br>
     * requestNamegetter\bh̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetRequestName01() throws Exception {
        // O
        UTUtil.setPrivateField(context, "requestName", "sum");

        // eXg{
        Object result = context.getRequestName();

        // 
        assertEquals("sum", result);
    }

    /**
     * testSetRequestName01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() requestName:"sum"<br>
     *         () this.requestName:null<br>
     *
     * <br>
     * ҒlF(ԕω) this.requestName:Őݒ肵l<br>
     *
     * <br>
     * requestNamesetter\bh̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetRequestName01() throws Exception {
        // O
        UTUtil.setPrivateField(context, "requestName", null);

        // eXg{
        context.setRequestName("sum");

        // 
        assertEquals("sum", UTUtil.getPrivateField(context, "requestName"));
    }

    /**
     * testGetProperty01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() key:"sampleKey"<br>
     *         () this.propertyMap:HashMap<br>
     *                (sampleKey=sampleValue)<br>
     *
     * <br>
     * ҒlF(߂l) String:"sampleValue"<br>
     *
     * <br>
     * propertiesgetter\bh̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetProperty01() throws Exception {
        // O
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("sampleKey", "sampleValue");
        UTUtil.setPrivateField(context, "propertyMap", map);

        // eXg{
        // 
        assertEquals("sampleValue", context.getProperty("sampleKey"));
    }

    /**
     * testSetProperty01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() key:"sampleKey"<br>
     *         () value:new Object()<br>
     *         () this.propertyMap:HashMap<br>
     *                ()<br>
     *
     * <br>
     * ҒlF(ԕω) this.propertyMap:HashMap<br>
     *                    (sampleKey=sampleValue)<br>
     *
     * <br>
     * propertiessetter\bh̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetProperty01() throws Exception {
        // O
    	Map<String, Object> map = new HashMap<String, Object>();
        UTUtil.setPrivateField(context, "propertyMap", map);
        Object object = new Object();

        // eXg{
        context.setProperty("sampleKey", object);

        // 
        Map result =
            (Map) UTUtil.getPrivateField(context, "propertyMap");
        assertSame(object, result.get("sampleKey"));
    }

    /**
     * testGetPropertyString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() key:"sampleKey"<br>
     *         () getProperty(String):"sampleValue"<br>
     *
     * <br>
     * ҒlF(߂l) String:"sampleValue"<br>
     * @@@@(ԕω) key:"sampleKey"nꂽƂmFB<br>
     *
     * <br>
     * getProperty(String)Ăяoƒl̎󂯎̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyString01() throws Exception {
        // O
    	RequestContextStub01 target = new RequestContextStub01();
    	
        // X^uԋpl̐ݒ
    	target.value = "sampleValue";
    	
        // eXg{
        String resulet = target.getPropertyString("sampleKey");

        // 
        assertEquals("sampleKey",target.key);
        assertEquals("sampleValue",resulet);
    }
    
    /**
     * testGetPropertyString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() key:"sampleKey"<br>
     *         () getProperty(String):new Object()<br>
     *
     * <br>
     * ҒlF(߂l) String:null<br>
     * @@@@(ԕω) key:"sampleKey"nꂽƂmFB<br>
     * <br>
     * vpeBIuWFNgString^łȂꍇ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyString02() throws Exception {
        // O
    	RequestContextStub01 target = new RequestContextStub01();
    	
        // X^uԋpl̐ݒ
    	target.value = new Object();
    	
        // eXg{
        String resulet = target.getPropertyString("sampleKey");

        // 
        assertEquals("sampleKey",target.key);
        assertNull(resulet);
    }
    
    /**
     * testSetPropertyString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() key:"sampleKey"<br>
     *         () value:"sampleValue"<br>
     *
     * <br>
     * ҒlF(ԕω) key:"sampleKey"nꂽƂmFB<br>
     *                    value:"sampleValue"nꂽƂmFB<br>
     * <br>
     * setProperty(String,String)ĂяõeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetPropertyString01() throws Exception {
        // O
    	RequestContextStub01 target = new RequestContextStub01();

        // eXg{
        target.setPropertyString("sampleKey", "sampleValue");

        // 
        assertEquals("sampleKey",target.key);
        assertEquals("sampleValue",target.value);
    }
    
    /**
     * testToString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() this.requestName:"command"<br>
     *         () this.properties:Properties<br>
     *                (sampleKey1=sampleValue1<br>
     *
     * <br>
     * ҒlF(߂l) String:"requestName:commandisj<br>
     *                  properties:{sampleKey1=sampleValue1}"<br>
     *
     * <br>
     * toString̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testToString01() throws Exception {
        // O
        UTUtil.setPrivateField(context, "requestName", "command");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("sampleKey1", "sampleValue1");
        UTUtil.setPrivateField(context, "propertyMap", map);

        // eXg{
        String result = context.toString();

        // 
        String expect = "requestName:command" +
                ",properties:{sampleKey1=sampleValue1}";
        assertEquals(expect, result);
    }

}
