/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.util.Map;
import java.util.TreeMap;
import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;

public class SystemEnvUtils {
    protected static final Class<?> processEnvironmentClass;
    protected static final Map<String, String> env;
    protected static final Map<String, String> savedMap;

    public static synchronized void setEnv(String key, String value) {
        env.put(key, value);
    }

    public static synchronized void removeEnv(String key) {
        env.remove(key);
    }

    public static synchronized void restoreEnv() {
        env.clear();
        env.putAll(savedMap);
    }

    static {
        savedMap = new TreeMap<String, String>();
        try {
            processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
        }
        catch (ClassNotFoundException e) {
            throw new UTRuntimeException(e);
        }
        env = (Map)ReflectionUtils.getField(processEnvironmentClass, "theCaseInsensitiveEnvironment");
        savedMap.putAll(env);
    }
}

