/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.requestanalysis.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

import jp.terasoluna.rich.functionsample.common.bean.StringBean;

/**
 * NGXgf[^̓NX
 *
 */
public class RequestAnalysisData implements Serializable {

    /**
     * VAo[WID 
     */
    private static final long serialVersionUID = -3430337164884595292L;

    /**
     * java.lang.String eXgl
     */
    private String stringClass = null;

    /**
     * booleandeXgl
     */
    private boolean booleanExample = false;
    
    /**
     * doubleeXgl
     */
    private double doubleExample = 0D;
    
    /**
     * floateXgl
     */
    private float floatExample = 0F;
    
    /**
     * inteXgl
     */
    private int intExample = 0;
    
    /**
     * longeXgl
     */
    private long longExample = 0L;
    
    /**
     * shorteXgl
     */
    private short shortExample = 0;
    
    /**
     * byteeXgl
     */
    private byte byteExample = 0;
    
    /**
     * chareXgl
     */
    private char charExample = 0;
    
    /**
     * java.lang.CharactereXgl
     */
    private Character characterClass = null;

    /**
     * java.lang.IntegereXgl
     */
    private Integer integerClass = null;
    
    /**
     * java.lang.BooleaneXgl
     */
    private Boolean booleanClass = null;
    
    /**
     * java.lang.ByteeXgl
     */
    private Byte byteClass = null;
    
    /**
     * java.lang.DoubleeXgl
     */
    private Double doubleClass = null;
    
    /**
     * java.lang.LongeXgl
     */
    private Long longClass = null;
    
    /**
     * java.lang.FloateXgl
     */
    private Float floatClass = null;
    
    /**
     * java.lang.ShorteXgl
     */
    private Short shortClass = null;
    
    /**
     * java.util.DateeXgl
     */
    private Date dateClass = null;
    
    /**
     * java.math.BigDecimaleXgl
     */
    private BigDecimal bigDecimalClass = null;
    
    /**
     * java.lang.StringzeXgl
     */
    private String[] arrayClass = null;
    
    /**
     * java.util.ArrayListzeXgl
     */
    private ArrayList arrayListClass = new ArrayList();

    /**
     * JavaBeaneXgl
     */
    private StringBean beanClass = new StringBean();

    /**
     * JavaBeanzeXgl
     */
    private StringBean[] beanArrayClass = null;

    /**
     * beanArrayClass擾B
     * @return beanArrayClass
     */
    public StringBean[] getBeanArrayClass() {
        return beanArrayClass;
    }

    /**
     * beanArrayClassݒ肷B
     * @param beanArrayClass beanArrayClass
     */
    public void setBeanArrayClass(StringBean[] beanArrayClass) {
        this.beanArrayClass = beanArrayClass;
    }

    /**
     * beanClass擾B
     * @return beanClass
     */
    public StringBean getBeanClass() {
        return beanClass;
    }

    /**
     * beanClassݒ肷B
     * @param beanClass beanArrayClass
     */
    public void setBeanClass(StringBean beanClass) {
        this.beanClass = beanClass;
    }

    /**
     * dateClass擾B
     * @return dateClass
     */
    public Date getDateClass() {
        return dateClass;
    }

    /**
     * dateClassݒ肷B
     * @param dateClass dateClass
     */
    public void setDateClass(Date dateClass) {
        this.dateClass = dateClass;
    }

    /**
     * booleanExample擾B
     * @return booleaneXgl
     */
    public boolean getBooleanExample() {
        return booleanExample;
    }

    /**
     * booleanExampleݒ肷B
     * @param booleanExample booleaneXgl
     */
    public void setBooleanExample(boolean booleanExample) {
        this.booleanExample = booleanExample;
    }

    /**
     * byteExample擾B
     * @return byteeXgl
     */
    
    public byte getByteExample() {
        return byteExample;
    }

    /**
     * byteExampleݒ肷B
     * @param byteExample byteeXgl
     */
    
    public void setByteExample(byte byteExample) {
        this.byteExample = byteExample;
    }

    /**
     * doubleExample擾B
     * @return doubleeXgl
     */
    
    public double getDoubleExample() {
        return doubleExample;
    }

    /**
     * doubleExampleݒ肷B
     * @param doubleExample doubleeXgl
     */
    
    public void setDoubleExample(double doubleExample) {
        this.doubleExample = doubleExample;
    }

    /**
     * floatExample擾B
     * @return floateXgl
     */
    
    public float getFloatExample() {
        return floatExample;
    }

    /**
     * floatExampleݒ肷B
     * @param floatExample floateXgl
     */
    
    public void setFloatExample(float floatExample) {
        this.floatExample = floatExample;
    }

    /**
     * intExample擾B
     * @return inteXgl
     */
    
    public int getIntExample() {
        return intExample;
    }

    /**
     * intExampleݒ肷B
     * @param intExample inteXgl
     */
    
    public void setIntExample(int intExample) {
        this.intExample = intExample;
    }

    /**
     * longExample擾B
     * @return longeXgl
     */
    
    public long getLongExample() {
        return longExample;
    }

    /**
     * longExampleݒ肷B
     * @param longExample longeXgl
     */
    
    public void setLongExample(long longExample) {
        this.longExample = longExample;
    }

    /**
     * shortExample擾B
     * @return shorteXgl
     */
    
    public short getShortExample() {
        return shortExample;
    }

    /**
     * shortExampleݒ肷B
     * @param shortExample shorteXgl
     */
    
    public void setShortExample(short shortExample) {
        this.shortExample = shortExample;
    }

    /**
     * booleanClass擾B
     * @return java.lang.BooleaneXgl
     */
    
    public Boolean getBooleanClass() {
        return booleanClass;
    }

    /**
     * booleanClassݒ肷B
     * @param booleanClass java.lang.BooleaneXgl
     */
    
    public void setBooleanClass(Boolean booleanClass) {
        this.booleanClass = booleanClass;
    }

    /**
     * byteClass擾B
     * @return java.lang.ByteeXgl
     */
    
    public Byte getByteClass() {
        return byteClass;
    }

    /**
     * byteClassݒ肷B
     * @param byteClass java.lang.ByteeXgl
     */
    
    public void setByteClass(Byte byteClass) {
        this.byteClass = byteClass;
    }

    /**
     * doubleClass擾B
     * @return java.lang.DoubleeXgl
     */
    
    public Double getDoubleClass() {
        return doubleClass;
    }

    /**
     * doubleClassݒ肷B
     * @param doubleClass java.lang.DoubleeXgl
     */
    
    public void setDoubleClass(Double doubleClass) {
        this.doubleClass = doubleClass;
    }

    /**
     * floatClass擾B
     * @return java.lang.FloateXgl
     */
    
    public Float getFloatClass() {
        return floatClass;
    }

    /**
     * floatClassݒ肷B
     * @param floatClass java.lang.FloateXgl
     */
    
    public void setFloatClass(Float floatClass) {
        this.floatClass = floatClass;
    }

    /**
     * integerClass擾B
     * @return java.lang.IntegereXgl
     */
    public Integer getIntegerClass() {
        return integerClass;
    }

    /**
     * integerClassݒ肷B
     * @param integerClass java.lang.IntegereXgl
     */
    public void setIntegerClass(Integer integerClass) {
        this.integerClass = integerClass;
    }

    /**
     * stringClass擾B
     * @return java.lang.StringeXgl
     */
    public String getStringClass() {
        return stringClass;
    }

    /**
     * stringClassݒ肷B
     * @param stringClass java.lang.StringeXgl
     */
    public void setStringClass(String stringClass) {
        this.stringClass = stringClass;
    }

    /**
     * longClass擾B
     * @return java.lang.LongeXgl
     */
    
    public Long getLongClass() {
        return longClass;
    }

    /**
     * longClassݒ肷B
     * @param longClass java.lang.LongeXgl
     */
    
    public void setLongClass(Long longClass) {
        this.longClass = longClass;
    }

    /**
     * shortClass擾B
     * @return java.lang.ShorteXgl
     */
    
    public Short getShortClass() {
        return shortClass;
    }

    /**
     * shortClassݒ肷B
     * @param shortClass java.lang.ShorteXgl
     */
    
    public void setShortClass(Short shortClass) {
        this.shortClass = shortClass;
    }

    /**
     * characterClass擾B
     * @return java.lang.CharactereXgl
     */
    
    public Character getCharacterClass() {
        return characterClass;
    }

    /**
     * characterClassݒ肷B
     * @param characterClass java.lang.CharactereXgl
     */
    
    public void setCharacterClass(Character characterClass) {
        this.characterClass = characterClass;
    }

    /**
     * charExample擾B
     * @return chareXgl
     */
    
    public char getCharExample() {
        return charExample;
    }

    /**
     * charExampleݒ肷B
     * @param charExample chareXgl
     */
    
    public void setCharExample(char charExample) {
        this.charExample = charExample;
    }
    
    /**
     * arrayClass擾B
     * @return StringzeXgl
     */
    public String[] getArrayClass() {
        return arrayClass;
    }

    /**
     * arrayClassݒ肷B
     * @param arrayClass StringzeXgl
     */
    public void setArrayClass(String[] arrayClass) {
        this.arrayClass = arrayClass;
    }

    /**
     * arrayListClass擾B
     * @return arrayListClasszeXgl
     */
    public ArrayList getArrayListClass() {
        return arrayListClass;
    }

    /**
     * arrayListClassݒ肷B
     * @param arrayListClass arrayListClasszeXgl
     */
    public void setArrayListClass(ArrayList arrayListClass) {
        this.arrayListClass = arrayListClass;
    }

    /**
     * arrayListClassݒ肷B
     * @param arrayListClass arrayListClasszeXgl
     */
    public void addArrayListClass(Object object) {
        this.arrayListClass.add(object);
    }
    
    /**
     * bigDecimalClass擾B
     * @return bigDecimalClass
     */
    public BigDecimal getBigDecimalClass() {
        return bigDecimalClass;
    }

    /**
     * bigDecimalClassݒ肷B
     * @param bigDecimalClass bigDecimalClass
     */
    public void setBigDecimalClass(BigDecimal bigDecimalClass) {
        this.bigDecimalClass = bigDecimalClass;
    }
}
