/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
EmbeddedValueResolverAware,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private Object scheduler;
    private StringValueResolver embeddedValueResolver;
    private ApplicationContext applicationContext;
    private final ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
    private final Map<Class<?>, Boolean> nonAnnotatedClasses = new ConcurrentHashMap(64);

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() != this.applicationContext) {
            return;
        }
        if (this.scheduler != null) {
            this.registrar.setScheduler(this.scheduler);
        }
        Map configurers = this.applicationContext.getBeansOfType(SchedulingConfigurer.class);
        for (SchedulingConfigurer configurer : configurers.values()) {
            configurer.configureTasks(this.registrar);
        }
        if (this.registrar.hasTasks() && this.registrar.getScheduler() == null) {
            HashMap schedulers = new HashMap();
            schedulers.putAll(this.applicationContext.getBeansOfType(TaskScheduler.class));
            schedulers.putAll(this.applicationContext.getBeansOfType(ScheduledExecutorService.class));
            if (schedulers.size() != 0) {
                if (schedulers.size() == 1) {
                    this.registrar.setScheduler(schedulers.values().iterator().next());
                } else if (schedulers.size() >= 2) {
                    throw new IllegalStateException("More than one TaskScheduler and/or ScheduledExecutorService  exist within the context. Remove all but one of the beans; or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback. Found the following beans: " + schedulers.keySet());
                }
            }
        }
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) {
        if (!this.nonAnnotatedClasses.containsKey(bean.getClass())) {
            final LinkedHashSet annotatedMethods = new LinkedHashSet(1);
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    Scheduled scheduled = (Scheduled)AnnotationUtils.getAnnotation((Method)method, Scheduled.class);
                    if (scheduled != null) {
                        ScheduledAnnotationBeanPostProcessor.this.processScheduled(scheduled, method, bean);
                        annotatedMethods.add(method);
                    }
                }
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.put(bean.getClass(), Boolean.TRUE);
            }
        }
        return bean;
    }

    private void processScheduled(Scheduled scheduled, Method method, Object bean) {
        try {
            String fixedRateString;
            long fixedRate;
            String fixedDelayString;
            long fixedDelay;
            String cron;
            Assert.isTrue((boolean)Void.TYPE.equals(method.getReturnType()), (String)"Only void-returning methods may be annotated with @Scheduled");
            Assert.isTrue((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Only no-arg methods may be annotated with @Scheduled");
            if (AopUtils.isJdkDynamicProxy((Object)bean)) {
                try {
                    method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (SecurityException ex) {
                    ReflectionUtils.handleReflectionException((Exception)ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalStateException(String.format("@Scheduled method '%s' found on bean target class '%s' but not found in any interface(s) for a dynamic proxy. Either pull the method up to a declared interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()));
                }
            } else if (AopUtils.isCglibProxy((Object)bean) && Modifier.isPrivate(method.getModifiers())) {
                LogFactory.getLog(ScheduledAnnotationBeanPostProcessor.class).warn((Object)String.format("@Scheduled method '%s' found on CGLIB proxy for target class '%s' but cannot be delegated to target bean. Switch its visibility to package or protected.", method.getName(), method.getDeclaringClass().getSimpleName()));
            }
            ScheduledMethodRunnable runnable = new ScheduledMethodRunnable(bean, method);
            boolean processedSchedule = false;
            String errorMessage = "Exactly one of the 'cron', 'fixedDelay(String)', or 'fixedRate(String)' attributes is required";
            long initialDelay = scheduled.initialDelay();
            String initialDelayString = scheduled.initialDelayString();
            if (StringUtils.hasText((String)initialDelayString)) {
                Assert.isTrue((initialDelay < 0L ? 1 : 0) != 0, (String)"Specify 'initialDelay' or 'initialDelayString', not both");
                if (this.embeddedValueResolver != null) {
                    initialDelayString = this.embeddedValueResolver.resolveStringValue(initialDelayString);
                }
                try {
                    initialDelay = Integer.parseInt(initialDelayString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid initialDelayString value \"" + initialDelayString + "\" - cannot parse into integer");
                }
            }
            if (StringUtils.hasText((String)(cron = scheduled.cron()))) {
                Assert.isTrue((initialDelay == -1L ? 1 : 0) != 0, (String)"'initialDelay' not supported for cron triggers");
                processedSchedule = true;
                if (this.embeddedValueResolver != null) {
                    cron = this.embeddedValueResolver.resolveStringValue(cron);
                }
                this.registrar.addCronTask(new CronTask((Runnable)runnable, cron));
            }
            if (initialDelay < 0L) {
                initialDelay = 0L;
            }
            if ((fixedDelay = scheduled.fixedDelay()) >= 0L) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                this.registrar.addFixedDelayTask(new IntervalTask(runnable, fixedDelay, initialDelay));
            }
            if (StringUtils.hasText((String)(fixedDelayString = scheduled.fixedDelayString()))) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                if (this.embeddedValueResolver != null) {
                    fixedDelayString = this.embeddedValueResolver.resolveStringValue(fixedDelayString);
                }
                try {
                    fixedDelay = Integer.parseInt(fixedDelayString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid fixedDelayString value \"" + fixedDelayString + "\" - cannot parse into integer");
                }
                this.registrar.addFixedDelayTask(new IntervalTask(runnable, fixedDelay, initialDelay));
            }
            if ((fixedRate = scheduled.fixedRate()) >= 0L) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                this.registrar.addFixedRateTask(new IntervalTask(runnable, fixedRate, initialDelay));
            }
            if (StringUtils.hasText((String)(fixedRateString = scheduled.fixedRateString()))) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                if (this.embeddedValueResolver != null) {
                    fixedRateString = this.embeddedValueResolver.resolveStringValue(fixedRateString);
                }
                try {
                    fixedRate = Integer.parseInt(fixedRateString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid fixedRateString value \"" + fixedRateString + "\" - cannot parse into integer");
                }
                this.registrar.addFixedRateTask(new IntervalTask(runnable, fixedRate, initialDelay));
            }
            Assert.isTrue((boolean)processedSchedule, (String)errorMessage);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Encountered invalid @Scheduled method '" + method.getName() + "': " + ex.getMessage());
        }
    }

    public void destroy() throws Exception {
        this.registrar.destroy();
    }
}

