/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.oxm.xsd.xerces;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import jp.terasoluna.fw.oxm.xsd.exception.IllegalSchemaDefinitionException;
import jp.terasoluna.fw.oxm.xsd.exception.UnknownXMLDataException;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessage;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLErrorReporterEx
extends XMLErrorReporter {
    private static Log log = LogFactory.getLog(XMLErrorReporterEx.class);
    private Map<String, Integer> tagIndex = new HashMap<String, Integer>();
    private Stack<String> tagStack = new Stack();
    private ErrorMessages errorMessages = null;
    protected static final String XERCES_RESOURCE_BUNDLE_PREFIX = "org/apache/xerces/impl/msg/XMLSchemaMessages";
    protected static final String ALLOW_EMPTY_SUFFIX = "AllowEmpty";
    protected static final String ERROR_CODE_PREFIX = "typeMismatch";
    protected static final String ATTRIBUTE_ERROR_CODE = "cvc-attribute.3";
    protected static final String ELEMENT_ERROR_CODE = "cvc-type.3.1.3";
    protected static final String DATATYPE_ERROR_CODE = "cvc-datatype-valid.1.2.1";
    protected static final String UNION_ERROR_CODE = "cvc-datatype-valid.1.2.3";
    protected static final String MAXINCLUSIVE_ERROR_CODE = "cvc-maxInclusive-valid";
    protected static final String MININCLUSIVE_ERROR_CODE = "cvc-minInclusive-valid";
    protected static final String XML_DATA_ERROR_CODE_PREFIX = "cvc-";
    protected static final String NUMBER_ERROR_CODE = "number";
    protected static final String BOOLEAN_ERROR_CODE = "boolean";
    protected static final String DATE_ERROR_CODE = "date";
    protected static final String NUMBERMINRANGE_ERROR_CODE = "numberMinRange";
    protected static final String NUMBERMAXRANGE_ERROR_CODE = "numberMaxRange";
    protected static final String FIELD_SEPARATOR = ".";
    protected static final String ERROR_CODE_SEPARATOR = ".";
    protected static final String DATATYPE_BOOLEAN = "boolean";
    protected static final List DATATYPE_DATE = Arrays.asList("date", "time", "dateTime");
    private ErrorMessage tmpErrorMessage = null;

    public XMLErrorReporterEx(ErrorMessages errorMessages) {
        this.errorMessages = errorMessages;
    }

    public ErrorMessages getErrorMessages() {
        return this.errorMessages;
    }

    public void reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity) throws XNIException {
        super.reportError(location, domain, key, arguments, severity);
        Object[] options = null;
        if (arguments == null) {
            options = new String[]{};
        } else {
            options = new String[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                options[i] = arguments[i] == null ? null : arguments[i].toString();
                ++i;
            }
        }
        this.errorLog(key, options);
        this.addErrorMessage(key, (String[])options);
    }

    protected String indexResolve(String element) {
        Integer index = 0;
        StringBuilder tagIndexKey = new StringBuilder(this.getField());
        tagIndexKey.append(element);
        Integer val = this.tagIndex.get(tagIndexKey.toString());
        if (val != null) {
            index = val + 1;
        }
        this.tagIndex.put(tagIndexKey.toString(), index);
        StringBuilder retStr = new StringBuilder();
        retStr.append(element);
        retStr.append("[");
        retStr.append(index);
        retStr.append("]");
        return retStr.toString();
    }

    private String getField() {
        StringBuilder key = new StringBuilder();
        for (String tagstr : this.tagStack) {
            key.append(tagstr);
            key.append(".");
        }
        return key.toString();
    }

    protected void addErrorMessage(String key, String[] options) {
        String messageID = null;
        if (ELEMENT_ERROR_CODE.equals(key)) {
            return;
        }
        if (ATTRIBUTE_ERROR_CODE.equals(key)) {
            if (this.tmpErrorMessage != null) {
                StringBuilder fieldStr = new StringBuilder();
                fieldStr.append(this.tmpErrorMessage.getField());
                fieldStr.append(".");
                fieldStr.append(options[1]);
                this.tmpErrorMessage.setField(fieldStr.toString());
            }
            return;
        }
        if (DATATYPE_ERROR_CODE.equals(key)) {
            messageID = "boolean".equals(options[1]) ? "typeMismatch.boolean" : (DATATYPE_DATE.contains(options[1]) ? "typeMismatch.date" : "typeMismatch.number");
        } else if (UNION_ERROR_CODE.equals(key) && options[1].endsWith(ALLOW_EMPTY_SUFFIX)) {
            options[1] = options[1].substring(0, options[1].indexOf(ALLOW_EMPTY_SUFFIX));
            messageID = "typeMismatch.number";
            String[] tmpOptions = new String[2];
            System.arraycopy(options, 0, tmpOptions, 0, 2);
            options = tmpOptions;
        } else if (MAXINCLUSIVE_ERROR_CODE.equals(key)) {
            messageID = "typeMismatch.numberMaxRange";
        } else if (MININCLUSIVE_ERROR_CODE.equals(key)) {
            messageID = "typeMismatch.numberMinRange";
        } else {
            if (key.startsWith(XML_DATA_ERROR_CODE_PREFIX)) {
                log.error((Object)"xml data is invalid.");
                throw new UnknownXMLDataException();
            }
            log.error((Object)"schema is invalid.");
            throw new IllegalSchemaDefinitionException();
        }
        ErrorMessage errorMessage = new ErrorMessage(messageID, "", options);
        errorMessage.setField(this.getField().substring(0, this.getField().length() - 1));
        this.errorMessages.add(errorMessage);
        this.tmpErrorMessage = errorMessage;
    }

    protected void errorLog(String key, Object[] options) {
        StringBuilder buf = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        buf.append("Schema error[]------------------------");
        buf.append(lineSeparator);
        if (this.getField().length() > 0) {
            buf.append("xpath=" + this.getField().substring(0, this.getField().length() - 1));
        } else {
            buf.append("xpath=" + this.getField());
        }
        buf.append(lineSeparator);
        buf.append("getMessage=");
        buf.append(this.getMessage(key, options));
        buf.append(lineSeparator);
        buf.append("key=");
        buf.append(key);
        buf.append(lineSeparator);
        StringBuilder argNo = new StringBuilder();
        int i = 0;
        while (i < options.length) {
            argNo.setLength(0);
            argNo.append("arg[");
            argNo.append(i);
            argNo.append("]=");
            buf.append(argNo.toString());
            buf.append(options[i]);
            buf.append(lineSeparator);
            ++i;
        }
        buf.append("-----------------------------------------");
        buf.append(lineSeparator);
        log.error((Object)buf.toString());
    }

    private String getMessage(String key, Object[] options) {
        String message = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(XERCES_RESOURCE_BUNDLE_PREFIX);
            message = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "[[" + e.getMessage() + "]]";
        }
        return MessageFormat.format(message, options);
    }

    public Stack<String> getTagStack() {
        return this.tagStack;
    }
}

