/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandlerExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    private static final String HEADER_PRAGMA = "Pragma";
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Set<?> mappedHandlers;
    private Class[] mappedHandlerClasses;
    private Log warnLogger;
    private boolean preventResponseCaching = false;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setMappedHandlers(Set<?> mappedHandlers) {
        this.mappedHandlers = mappedHandlers;
    }

    public void setMappedHandlerClasses(Class[] mappedHandlerClasses) {
        this.mappedHandlerClasses = mappedHandlerClasses;
    }

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = LogFactory.getLog((String)loggerName);
    }

    public void setPreventResponseCaching(boolean preventResponseCaching) {
        this.preventResponseCaching = preventResponseCaching;
    }

    @Override
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.shouldApplyTo(request, handler)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving exception from handler [" + handler + "]: " + ex));
            }
            this.logException(ex, request);
            this.prepareResponse(ex, response);
            return this.doResolveException(request, response, handler, ex);
        }
        return null;
    }

    protected boolean shouldApplyTo(HttpServletRequest request, Object handler) {
        if (handler != null) {
            if (this.mappedHandlers != null && this.mappedHandlers.contains(handler)) {
                return true;
            }
            if (this.mappedHandlerClasses != null) {
                for (Class handlerClass : this.mappedHandlerClasses) {
                    if (!handlerClass.isInstance(handler)) continue;
                    return true;
                }
            }
        }
        return this.mappedHandlers == null && this.mappedHandlerClasses == null;
    }

    protected void logException(Exception ex, HttpServletRequest request) {
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn((Object)this.buildLogMessage(ex, request), (Throwable)ex);
        }
    }

    protected String buildLogMessage(Exception ex, HttpServletRequest request) {
        return "Handler execution resulted in exception";
    }

    protected void prepareResponse(Exception ex, HttpServletResponse response) {
        if (this.preventResponseCaching) {
            this.preventCaching(response);
        }
    }

    protected void preventCaching(HttpServletResponse response) {
        response.setHeader(HEADER_PRAGMA, "no-cache");
        response.setDateHeader(HEADER_EXPIRES, 1L);
        response.setHeader(HEADER_CACHE_CONTROL, "no-cache");
        response.addHeader(HEADER_CACHE_CONTROL, "no-store");
    }

    protected abstract ModelAndView doResolveException(HttpServletRequest var1, HttpServletResponse var2, Object var3, Exception var4);
}

