/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.batch.tutorial.common;

import java.util.Date;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;

/**
 * õp[^NXB
 */
@FileFormat(overWriteFlg = true, fileEncoding = "MS932")
public class NyusyukkinData {

	/**
	 * xX
	 */
	@InputFileColumn(columnIndex = 0)
	@OutputFileColumn(columnIndex = 0)
	private String shitenName;

	/**
	 * ڋqID
	 */
	@InputFileColumn(columnIndex = 1)
	@OutputFileColumn(columnIndex = 1)
	private String kokyakuId;

	/**
	 * o敪 0:o 1:
	 */
	@InputFileColumn(columnIndex = 2)
	@OutputFileColumn(columnIndex = 2)
	private int nyusyukkinKubun;

	/**
	 * z
	 */
	@InputFileColumn(columnIndex = 3)
	@OutputFileColumn(columnIndex = 3)
	private int kingaku;

	/**
	 * 
	 */
	@InputFileColumn(columnIndex = 4, columnFormat = "yyyyMMdd")
	@OutputFileColumn(columnIndex = 4, columnFormat = "yyyyMMdd")
	private Date torihikibi;

	/**
	 * xX擾B
	 * 
	 * @return shitenName
	 */
	public String getShitenName() {
		return shitenName;
	}

	/**
	 * xXݒ肷B
	 * 
	 * @param shitenName
	 */
	public void setShitenName(String shitenName) {
		this.shitenName = shitenName;
	}

	/**
	 * ڋqID擾B
	 * 
	 * @return kokyakuId
	 */
	public String getKokyakuId() {
		return kokyakuId;
	}

	/**
	 * ڋqIDݒ肷B
	 * 
	 * @param kokyakuId
	 */
	public void setKokyakuId(String kokyakuId) {
		this.kokyakuId = kokyakuId;
	}

	/**
	 * o敪擾B
	 * 
	 * @return nyusyukkinKubun
	 */
	public int getNyusyukkinKubun() {
		return nyusyukkinKubun;
	}

	/**
	 * o敪ݒ肷B
	 * 
	 * @param nyusyukkinKubun
	 */
	public void setNyusyukkinKubun(int nyusyukkinKubun) {
		this.nyusyukkinKubun = nyusyukkinKubun;
	}

	/**
	 * z擾B
	 * 
	 * @return kingaku
	 */
	public int getKingaku() {
		return kingaku;
	}

	/**
	 * zݒ肷B
	 * 
	 * @param kingaku
	 */
	public void setKingaku(int kingaku) {
		this.kingaku = kingaku;
	}

	/**
	 * 擾B
	 * 
	 * @return torihikibi
	 */
	public Date getTorihikibi() {
		return torihikibi;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param torihikibi
	 */
	public void setTorihikibi(Date torihikibi) {
		this.torihikibi = torihikibi;
	}
}