package jp.terasoluna.fw.batch.executor;

import jp.terasoluna.fw.batch.executor.SecurityManagerEx.ExitException;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;
import jp.terasoluna.fw.ex.unit.util.SystemEnvUtils;
import junit.framework.TestCase;

public class SyncBatchExecutorTest extends TestCase {

    final SecurityManager sm = System.getSecurityManager();

    public SyncBatchExecutorTest() {
        super();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        System.setSecurityManager(new SecurityManagerEx());
    }

    @Override
    protected void tearDown() throws Exception {
        SystemEnvUtils.restoreEnv();
        System.setSecurityManager(sm);
        super.tearDown();
    }

    /**
     * maineXg01yُnz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋Nfoon
     * EbeansDef/foo.xml݂Ȃ
     * mF
     * EIR[h-1ł邱
     * EIDWAL025002WARNOo͂邱
     * </pre>
     * @throws Exception
     */
    public void testMain01() throws Exception {
        try {
            SyncBatchExecutor.main(new String[] { "foo" });
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(-1, e.state);
        }
    }

    /**
     * maineXg02ynz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋NTestSyncBatchExecutor01n
     * EbeansDef/TestSyncBatchExecutor01.xml݂
     * EbeanNameTestSyncBatchExecutor01Bean[h
     * mF
     * EIR[h100ł邱
     * </pre>
     * @throws Exception
     */
    public void testMain02() throws Exception {
        try {
            SyncBatchExecutor.main(new String[] { "TestSyncBatchExecutor01" });
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(100, e.state);
        }
    }

    /**
     * maineXg03yُnz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋NɉnȂ
     * EϐJOB_APP_CDݒ
     * mF
     * EIR[h-1ł邱
     * </pre>
     * @throws Exception
     */
    public void testMain03() throws Exception {
        try {
            SystemEnvUtils.removeEnv(SyncBatchExecutor.ENV_JOB_APP_CD);
            SyncBatchExecutor.main(new String[] {});
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(-1, e.state);
        }
    }

    /**
     * maineXg04yُnz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋NɉnȂ
     * EϐJOB_APP_CDTestSyncBatchExecutor01n
     * EbeansDef/TestSyncBatchExecutor01.xml݂
     * EbeanNameTestSyncBatchExecutor01Bean[h
     * mF
     * EIR[h100ł邱
     * </pre>
     * @throws Exception
     */
    public void testMain04() throws Exception {
        try {
            SystemEnvUtils.setEnv(SyncBatchExecutor.ENV_JOB_APP_CD,
                    "TestSyncBatchExecutor01");
            SyncBatchExecutor.main(new String[] {});
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(100, e.state);
        }
    }

    /**
     * maineXg05ynz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋NTestSyncBatchExecutor01 param1 param2 param3 param4 param5 param6 param7 param8 param9 param10 param11 param12 param13 param14 param15 param16 param17 param18 param19 param20 n
     * EbeansDef/TestSyncBatchExecutor01.xml݂
     * EbeanNameTestSyncBatchExecutor01Bean[h
     * mF
     * Eparam1`20܂ID:DAL025044̃Oɏo͂邱
     * EIR[h100ł邱
     * </pre>
     * @throws Exception
     */
    public void testMain05() throws Exception {
        try {
            SyncBatchExecutor.main(new String[] { "TestSyncBatchExecutor01",
                    "param1", "param2", "param3", "param4", "param5", "param6",
                    "param7", "param8", "param9", "param10", "param11",
                    "param12", "param13", "param14", "param15", "param16",
                    "param17", "param18", "param19", "param20" });
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(100, e.state);
        }
    }

    /**
     * maineXg06ynz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋NTestSyncBatchExecutor01 param1 param2 param3 param4 param5 param6 param7 param8 param9 param10 param11 param12 param13 param14 param15 param16 param17 param18 param19 param20 param21n
     * EbeansDef/TestSyncBatchExecutor01.xml݂
     * EbeanNameTestSyncBatchExecutor01Bean[h
     * mF
     * Eparam1`20܂ID:DAL025044̃Oɏo͂邱
     * EIR[h100ł邱
     * </pre>
     * @throws Exception
     */
    public void testMain06() throws Exception {
        try {
            SyncBatchExecutor.main(new String[] { "TestSyncBatchExecutor01",
                    "param1", "param2", "param3", "param4", "param5", "param6",
                    "param7", "param8", "param9", "param10", "param11",
                    "param12", "param13", "param14", "param15", "param16",
                    "param17", "param18", "param19", "param20", "param21" });
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(100, e.state);
        }
    }

    /**
     * maineXg07ynz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋NTestSyncBatchExecutor01n
     * EbeansDef/TestSyncBatchExecutor01.xml݂
     * EbeanNameTestSyncBatchExecutor01Bean[h
     * EϐJOB_SEQ_IDseq01ݒ肳Ă
     * mF
     * EIR[h100ł邱
     * EID:DAL025044DEBUGOjobSequenceId=seq01ӂ܂邱
     * </pre>
     * @throws Exception
     */
    public void testMain07() throws Exception {
        try {
            SystemEnvUtils.setEnv(SyncBatchExecutor.ENV_JOB_SEQ_ID, "seq01");
            SyncBatchExecutor.main(new String[] { "TestSyncBatchExecutor01" });
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(100, e.state);
        }
    }

    /**
     * maineXg08ynz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋NTestSyncBatchExecutor01ݒ肳Ă
     * EϐJOB_ARG_NM1`20ɂꂼparam1 param2 param3 param4 param5 param6 param7 param8 param9 param10 param11 param12 param13 param14 param15 param16 param17 param18 param19 param20ݒ肳Ă
     * EbeansDef/TestSyncBatchExecutor01.xml݂
     * EbeanNameTestSyncBatchExecutor01Bean[h
     * mF
     * Eparam1`20܂ID:DAL025044̃Oɏo͂邱
     * EIR[h100ł邱
     * </pre>
     * @throws Exception
     */
    public void testMain08() throws Exception {
        try {
            for (int i = 1; i <= 20; i++) {
                SystemEnvUtils.setEnv("JOB_ARG_NM" + i, "param" + i);
            }
            SyncBatchExecutor.main(new String[] { "TestSyncBatchExecutor01" });
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(100, e.state);
        }
    }

    /**
     * maineXg09ynz
     * 
     * <pre>
     * O
     * ESyncBatchExecutor̋NTestSyncBatchExecutor01ݒ肳Ă
     * EϐJOB_ARG_NM1`20ɂꂼparam1 param2 param3 param4 param5 param6 param7 param8 param9 param10 param11 param12 param13 param14 param15 param16 param17 param18 param19 param20 param21ݒ肳Ă
     * EbeansDef/TestSyncBatchExecutor01.xml݂
     * EbeanNameTestSyncBatchExecutor01Bean[h
     * mF
     * Eparam1`20܂ID:DAL025044̃Oɏo͂邱
     * EIR[h100ł邱
     * </pre>
     * @throws Exception
     */
    public void testMain09() throws Exception {
        try {
            for (int i = 1; i <= 21; i++) {
                SystemEnvUtils.setEnv("JOB_ARG_NM" + i, "param" + i);
            }
            SyncBatchExecutor.main(new String[] { "TestSyncBatchExecutor01" });
            fail("ُł");
        } catch (ExitException e) {
            assertEquals(100, e.state);
        }
    }

    /**
     * getParameXg01
     * 
     * <pre>
     * OF
     * getParamget++Õ\bh݂
     * mFځF
     * Eget++Õ\bȟʂԋp邱
     * </pre>
     * @throws Exception
     */
    public void testGetParam01() throws Exception {
        String getParam = ReflectionUtils.invoke(SyncBatchExecutor.class,
                "getParam", new Class<?>[] { Object.class, String.class,
                        int.class }, new Object[] { new GetParamBean(), "Foo",
                        1 });
        assertEquals("foo1", getParam);
    }

    /**
     * getParameXg02
     * 
     * <pre>
     * OF
     * 
     * mFځF
     * Enullԋp邱
     * EX^bNg[Xjava.lang.SecurityExceptiono͂邱
     * </pre>
     * @throws Exception
     */
    // public void testGetParam02() throws Exception {
    // s\
    // }
    /**
     * getParameXg03
     * 
     * <pre>
     * OF
     * get++Õ\bh݂Ȃ
     * mFځF
     * Enullԋp邱
     * EX^bNg[Xjava.lang.NoSuchMethodExceptiono͂邱
     * </pre>
     * @throws Exception
     */
    public void testGetParam03() throws Exception {
        String getParam = ReflectionUtils.invoke(SyncBatchExecutor.class,
                "getParam", new Class<?>[] { Object.class, String.class,
                        int.class }, new Object[] { new BatchJobData(),
                        "HogeMethod", 1 });
        assertEquals(null, getParam);
    }

    /**
     * getParameXg04
     * 
     * <pre>
     * OF
     * 
     * mFځF
     * Enullԋp邱
     * EX^bNg[XIllegalArgumentExceptiono͂邱
     * </pre>
     * @throws Exception
     */
    // public void testGetParam04() throws Exception {
    // s\
    // }
    /**
     * getParameXg05
     * 
     * <pre>
     * OF
     * 
     * mFځF
     * Enullԋp邱
     * EX^bNg[XIllegalAccessExceptiono͂邱
     * </pre>
     * @throws Exception
     */
    // public void testGetParam05() throws Exception {
    // s\
    // }
    /**
     * getParameXg06
     * 
     * <pre>
     * OF
     * 
     * mFځF
     * Enullԋp邱
     * EX^bNg[Xjava.lang.reflect.InvocationTargetExceptiono͂邱
     * </pre>
     * @throws Exception
     */
    public void testGetParam06() throws Exception {
        String getParam = ReflectionUtils.invoke(SyncBatchExecutor.class,
                "getParam", new Class<?>[] { Object.class, String.class,
                        int.class }, new Object[] { new GetParamBean(), "Foo",
                        6 });
        assertEquals(null, getParam);
    }

    /**
     * GetParamBean
     */
    public static class GetParamBean {
        private String foo1 = "foo1";

        public String getFoo1() {
            return foo1;
        }

        public String getFoo6() {
            throw new NullPointerException();
        }
    }

    /**
     * testSetParam01
     */
    public void testSetParam01() {
        SetParamBean bean = new SetParamBean();
        ReflectionUtils
                .invoke(SyncBatchExecutor.class, "setParam", new Class<?>[] {
                        Object.class, String.class, int.class, String.class },
                        new Object[] { bean, "Foo", 1, "hoge" });
        assertEquals("hoge", bean.getFoo1());
    }

    // SecurityExceptioñX^bNg[Xo͂邱
    // public void testSetParam02() {
    // ł
    // }

    /**
     * testSetParam03<br>
     * NoSuchMethodExceptioñX^bNg[Xo͂邱
     */
    public void testSetParam03() {
        SetParamBean bean = new SetParamBean();
        ReflectionUtils
                .invoke(SyncBatchExecutor.class, "setParam", new Class<?>[] {
                        Object.class, String.class, int.class, String.class },
                        new Object[] { bean, "Foo", 3, "hoge" });
        assertEquals(null, bean.getFoo1());
    }

    // IllegalArgumentExceptioñX^bNg[Xo͂邱
    // public void testSetParam04() {
    // ł
    // }

    // IllegalAccessExceptioñX^bNg[Xo͂邱
    // public void testSetParam05() {
    // ł
    // }

    /**
     * testSetParam06<br>
     * InvocationTargetExceptioñX^bNg[Xo͂邱
     */
    public void testSetParam06() {
        SetParamBean bean = new SetParamBean();
        ReflectionUtils
                .invoke(SyncBatchExecutor.class, "setParam", new Class<?>[] {
                        Object.class, String.class, int.class, String.class },
                        new Object[] { bean, "Foo", 5, "hoge" });
        assertEquals(null, bean.getFoo1());
    }

    /**
     * SetParamBean
     */
    public static class SetParamBean {
        private String foo1;

        public String getFoo1() {
            return foo1;
        }

        public void setFoo1(String foo1) {
            this.foo1 = foo1;
        }

        public void setFoo5(String foo1) {
            throw new NullPointerException();
        }
    }
}
