package jp.terasoluna.fw.message;

import static org.junit.Assert.*;
import static jp.terasoluna.fw.ex.unit.util.AssertUtils.*;

import java.net.URL;
import java.util.Arrays;

import jp.terasoluna.fw.message.execption.MessageRuntimeException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MessageManagerTest {
    private ClassLoader currentClassLoader;

    /**
     * O
     * @throws Exception
     */
    @Before
    public void setUp() throws Exception {
        currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    /**
     * ㏈
     * @throws Exception
     */
    @After
    public void tearDown() throws Exception {
        Thread.currentThread().setContextClassLoader(currentClassLoader);
    }

    /**
     * RXgN^̎y01:nz
     * 
     * <pre>
     * OF
     * EǂݍݑΏۂ̃vpeBt@Cɉݒ肳ĂȂ
     * 
     * mFځF
     * EbZ[WID̃tH[}bg[%s]
     * EbZ[WvpeBt@C̃x[Xl[Xg
     * EOX[tOfalse
     * </pre>
     */
    @Test
    public void testConstructor01() {
        // ݒ̂ȂvpeBt@C
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger01.properties");
        assertEquals("[%s] ", manager.messageIdFormat);
        assertCollectionEmpty(manager.basenames);
        assertFalse(manager.throwIfResourceNotFound);
    }

    /**
     * RXgN^̎y02:nz
     * 
     * <pre>
     * OF
     * EǂݍݑΏۂ̃vpeBt@CɊevf̒lݒ肳Ă
     * 
     * mFځF
     * EbZ[WID̃tH[}bg[%s]
     * EbZ[WvpeBt@C̃x[Xl[XgɑΏۃt@Cꌏ擾Ă
     * EOX[tOtrue
     * </pre>
     */
    @Test
    public void testConstructor02() {
        // message.id.formatmessage.basenameݒ肳ĂAthrow.if.resource.not.foundtrue
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger02.properties");
        assertEquals("|%s| ", manager.messageIdFormat);
        assertCollectionEquals(
                Arrays.asList("jp/terasoluna/fw/message/log-messages2"),
                manager.basenames);
        assertTrue(manager.throwIfResourceNotFound);
    }

    /**
     * RXgN^̎y03:nz
     * 
     * <pre>
     * OF
     * EǂݍݑΏۂ̃vpeBt@Cmessage.basenameݒ肳Ă
     * 
     * mFځF
     * EbZ[WID̃tH[}bg[%s]
     * EbZ[WvpeBt@C̃x[Xl[XgɑΏۃt@C擾Ă
     * EOX[tOfalse
     * </pre>
     */
    @Test
    public void testConstructor03() {
        // message.basenameݒ肳ĂAthrow.if.resource.not.foundfalse
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger03.properties");
        assertEquals("[%s] ", manager.messageIdFormat);
        assertCollectionEquals(Arrays.asList(
                "jp/terasoluna/fw/message/log-messages3-1",
                "jp/terasoluna/fw/message/log-messages3-2"), manager.basenames);
        assertFalse(manager.throwIfResourceNotFound);
    }

    /**
     * RXgN^̎y04:nz
     * 
     * <pre>
     * OF
     * EǂݍݑΏۂ̃vpeBt@CNX[_ɕ݂
     * 
     * mFځF
     * EbZ[WID̃tH[}bg[%s]
     * EbZ[WvpeBt@C̃x[Xl[XgɑΏۃt@C擾Ă
     * EOX[tOfalse
     * </pre>
     */
    @Test
    public void testConstructor04() {
        // YvpeBt@CNX[_ɕ݂
        MockClassLoader cl = new MockClassLoader();
        cl.addMapping("META-INF/terasoluna-logger.properties",
                getResource("terasoluna-logger01.properties"),
                getResource("terasoluna-logger02.properties"),
                getResource("terasoluna-logger03.properties"));
        // NX[_̍ւ
        Thread.currentThread().setContextClassLoader(cl);

        MessageManager manager = new MessageManager(
                "META-INF/terasoluna-logger.properties");
        assertEquals("[%s] ", manager.messageIdFormat);
        assertCollectionEquals(Arrays.asList(
                "jp/terasoluna/fw/message/log-messages2",
                "jp/terasoluna/fw/message/log-messages3-1",
                "jp/terasoluna/fw/message/log-messages3-2"), manager.basenames);
        assertFalse(manager.throwIfResourceNotFound);
    }

    /**
     * RXgN^̎y05:nz
     * 
     * <pre>
     * OF
     * EǂݍݑΏۂ̃vpeBt@CNX[_ɕ݂
     * 
     * mFځF
     * EbZ[WID̃tH[}bg[%s]
     * EbZ[WvpeBt@C̃x[Xl[XgɑΏۃt@C擾Ă
     * EOX[tOtrueiDx̍vpeBt@C̒lɂȂĂ邩mFj
     * </pre>
     */
    @Test
    public void testConstructor05() {
        MockClassLoader cl = new MockClassLoader();
        cl.addMapping("META-INF/terasoluna-logger.properties",
                getResource("terasoluna-logger02.properties"),
                getResource("terasoluna-logger01.properties"),
                getResource("terasoluna-logger03.properties"));
        // NX[_̍ւ
        Thread.currentThread().setContextClassLoader(cl);

        MessageManager manager = new MessageManager(
                "META-INF/terasoluna-logger.properties");
        assertEquals("|%s| ", manager.messageIdFormat);
        assertCollectionEquals(Arrays.asList(
                "jp/terasoluna/fw/message/log-messages2",
                "jp/terasoluna/fw/message/log-messages3-1",
                "jp/terasoluna/fw/message/log-messages3-2"), manager.basenames);
        assertTrue(manager.throwIfResourceNotFound);
    }

    /**
     * RXgN^̎y06:ُnz
     * 
     * <pre>
     * OF
     * EsȃNX[_ݒ肷
     * 
     * mFځF
     * ERXgN^̌ĂяoɂAMessageRuntimeException̔mF
     */
    @Test
    public void testConstructor06() {
        Thread.currentThread().setContextClassLoader(new BadClassLoader());
        try {
            new MessageManager("");
            fail("O܂ł");
        } catch (Exception e) {
            e.printStackTrace();
            assertEquals("java.lang.RuntimeException: hoge", e.getMessage());
            assertEquals(MessageRuntimeException.class, e.getClass());
        }
    }

    @Test
    public void testConstructor07() throws Exception {
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger05.properties");
        assertEquals(SampleMessageFormatter01.class,
                manager.messageFormatter.getClass());
    }

    @Test
    public void testConstructor08() throws Exception {
        try {
            new MessageManager(
                    "jp/terasoluna/fw/message/terasoluna-logger06.properties");
        } catch (Exception e) {
            e.printStackTrace();
            assertEquals(MessageRuntimeException.class, e.getClass());
            assertEquals(ClassNotFoundException.class, e.getCause().getClass());
        }
    }

    protected static URL getResource(String name) {
        return MessageManager.class.getClassLoader().getResource(
                "jp/terasoluna/fw/message/" + name);
    }

    /**
     * getMessage\bhy01:nz getMessagePattern\bh̓mF
     * 
     * <pre>
     * OF
     * EǂݍރvpeBt@C݂
     * 
     * mFځF
     * Ew肵bZ[WID݂ȂꍇAnulllԂ
     * Ew肵bZ[WIDnulll̏ꍇAnulllԂ
     * </pre>
     */
    @Test
    public void testGetMessage01() {
        MessageManager manager = new MessageManager(
                "META-INF/terasoluna-logger.properties");
        assertNull(manager.getMessagePattern("hoge", null));
        assertNull(manager.getMessagePattern(null, null));
    }

    /**
     * getMessage\bhy02:ُnz getMessagePattern\bh̗OmF
     * 
     * <pre>
     * OF
     * EǂݍރvpeBt@C݂
     * EOX[tOtrue
     * 
     * mFځF
     * Ew肵bZ[WID݂ȂꍇAMessageRuntimeExceptionԂ
     * </pre>
     */
    @Test
    public void testGetMessage02() {
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger02.properties");
        try {
            manager.getMessagePattern("hoge", null);
            fail("O܂ł");
        } catch (Exception e) {
            e.printStackTrace();
            assertEquals("key[hoge] is not found", e.getMessage());
            assertEquals(MessageRuntimeException.class, e.getClass());
        }
    }

    /**
     * getMessage\bhy03:nz vpeBt@Cɑ݂郁bZ[W擾
     * 
     * <pre>
     * OF
     * EǂݍރvpeBt@CɊY郁bZ[Wݒ肳Ă
     * 
     * mFځF
     * EvpeBt@C҂郁bZ[W擾Ă
     * </pre>
     */
    @Test
    public void testGetMessage03() {
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger04.properties");
        assertEquals("[message01] bZ[W01",
                manager.getMessage(true, "message01"));

    }

    /**
     * getMessage\bhy04:nz vpeBt@Cɑ݂郁bZ[W擾
     * 
     * <pre>
     * OF
     * E\[X̏getMessage\bhĂяoĂ
     * 
     * mFځF
     * Eݒ肵up[^ɏo͂Ă
     * </pre>
     */
    @Test
    public void testGetMessage04() {
        MessageManager manager = new MessageManager("");
        assertEquals("bZ[W01 u01=hoge,u02=foo", manager.getMessage(
                false, "bZ[W01 u01={0},u02={1}", null, "hoge", "foo"));
    }

    /**
     * getMessage\bhy05:ُnz
     * 
     * <pre>
     * OF
     * EǂݍݑΏۂ̃vpeBt@CɕsȒup[^ݒ肳ꂽbZ[W݂
     * EOX[tOtrue
     * 
     * mFځF
     * Esup[^ݒ肵bZ[W̌ĂяoɂAMessageRuntimeExceptionԂ
     * </pre>
     */
    @Test
    public void testGetMessage05() {
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger04.properties");

        try {
            manager.getMessage(true, "message02");
            fail("O܂ł");
        } catch (Exception e) {
            e.printStackTrace();
            assertEquals(
                    "message pattern is illeagal. pattern=bZ[W02{a}] logId=message02",
                    e.getMessage());
            assertEquals(MessageRuntimeException.class, e.getClass());
        }

    }

    /**
     * getStringOrNull\bhy01:nz
     * 
     * <pre>
     * OF
     * EgetStringOrNull\bḧłResourceBundle̒lnullł
     * 
     * mFځF
     * EnulllԂ
     * </pre>
     */
    @Test
    public void testGetStringOrNull01() {
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger02.properties");
        assertNull(manager.getStringOrNull(null, null));
    }

    /**
     * getStringOrNull\bhy02:ُnz
     * 
     * <pre>
     * OF
     * EgetStringOrNull\bḧłString^ϐkey̒lnullł
     * EOX[tOtrue
     * 
     * mFځF
     * EMessageRuntimeExceptionԂ邱
     * </pre>
     */
    @Test
    public void testGetStringOrNull02() {
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger02.properties");
        try {
            manager.getMessagePattern(null, null);
            fail("O܂ł");
        } catch (Exception e) {
            e.printStackTrace();
            assertEquals("key is null", e.getMessage());
            assertEquals(MessageRuntimeException.class, e.getClass());
        }
    }

    /**
     * getResourceBundle\bhy01:ُnz getStringOrNull̗OmF
     * 
     * <pre>
     * OF
     * EǂݍݑΏۂ̃vpeBt@C݂
     * E݂ȂvpeBt@Cw肵getResourceBundle\bhĂяo
     * EOX[tOtrue
     * 
     * mFځF
     * EgetResourceBundle\bhMessageRuntimeExceptionԂ
     * </pre>
     */
    @Test
    public void testGetResourceBundle() {
        MessageManager manager = new MessageManager(
                "jp/terasoluna/fw/message/terasoluna-logger02.properties");
        try {
            manager.getResourceBundle("META-INF/hoge.properties", null);
            fail("O܂ł");
        } catch (Exception e) {
            e.printStackTrace();
            assertEquals("resource[META-INF/hoge.properties] is not found",
                    e.getMessage());
            assertEquals(MessageRuntimeException.class, e.getClass());
        }
    }

    /**
     * getClassLoader\bhy01:nz
     * 
     * <pre>
     * mFځF
     * EXbhɐݒ肳ꂽReLXgNX[_getClassLoader\bhɂ擾ł邱ƂmF
     * </pre>
     */
    @Test
    public void testGetClassLoader01() {
        assertSame(Thread.currentThread().getContextClassLoader(),
                MessageManager.getClassLoader());
    }

    /**
     * getClassLoader\bhy02:nz
     * 
     * <pre>
     * mFځF
     * EXbhɐݒ肳ꂽReLXgNX[_ɑ΂Anulllݒ肷
     * EMessageManager.getClassLoadeřʂMessageManager.class[hNX[_ɂȂĂ邱ƂmF
     * </pre>
     */
    @Test
    public void testGetClassLoader02() {
        Thread.currentThread().setContextClassLoader(null);
        assertSame(MessageManager.class.getClassLoader(),
                MessageManager.getClassLoader());
    }
}
