/*
 * $Id: FileUtilityTest.java 5576 2007-11-15 13:13:32Z pakucn $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.util.FileUtility} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@C@\NX.
 * <p>
 * @author gM
 * @author O
 * @see jp.terasoluna.fw.file.util.FileUtility
 */
public class FileUtilityTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(FileUtilityTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();

        // FileUtilitystatictB[hftHglɏB
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public FileUtilityTest(String name) {
        super(name);
    }

    /*
     * testCopyFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile01_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile01_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:false<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile01_src.txtf[^<br>
     * () newFileŎw肵t@C:݂ȂB<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:Rs[srcFileŎw肵t@CƓ̓eł邱ƂmFB<br>
     * <br>
     * P[X<br>
     * Rs[̃t@C݂ȂꍇAt@CRs[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    // This testcase is ignored, because of Windows environment dependency.
    public void _ignore_testCopyFile01() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile01_src.txt";
        String newFile = directoryPath + "testCopyFile01_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();

        FileWriter testSrcFileFileWriter = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile01_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            File getFile = new File(newFile);
            UTUtil.assertEqualsFile(testSrcFile, getFile);
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }

            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile02_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile02_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile02_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile02_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:Rs[srcFileŎw肵t@CƓ̓eł邱ƂmFB<br>
     * <br>
     * P[X<br>
     * icheckFileExistTRUEj<br>
     * Rs[̃t@C݂ꍇAt@CRs[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile02() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile02_src.txt";
        String newFile = directoryPath + "testCopyFile02_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile02_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile02_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            File getFile = new File(newFile);
            UTUtil.assertEqualsFile(testSrcFile, getFile);
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile03_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile03_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:false<br>
     * () srcFileŎw肵t@C:݂ȂB<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile03_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ύXȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"(pX)/testCopyFile03_src.txt is not exist."<br>
     * Et@CFsrcFileƓl<br>
     * <br>
     * ُP[X<br>
     * Rs[̃t@CȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile03() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile03_src.txt";
        String newFile = directoryPath + "testCopyFile03_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile03_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(srcFile + " is not exist.", e.getMessage());
            assertEquals(srcFile, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            File resultFile = new File(newFile);
            assertTrue(resultFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(resultFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testCopyFile03_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile04_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile04_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:false<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile04_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile04_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ύXȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"(pX)/testCopyFile04_new.txt is exist."<br>
     * Et@CFnewFileƓl<br>
     * <br>
     * ُP[X<br>
     * icheckFileExistFALSEj<br>
     * Rs[̃t@C݂ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile04() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile04_src.txt";
        String newFile = directoryPath + "testCopyFile04_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile04_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile04_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(newFile + " is exist.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            File resultFile = new File(newFile);
            assertTrue(resultFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(resultFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testCopyFile04_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile05_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile05_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile05_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile05_new.txtf[^<br>
     * () FileOutputStream#<init>():FileNotFoundException<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:t@C݂ȂB<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File control operation was failed."<br>
     * EOFFileNotFoundException<br>
     * <br>
     * ُP[X<br>
     * t@C̑݃`FbÑ^C~OŃRs[̃t@C폜ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile05() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile05_src.txt";
        String newFile = directoryPath + "testCopyFile05_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist",
                Boolean.TRUE);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileNotFoundException fileNotFoundException = new FileNotFoundException(
                "testCopyFile05O");
        VMOUTUtil.setExceptionAtAllTimes(FileOutputStream.class, "<init>",
                fileNotFoundException);

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile05_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile05_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());
            assertSame(fileNotFoundException, e.getCause());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            File file = new File(newFile);
            assertFalse(file.exists());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile06_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile06_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile06_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile06_new.txtf[^<br>
     * () FileChannel#position():IOException<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:t@C݂邪AeȂB<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File control operation was failed."<br>
     * EOFIOException<br>
     * <br>
     * ُP[X<br>
     * t@C̃Rs[rIOExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile06() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile06_src.txt";
        String newFile = directoryPath + "testCopyFile06_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist",
                Boolean.TRUE);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        IOException exception = new IOException("testCopyFile06O");
        VMOUTUtil.setExceptionAtAllTimes(FileChannel.class, "position",
                exception);

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile06_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile06_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());
            assertSame(exception, e.getCause());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            File resultFile = new File(newFile);
            assertTrue(resultFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(resultFile)));
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile07_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile07_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile07_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile07_new.txtf[^<br>
     * () FileOutputStream#close():IOException<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:Rs[srcFileŎw肵t@CƓ̓eł邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * t@C̃Rs[ナ\[X̊JIOExceptionꍇÂ܂܏𑱂I邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile07() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile07_src.txt";
        String newFile = directoryPath + "testCopyFile07_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist",
                Boolean.TRUE);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        IOException exception = new IOException("testCopyFile07O");
        VMOUTUtil.setExceptionAtAllTimes(FileOutputStream.class, "close",
                exception);

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile07_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile07_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            File getFile = new File(newFile);
            UTUtil.assertEqualsFile(testSrcFile, getFile);
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:null<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile08_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂ȂB<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile08_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1ĂяoB<br>
     * ƂāAsrcFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ύXȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not set."<br>
     * Et@CFnull<br>
     * <br>
     * ُP[X<br>
     * Rs[̃t@Cnullœ͂ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile08() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = null;
        String newFile = directoryPath + "testCopyFile08_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist",
                Boolean.TRUE);

        // eXgΏۃt@CB
        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        IOException exception = new IOException("TEST");
        VMOUTUtil.setExceptionAtAllTimes(FileLock.class, "release", exception);

        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile08_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not set.", e.getMessage());
            assertNull(e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // Rs[̃t@CemF
            File resultFile = new File(newFile);
            assertTrue(resultFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(resultFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testCopyFile08_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile09_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "testCopyFile09_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile09_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile09_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ύXȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not absolute."<br>
     * Et@CFnewFileƓl<br>
     * <br>
     * ُP[X<br>
     * Rs[̃t@C΃pXœ͂ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile09() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile09_src.txt";
        String newFile = "testCopyFile09_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist",
                Boolean.TRUE);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(directoryPath + newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile09_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile09_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not absolute.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            File resultFile = new File(directoryPath + newFile);
            assertTrue(resultFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(resultFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testCopyFile09_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testCopyFile10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile10_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:null<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile10_src.txtf[^<br>
     * () newFileŎw肵t@C:݂ȂB<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ύXȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not set."<br>
     * Et@CFnull<br>
     * <br>
     * ُP[X<br>
     * Rs[̃t@Cnullœ͂ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile10() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile10_src.txt";
        String newFile = null;

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist",
                Boolean.TRUE);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile10_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not set.", e.getMessage());
            assertNull(e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testCopyFile11() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testCopyFile11_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile11_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂ȂB<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile11_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1ĂяoB<br>
     * ƂāAsrcFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ύXȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not absolute."<br>
     * Et@CFsrcFileƓl<br>
     * <br>
     * ُP[X<br>
     * Rs[̃t@C΃pXœ͂ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCopyFile11() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testCopyFile10_src.txt";
        String newFile = directoryPath + "testCopyFile10_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist",
                Boolean.TRUE);

        // eXgΏۃt@CB
        File testSrcFile = new File(directoryPath + srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile11_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile11_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not absolute.", e.getMessage());
            assertEquals(srcFile, e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // Rs[̃t@CemF
            File resultFile = new File(newFile);
            assertTrue(resultFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(resultFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testCopyFile11_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(directoryPath + srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /*
     * testCopyFile12() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testCopyFile12_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testCopyFile02_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile02_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * EtestCopyFile02_new.txtf[^<br>
     * <br>
     * bN|ĂB<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFƂāAsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFƂāAnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ύXȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File control operation was failed."<br>
     * Et@CFnewFileƓl<br>
     * <br>
     * ُP[X<br>
     * icheckFileExistTRUEj<br>
     * Rs[̃t@C݂邪bNĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    // This testcase is ignored, because of Windows environment dependency.
    public void _ignore_testCopyFile12() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testCopyFile12_src.txt";
        String newFile = directoryPath + "testCopyFile12_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        FileInputStream fis = null;
        FileLock lock = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile02_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testCopyFile02_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            fis = new FileInputStream(testNewFile);
            lock = fis.getChannel().lock(0L, Long.MAX_VALUE, true);

            // eXg{
            FileUtility.copyFile(srcFile, newFile);
            fail("FileException܂łB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // Rs[̃t@CemF
            lock.release();
            // t@C̕ύXmF
            lock.release();
            File getFile = new File(newFile);
            assertTrue(getFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(getFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testCopyFile02_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
            postReader.close();

        } finally {
            if (lock != null) {
                lock.release();
            }
            if (fis != null) {
                fis.close();
            }
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testDeleteFile01_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile01_src.txtf[^<br>
     * <br>
     * ҒlF(ԕω) srcFileŎw肵t@C:݂ȂB<br>
     * <br>
     * P[X<br>
     * Ώۃt@C폜邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile01() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testDeleteFile01_src.txt";

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile01_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            // eXg{
            FileUtility.deleteFile(srcFile);

            // 
            // Rs[̃t@CemF
            File resultFile = new File(srcFile);
            assertFalse(resultFile.exists());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            File file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testDeleteFile02_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () srcFileŎw肵t@C:݂ȂB<br>
     * <br>
     * ҒlF(ԕω) srcFileŎw肵t@C:ωȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"(pX)/testDeleteFile02_src.txt  is not exist."<br>
     * Et@CFsrcFileƓl<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@C݂ȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile02() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testDeleteFile01_src.txt";

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();

        try {
            FileUtility.deleteFile(srcFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(srcFile + " is not exist.", e.getMessage());
            assertEquals(srcFile, e.getFileName());
        } finally {
            File file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testDeleteFile03_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile03_src.txtf[^<br>
     * () File#delete():false<br>
     * <br>
     * ҒlF(ԕω) srcFileŎw肵t@C:ωȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File control operation was failed."<br>
     * Et@CFsrcFileƓl<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@C̍폜t@CbNȂǂɂĎsꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile03() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testDeleteFile03_src.txt";

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        VMOUTUtil.setReturnValueAtAllTimes(File.class, "delete", false);

        FileWriter testSrcFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile03_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            // eXg{
            FileUtility.deleteFile(srcFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());
            assertEquals(srcFile, e.getFileName());

            // Rs[̃t@CemF
            File resultFile = new File(srcFile);
            assertTrue(resultFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(resultFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testCopyFile03_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            File file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testDeleteFile04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:null<br>
     * () srcFileŎw肵t@C:݂ȂB<br>
     * <br>
     * ҒlF(ԕω) srcFileŎw肵t@C:ωȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not set."<br>
     * Et@CFsrcFileƓl<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@C̃pXnull̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile04() throws Exception {
        // ̐ݒ
        String srcFile = null;

        try {
            FileUtility.deleteFile(srcFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not set.", e.getMessage());
            assertNull(e.getFileName());
        }
    }

    /**
     * testDeleteFile05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testDeleteFile05_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestCopyFile05_src.txtf[^<br>
     * <br>
     * ҒlF(ԕω) srcFileŎw肵t@C:ωȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not absolute."<br>
     * Et@CFsrcFileƓl<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@C̃pX΃pX̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteFile05() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testDeleteFile05_src.txt";

        // eXgΏۃt@CB
        File testSrcFile = new File(directoryPath + srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testCopyFile05_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            // eXg{
            FileUtility.deleteFile(srcFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not absolute.", e.getMessage());
            assertEquals(srcFile, e.getFileName());

            // Rs[̃t@CemF
            File resultFile = new File(directoryPath + srcFile);
            assertTrue(resultFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(resultFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testCopyFile05_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            File file = new File(directoryPath + srcFile);
            file.delete();
        }
    }

    /**
     * testMergeFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,D,F <br>
     * <br>
     * ͒lF() fileList:vfȂListCX^X<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile01_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:false<br>
     * () fileListŎw肵t@C:݂Ȃ<br>
     * () newFileŎw肵t@C:݂Ȃ<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1Ă΂B<br>
     * newFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:̃t@C<br>
     * <br>
     * P[X<br>
     * Ώۃt@CXg̏ꍇAt@C邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile01() throws Exception {
        // ̐ݒ
        List<String> fileList = new ArrayList<String>();

        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String newFile = directoryPath + "testMergeFile01_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testNewFile = new File(newFile);
        testNewFile.delete();

        BufferedReader postReader = null;
        try {
            // eXg{
            FileUtility.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(newFile)));
            assertFalse(postReader.ready());
        } finally {
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(newFile);
            file.delete();
        }

    }

    /**
     * testMergeFile02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,D,F <br>
     * <br>
     * ͒lF() fileList:vfȂListCX^X<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile02_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂Ȃ<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile02_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1Ă΂B<br>
     * newFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:̃t@C<br>
     * <br>
     * P[X<br>
     * (checkFileExistݒFTRUE)<br>
     * w肳ꂽʃt@Cɑ݂ꍇAȂʃt@C邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile02() throws Exception {
        // ̐ݒ
        List<String> fileList = new ArrayList<String>();

        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String newFile = directoryPath + "testMergeFile02_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile02_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:vfȂListCX^X<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile03_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:false<br>
     * () fileListŎw肵t@C:݂Ȃ<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile03_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1Ă΂B<br>
     * newFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ωȂ<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"(pX)/testMergeFile03_new.txt is exist."<br>
     * Et@CFnewFileƓl<br>
     * <br>
     * ُP[X<br>
     * (checkFileExistݒFFALSE)<br>
     * w肳ꂽʃt@Cɑ݂ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile03() throws Exception {
        // ̐ݒ
        List<String> fileList = new ArrayList<String>();

        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String newFile = directoryPath + "testMergeFile03_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile03_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(newFile + " is exist.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testMergeFile03_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(newFile);
            file.delete();
        }

    }

    /**
     * testMergeFile04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,D,F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile04_src1.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile04_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile04_src1.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile04_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * 2ڂ̌ĂяoFfileList̗vf1̃t@CpXn邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile04_src1.txtf[^<br>
     * <br>
     * P[X<br>
     * Ώۃt@CXgɑ݂t@C̃pXݒ肳ĂꍇÄ̃t@CƓẽt@C邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile04() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile04_src1.txt";
        fileList.add(srcFile1);

        String newFile = directoryPath + "testMergeFile04_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile04_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile04_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(srcFile1, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            UTUtil.assertEqualsFile(testSrcFile1, mergeFile);
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile05() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,D,F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile05_src1.txt"<br>
     * 2D"(pX)/testMergeFile05_src2.txt"<br>
     * 3D"(pX)/testMergeFile05_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile05_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂B<br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile05_src1.txtf[^<br>
     * EtestMergeFile05_src2.txtf[^<br>
     * EtestMergeFile05_src3.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile05_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():4Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * 2ڂ̌ĂяoFfileList̗vf1̃t@CpXn邱ƁB<br>
     * 3ڂ̌ĂяoFfileList̗vf2̃t@CpXn邱ƁB<br>
     * 4ڂ̌ĂяoFfileList̗vf3̃t@CpXn邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile05_src1.txtf[^testMergeFile05_src2.txtf[^testMergeFile05_src3.txtf[^<br>
     * <br>
     * P[X<br>
     * Ώۃt@CXgɑ݂t@C̃pXݒ肳ĂꍇȂSt@C̓eԂɌČʃt@CƂĐ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile05() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile05_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile05_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile05_src3.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile05_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();
        testSrcFile2.createNewFile();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();
        testSrcFile3.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile2FileWriter = null;
        FileWriter testSrcFile3FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile05_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile2FileWriter = new FileWriter(testSrcFile2);
            testSrcFile2FileWriter.write("testMergeFile05_src2.txtf[^");
            testSrcFile2FileWriter.flush();
            testSrcFile2FileWriter.close();

            testSrcFile3FileWriter = new FileWriter(testSrcFile3);
            testSrcFile3FileWriter.write("testMergeFile05_src3.txtf[^");
            testSrcFile3FileWriter.flush();
            testSrcFile3FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile05_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(4, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(srcFile1, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));
            assertEquals(srcFile2, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 2, 0));
            assertEquals(srcFile3, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 3, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testMergeFile05_src1.txtf[^"
                    + "testMergeFile05_src2.txtf[^testMergeFile05_src3.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile2FileWriter != null) {
                testSrcFile2FileWriter.close();
            }
            if (testSrcFile3FileWriter != null) {
                testSrcFile3FileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile06_src1.txt"<br>
     * 2D"(pX)/testMergeFile06_src2.txt"<br>
     * 3D"(pX)/testMergeFile06_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile06_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂Ȃ<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile06_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * 2ڂ̌ĂяoFfileList̗vf1̃t@CpXn邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:̃t@C<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"(pX)/testMergeFile06_src1.txt is exist."<br>
     * Et@CF"(pX)/testMergeFile06_src1.txt"<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@CXgɑ݂Ȃt@C̃pXݒ肳ĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile06() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile06_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile06_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile06_src3.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile06_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile06_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̔
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(srcFile1 + " is not exist.", e.getMessage());
            assertEquals(srcFile1, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(srcFile1, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile07_src1.txt"<br>
     * 2D"(pX)/testMergeFile07_src2.txt"<br>
     * 3D"(pX)/testMergeFile07_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile07_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:"(pX)/testMergeFile07_src3.txt"̂ݑ݂Ȃ<br>
     * <br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile07_src1.txtf[^<br>
     * EtestMergeFile07_src2.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile07_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():4Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * 2ڂ̌ĂяoFfileList̗vf1̃t@CpXn邱ƁB<br>
     * 3ڂ̌ĂяoFfileList̗vf2̃t@CpXn邱ƁB<br>
     * 4ڂ̌ĂяoFfileList̗vf3̃t@CpXn邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile07_src1.txtf[^testMergeFile07_src2.txtf[^<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"(pX)/testMergeFile07_src3.txt is not exist."<br>
     * Et@CF"(pX)/testMergeFile07_src3.txt"<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@CXgɈꕔ݂Ȃt@C̃pXݒ肳ĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile07() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile07_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile07_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile07_src3.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile07_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();
        testSrcFile2.createNewFile();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile2FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile07_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile2FileWriter = new FileWriter(testSrcFile2);
            testSrcFile2FileWriter.write("testMergeFile07_src2.txtf[^");
            testSrcFile2FileWriter.flush();
            testSrcFile2FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile07_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(srcFile3 + " is not exist.", e.getMessage());
            assertEquals(srcFile3, e.getFileName());

            // ԕω̊mF
            assertEquals(4, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(srcFile1, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));
            assertEquals(srcFile2, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 2, 0));
            assertEquals(srcFile3, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 3, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testMergeFile07_src1.txtf[^"
                    + "testMergeFile07_src2.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile2FileWriter != null) {
                testSrcFile2FileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile08_src1.txt"<br>
     * 2D"(pX)/testMergeFile08_src2.txt"<br>
     * 3D"(pX)/testMergeFile08_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile08_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂B<br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile08_src1.txtf[^<br>
     * EtestMergeFile08_src2.txtf[^<br>
     * EtestMergeFile08_src3.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile08_new.txtf[^<br>
     * () inputFileChannel#position():IOException<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * 2ڂ̌ĂяoFfileList̗vf1̃t@CpXn邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:̃t@C<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"File control operation was failed."<br>
     * EOFFileOutputStream#close()ŔIOException<br>
     * <br>
     * ُP[X<br>
     * t@CIOExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile08() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile08_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile08_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile08_src3.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile08_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();
        testSrcFile2.createNewFile();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();
        testSrcFile3.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        IOException ioException = new IOException("testMergeFile08O");
        VMOUTUtil.setExceptionAtAllTimes(FileChannel.class, "position",
                ioException);

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile2FileWriter = null;
        FileWriter testSrcFile3FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile08_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile2FileWriter = new FileWriter(testSrcFile2);
            testSrcFile2FileWriter.write("testMergeFile08_src2.txtf[^");
            testSrcFile2FileWriter.flush();
            testSrcFile2FileWriter.close();

            testSrcFile3FileWriter = new FileWriter(testSrcFile3);
            testSrcFile3FileWriter.write("testMergeFile08_src3.txtf[^");
            testSrcFile3FileWriter.flush();
            testSrcFile3FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile08_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());
            assertSame(ioException, e.getCause());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(srcFile1, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile2FileWriter != null) {
                testSrcFile2FileWriter.close();
            }
            if (testSrcFile3FileWriter != null) {
                testSrcFile3FileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile09_src1.txt"<br>
     * 2D"(pX)/testMergeFile09_src2.txt"<br>
     * 3D"(pX)/testMergeFile09_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile09_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂B<br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile09_src1.txtf[^<br>
     * EtestMergeFile09_src2.txtf[^<br>
     * EtestMergeFile09_src3.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile09_new.txtf[^<br>
     * () FileOutputStream#close():IOException<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():4Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * 2ڂ̌ĂяoFfileList̗vf1̃t@CpXn邱ƁB<br>
     * 3ڂ̌ĂяoFfileList̗vf2̃t@CpXn邱ƁB<br>
     * 4ڂ̌ĂяoFfileList̗vf3̃t@CpXn邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile09_src1.txtf[^testMergeFile09_src2.txtf[^testMergeFile09_src3.txtf[^<br>
     * <br>
     * ُP[X<br>
     * t@Cpă\[X̊JɎsꍇAOȂƂmFB<br>
     * ܂Aʃt@CĂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile09() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile09_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile09_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile09_src3.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile09_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();
        testSrcFile2.createNewFile();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();
        testSrcFile3.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        IOException ioException = new IOException("testMergeFile09O");
        VMOUTUtil.setExceptionAtAllTimes(FileOutputStream.class, "close",
                ioException);

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile2FileWriter = null;
        FileWriter testSrcFile3FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile09_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile2FileWriter = new FileWriter(testSrcFile2);
            testSrcFile2FileWriter.write("testMergeFile09_src2.txtf[^");
            testSrcFile2FileWriter.flush();
            testSrcFile2FileWriter.close();

            testSrcFile3FileWriter = new FileWriter(testSrcFile3);
            testSrcFile3FileWriter.write("testMergeFile09_src3.txtf[^");
            testSrcFile3FileWriter.flush();
            testSrcFile3FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile09_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);

            // ԕω̊mF
            assertEquals(4, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(srcFile1, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));
            assertEquals(srcFile2, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 2, 0));
            assertEquals(srcFile3, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 3, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testMergeFile09_src1.txtf[^"
                    + "testMergeFile09_src2.txtf[^testMergeFile09_src3.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());

        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile2FileWriter != null) {
                testSrcFile2FileWriter.close();
            }
            if (testSrcFile3FileWriter != null) {
                testSrcFile3FileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile10_src1.txt"<br>
     * 2D"(pX)/testMergeFile10_src2.txt"<br>
     * 3D"(pX)/testMergeFile10_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile10_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂B<br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile10_src1.txtf[^<br>
     * EtestMergeFile10_src2.txtf[^<br>
     * EtestMergeFile10_src3.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile10_new.txtf[^<br>
     * () FileOutputStream.<init>:FileNotFountException<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:t@C݂Ȃ<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"File control operation was failed."<br>
     * EOFFileOutputStream.<init>ŔFileNotFoundException<br>
     * <br>
     * ُP[X<br>
     * rɃt@C폜FileNotFoundExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile10() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile10_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile10_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile10_src3.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile10_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();
        testSrcFile2.createNewFile();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();
        testSrcFile3.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileNotFoundException fileNotFoundException = new FileNotFoundException(
                "testMergeFile10O");
        VMOUTUtil.setExceptionAtAllTimes(FileOutputStream.class, "<init>",
                fileNotFoundException);

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile2FileWriter = null;
        FileWriter testSrcFile3FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile10_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile2FileWriter = new FileWriter(testSrcFile2);
            testSrcFile2FileWriter.write("testMergeFile10_src2.txtf[^");
            testSrcFile2FileWriter.flush();
            testSrcFile2FileWriter.close();

            testSrcFile3FileWriter = new FileWriter(testSrcFile3);
            testSrcFile3FileWriter.write("testMergeFile10_src3.txtf[^");
            testSrcFile3FileWriter.flush();
            testSrcFile3FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile10_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());
            assertSame(fileNotFoundException, e.getCause());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertFalse(mergeFile.exists());
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile2FileWriter != null) {
                testSrcFile2FileWriter.close();
            }
            if (testSrcFile3FileWriter != null) {
                testSrcFile3FileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile11() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:null<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile11_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂Ȃ<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile11_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:̃t@C<br>
     * (ԕω) O:NullPointerException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@CXgnull̏ꍇANullPointerException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile11() throws Exception {
        // ̐ݒ
        List<String> fileList = null;

        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String newFile = directoryPath + "testMergeFile11_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile11_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("NullPointerException܂łBsłB");
        } catch (NullPointerException e) {
            // O̊mF
            assertTrue(NullPointerException.class
                    .isAssignableFrom(e.getClass()));

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile12() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile12_src1.txt"<br>
     * 2D"(pX)/testMergeFile12_src2.txt"<br>
     * 3D"(pX)/testMergeFile12_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:null<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂B<br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile12_src1.txtf[^<br>
     * EtestMergeFile12_src2.txtf[^<br>
     * EtestMergeFile12_src3.txtf[^<br>
     * () newFileŎw肵t@C:݂Ȃ<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1Ă΂B<br>
     * newFilen邱ƁB<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"File path is not set."<br>
     * Et@CFnull<br>
     * <br>
     * ُP[X<br>
     * ʃt@C̃pXnull̏ꍇAOo邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile12() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile12_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile12_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile12_src3.txt";
        fileList.add(srcFile3);

        String newFile = null;

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();
        testSrcFile2.createNewFile();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();
        testSrcFile3.createNewFile();

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile2FileWriter = null;
        FileWriter testSrcFile3FileWriter = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile12_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile2FileWriter = new FileWriter(testSrcFile2);
            testSrcFile2FileWriter.write("testMergeFile12_src2.txtf[^");
            testSrcFile2FileWriter.flush();
            testSrcFile2FileWriter.close();

            testSrcFile3FileWriter = new FileWriter(testSrcFile3);
            testSrcFile3FileWriter.write("testMergeFile12_src3.txtf[^");
            testSrcFile3FileWriter.flush();
            testSrcFile3FileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not set.", e.getMessage());
            assertNull(e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile2FileWriter != null) {
                testSrcFile2FileWriter.close();
            }
            if (testSrcFile3FileWriter != null) {
                testSrcFile3FileWriter.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
        }
    }

    /**
     * testMergeFile13() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile13_src1.txt"<br>
     * 2D"(pX)/testMergeFile13_src2.txt"<br>
     * 3D"(pX)/testMergeFile13_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "testMergeFile13_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂B<br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile13_src1.txtf[^<br>
     * EtestMergeFile13_src2.txtf[^<br>
     * EtestMergeFile13_src3.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile13_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1Ă΂B<br>
     * newFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ωȂ<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"File path is not absolute."<br>
     * Et@CFnewFileƓl<br>
     * <br>
     * ُP[X<br>
     * ʃt@C̃pX΃pX̏ꍇAOo邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile13() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile13_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile13_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile13_src3.txt";
        fileList.add(srcFile3);

        String newFile = "testMergeFile13_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();
        testSrcFile2.createNewFile();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();
        testSrcFile3.createNewFile();

        File testNewFile = new File(directoryPath + newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile2FileWriter = null;
        FileWriter testSrcFile3FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile13_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile2FileWriter = new FileWriter(testSrcFile2);
            testSrcFile2FileWriter.write("testMergeFile13_src2.txtf[^");
            testSrcFile2FileWriter.flush();
            testSrcFile2FileWriter.close();

            testSrcFile3FileWriter = new FileWriter(testSrcFile3);
            testSrcFile3FileWriter.write("testMergeFile13_src3.txtf[^");
            testSrcFile3FileWriter.flush();
            testSrcFile3FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile13_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not absolute.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // }[W̃t@CemF
            File mergeFile = new File(directoryPath + newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testMergeFile13_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile2FileWriter != null) {
                testSrcFile2FileWriter.close();
            }
            if (testSrcFile3FileWriter != null) {
                testSrcFile3FileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile14() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile14_src1.txt"<br>
     * 2Dnull<br>
     * 3D"(pX)/testMergeFile14_src3.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile14_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:2Ԗڂ̂ݑ݂Ȃ<br>
     * <br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile14_src1.txtf[^<br>
     * EtestMergeFile14_src3.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile14_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():3Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * 2ڂ̌ĂяoFfileList̗vf1̃t@CpXn邱ƁB<br>
     * 3ڂ̌ĂяoFfileList̗vf2̃t@CpXn邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile14_src1.txtf[^<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"File path is not set."<br>
     * Et@CFnull<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@CXg̍ڂ̒nullꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile14() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile14_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = null;
        fileList.add(srcFile2);
        String srcFile3 = directoryPath + "testMergeFile14_src3.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile14_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile3 = new File(srcFile3);
        testSrcFile3.delete();
        testSrcFile3.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile3FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile14_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile3FileWriter = new FileWriter(testSrcFile3);
            testSrcFile3FileWriter.write("testMergeFile14_src3.txtf[^");
            testSrcFile3FileWriter.flush();
            testSrcFile3FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile14_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not set.", e.getMessage());
            assertNull(e.getFileName());

            // ԕω̊mF
            assertEquals(3, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(srcFile1, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));
            assertNull(VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 2, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testMergeFile14_src1.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile3FileWriter != null) {
                testSrcFile3FileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testMergeFile15() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:ȉ̗vfListCX^X<br>
     * 1D"(pX)/testMergeFile15_src1.txt"<br>
     * 2D"(pX)/testMergeFile15_src1.txt"<br>
     * 3D"testMergeFile15_src3.txt"(΃pX)<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile15_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂B<br>
     * ȉ̃f[^et@CɓĂB<br>
     * EtestMergeFile15_src1.txtf[^<br>
     * EtestMergeFile15_src2.txtf[^<br>
     * EtestMergeFile15_src3.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile15_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():4Ă΂B<br>
     * 1ڂ̌ĂяoFnewFilen邱ƁB<br>
     * 2ڂ̌ĂяoFfileList̗vf1̃t@CpXn邱ƁB<br>
     * 3ڂ̌ĂяoFfileList̗vf2̃t@CpXn邱ƁB<br>
     * 4ڂ̌ĂяoFfileList̗vf3̃t@CpXn邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile15_src1.txtf[^testMergeFile15_src2.txtf[^<br>
     * (ԕω) O:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"File path is not absolute."<br>
     * Et@CFsrcFile3Ɠl<br>
     * <br>
     * ُP[X<br>
     * Ώۃt@CXg̍ڂ̒ɑ΃pXꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testMergeFile15() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());
        List<String> fileList = new ArrayList<String>();

        String srcFile1 = directoryPath + "testMergeFile14_src1.txt";
        fileList.add(srcFile1);
        String srcFile2 = directoryPath + "testMergeFile14_src2.txt";
        fileList.add(srcFile2);
        String srcFile3 = "testMergeFile14_src3.txt";
        fileList.add(srcFile3);

        String newFile = directoryPath + "testMergeFile14_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile1 = new File(srcFile1);
        testSrcFile1.delete();
        testSrcFile1.createNewFile();

        File testSrcFile2 = new File(srcFile2);
        testSrcFile2.delete();
        testSrcFile2.createNewFile();

        File testSrcFile3 = new File(directoryPath + srcFile3);
        testSrcFile3.delete();
        testSrcFile3.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFile1FileWriter = null;
        FileWriter testSrcFile2FileWriter = null;
        FileWriter testSrcFile3FileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFile1FileWriter = new FileWriter(testSrcFile1);
            testSrcFile1FileWriter.write("testMergeFile15_src1.txtf[^");
            testSrcFile1FileWriter.flush();
            testSrcFile1FileWriter.close();

            testSrcFile2FileWriter = new FileWriter(testSrcFile2);
            testSrcFile2FileWriter.write("testMergeFile15_src2.txtf[^");
            testSrcFile2FileWriter.flush();
            testSrcFile2FileWriter.close();

            testSrcFile3FileWriter = new FileWriter(testSrcFile3);
            testSrcFile3FileWriter.write("testMergeFile15_src3.txtf[^");
            testSrcFile3FileWriter.flush();
            testSrcFile3FileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile15_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not absolute.", e.getMessage());
            assertEquals(srcFile3, e.getFileName());

            // ԕω̊mF
            assertEquals(4, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(srcFile1, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));
            assertEquals(srcFile2, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 2, 0));
            assertEquals(srcFile3, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 3, 0));

            // }[W̃t@CemF
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testMergeFile15_src1.txtf[^"
                    + "testMergeFile15_src2.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFile1FileWriter != null) {
                testSrcFile1FileWriter.close();
            }
            if (testSrcFile2FileWriter != null) {
                testSrcFile2FileWriter.close();
            }
            if (testSrcFile3FileWriter != null) {
                testSrcFile3FileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile1);
            file.delete();
            file = new File(srcFile2);
            file.delete();
            file = new File(directoryPath + srcFile3);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /*
     * testMergeFile16() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,D,F,G <br>
     * <br>
     * ͒lF() fileList:vfȂListCX^X<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testMergeFile16_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () this.checkFileExist:true<br>
     * () fileListŎw肵t@C:݂Ȃ<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestMergeFile16_new.txtf[^<br>
     * <br>
     * bN|ĂB<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1Ă΂B<br>
     * newFilen邱ƁB<br>
     * (ԕω) newFileŎw肵t@C:ωȂ<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File control operation was failed."<br>
     * Et@CFnewFileƓl<br>
     * <br>
     * ُP[X<br>
     * (checkFileExistݒFTRUE)<br>
     * w肳ꂽʃt@Cɑ݂邪bNĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    // This testcase is ignored, because of Windows environment dependency.
    public void _ignore_testMergeFile16() throws Exception {
        // ̐ݒ
        List<String> fileList = new ArrayList<String>();

        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String newFile = directoryPath + "testMergeFile16_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testNewFileFileWriter = null;
        FileInputStream fis = null;
        FileLock lock = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testMergeFile16_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            fis = new FileInputStream(testNewFile);
            lock = fis.getChannel().lock(0L, Long.MAX_VALUE, true);

            // eXg{
            FileUtility.mergeFile(fileList, newFile);
            fail("FileException܂łB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // }[W̃t@CemF
            lock.release();
            File mergeFile = new File(newFile);
            assertTrue(mergeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mergeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testMergeFile16_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
            postReader.close();

        } finally {
            if (lock != null) {
                lock.release();
            }
            if (fis != null) {
                fis.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testRenameFile01_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testRenameFile01_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():false<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile01_src.txtf[^<br>
     * () newFileŎw肵t@C:݂ȂB<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂ȂB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile01_src.txtf[^<br>
     * <br>
     * P[X<br>
     * ύX̃t@C݂ȂꍇAt@CύX邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile01() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile01_src.txt";

        String newFile = directoryPath + "testRenameFile01_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();

        FileWriter testSrcFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testRenameFile01_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // t@C̕ύXmF
            File removeFile = new File(srcFile);
            assertFalse(removeFile.exists());

            File renameFile = new File(newFile);
            assertTrue(renameFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(renameFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile01_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,F <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testRenameFile02_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testRenameFile02_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile02_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile02_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂ȂB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile02_src.txtf[^<br>
     * <br>
     * P[X<br>
     * (checkFileExistݒFTRUE)<br>
     * ύX̃t@C݂ꍇÃt@C폜At@CύX邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile02() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile02_src.txt";

        String newFile = directoryPath + "testRenameFile02_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testRenameFile02_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testRenameFile02_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);

            // ԋplȂ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // t@C̕ύXmF
            File removeFile = new File(srcFile);
            assertFalse(removeFile.exists());

            File renameFile = new File(newFile);
            assertTrue(renameFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(renameFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile02_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testRenameFile03_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testRenameFile03_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():false<br>
     * () srcFileŎw肵t@C:݂ȂB<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile03_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂ȂB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile03_new.txtf[^<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"(pX)/testRenameFile03_src.txt is not exist."<br>
     * Et@CFsrcFileƓl<br>
     * <br>
     * ُP[X<br>
     * ύXOt@C݂ȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile03() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile03_src.txt";

        String newFile = directoryPath + "testRenameFile03_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testRenameFile03_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(srcFile + " is not exist.", e.getMessage());
            assertEquals(srcFile, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // t@C̕ύXmF
            File renameFile = new File(newFile);
            assertTrue(renameFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(renameFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile03_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testRenameFile04_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testRenameFile04_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():false<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile04_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile04_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile04_src.txtf[^<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile04_new.txtf[^<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"(pX)/testRenameFile04_new.txt is exist."<br>
     * EnewFileƓl<br>
     * <br>
     * ُP[X<br>
     * (checkFileExistݒFFALSE)<br>
     * ύX̃t@C݂ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile04() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile04_src.txt";

        String newFile = directoryPath + "testRenameFile04_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testRenameFile04_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testRenameFile04_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(newFile + " is exist.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));
            assertTrue(testSrcFile.exists());

            // t@C̕ύXmF
            File removeFile = new File(srcFile);
            assertTrue(removeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(removeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile04_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
            postReader.close();

            File renameFile = new File(newFile);
            assertTrue(renameFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(renameFile)));
            assertTrue(postReader.ready());
            expectationResultData = "testRenameFile04_new.txtf[^";
            data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /*
     * testRenameFile05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testRenameFile05_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testRenameFile05_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile05_src.txtf[^<br>
     * <br>
     * bN|ĂB<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile05_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile05_src.txtf[^<br>
     * (ԕω) newFileŎw肵t@C:݂ȂB<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File control operation was failed."<br>
     * <br>
     * ُP[X<br>
     * t@CbNȂǂŃt@CRenameɎsꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    // This testcase is ignored, because of Windows environment dependency.
    public void _ignore_testRenameFile05() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile05_src.txt";

        String newFile = directoryPath + "testRenameFile05_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        FileInputStream fis = null;
        FileLock lock = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testRenameFile05_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            fis = new FileInputStream(testSrcFile);
            lock = fis.getChannel().lock(0L, Long.MAX_VALUE, true);

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testRenameFile05_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // t@C̕ύXmF
            lock.release();
            File removeFile = new File(srcFile);
            assertTrue(removeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(removeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile05_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
            postReader.close();

            File renameFile = new File(newFile);
            assertFalse(renameFile.exists());
        } finally {
            if (lock != null) {
                lock.release();
            }
            if (fis != null) {
                fis.close();
            }
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:null<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testRenameFile06_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():true<br>
     * () srcFileŎw肵t@C:݂ȂB<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile06_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1ĂяoB<br>
     * srcFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂ȂB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile06_new.txtf[^<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not set."<br>
     * Et@CFnull<br>
     * <br>
     * ُP[X<br>
     * ύXOt@Cnull̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile06() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = null;

        String newFile = directoryPath + "testRenameFile06_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testRenameFile06_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not set.", e.getMessage());
            assertNull(e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // t@C̕ύXmF
            File renameFile = new File(newFile);
            assertTrue(renameFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(renameFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile06_new.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testRenameFile07_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "testRenameFile07_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile07_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile07_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile07_src.txtf[^<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile07_new.txtf[^<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not absolute."<br>
     * Et@CFnewFileƓl<br>
     * <br>
     * ُP[X<br>
     * ύXt@C΃pXŐݒ肳ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile07() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile07_src.txt";

        String newFile = "testRenameFile07_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(directoryPath + newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testRenameFile07_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testRenameFile07_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not absolute.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // t@C̕ύXmF
            File removeFile = new File(srcFile);
            assertTrue(removeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(removeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile07_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
            postReader.close();

            File renameFile = new File(directoryPath + newFile);
            assertTrue(renameFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(renameFile)));
            assertTrue(postReader.ready());
            expectationResultData = "testRenameFile07_new.txtf[^";
            data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(directoryPath + newFile);
            file.delete();
        }
    }

    /**
     * testRenameFile08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testRenameFile08_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:null<br>
     * () FileUtility#checkFileExist():true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile08_src.txtf[^<br>
     * () newFileŎw肵t@C:݂ȂB<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile08_src.txtf[^<br>
     * (ԕω) newFileŎw肵t@C:݂ȂB<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not set."<br>
     * Et@CFnull<br>
     * <br>
     * ُP[X<br>
     * ύXt@CnullŐݒ肳ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile08() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile08_src.txt";

        String newFile = null;

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testRenameFile08_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not set.", e.getMessage());
            assertNull(e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // t@C̕ύXmF
            File removeFile = new File(srcFile);
            assertTrue(removeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(removeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile08_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
            postReader.close();
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
        }
    }

    /**
     * testRenameFile09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "testRenameFile09_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testRenameFile09_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile09_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile09_new.txtf[^<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():1ĂяoB<br>
     * srcFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile09_src.txtf[^<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile09_new.txtf[^<br>
     * (ԕω) O:ȉ̏FileExceptionB<br>
     * EbZ[WF"File path is not absolute."<br>
     * Et@CFsrcFileƓl<br>
     * <br>
     * ُP[X<br>
     * ύXOt@C΃pXŐݒ肳ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRenameFile09() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = "testRenameFile09_src.txt";

        String newFile = directoryPath + "testRenameFile09_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile = new File(directoryPath + srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testRenameFile09_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testRenameFile09_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            // eXg{
            FileUtility.renameFile(srcFile, newFile);
            fail("FileException܂łBsłB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File path is not absolute.", e.getMessage());
            assertEquals(srcFile, e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));

            // t@C̕ύXmF
            File removeFile = new File(directoryPath + srcFile);
            assertTrue(removeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(removeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile09_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
            postReader.close();

            File renameFile = new File(newFile);
            assertTrue(renameFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(renameFile)));
            assertTrue(postReader.ready());
            expectationResultData = "testRenameFile09_new.txtf[^";
            data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(directoryPath + srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /*
     * testRenameFile10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,F,G <br>
     * <br>
     * ͒lF() srcFile:StringCX^X<br>
     * "(pX)/testRenameFile10_src.txt"<br>
     * <br>
     * ΃pX<br>
     * () newFile:StringCX^X<br>
     * "(pX)/testRenameFile10_new.txt"<br>
     * <br>
     * ΃pX<br>
     * () FileUtility#checkFileExist():true<br>
     * () srcFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile10_src.txtf[^<br>
     * () newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile10_new.txtf[^<br>
     * <br>
     * bN|ĂB<br>
     * <br>
     * ҒlF(ԕω) checkAbsolutePath():2ĂяoB<br>
     * 1ڂ̌ĂяoFsrcFilen邱ƁB<br>
     * 2ڂ̌ĂяoFnewFilen邱ƁB<br>
     * (ԕω) srcFileŎw肵t@C:݂ȂB<br>
     * (ԕω) newFileŎw肵t@C:݂B<br>
     * ȉ̃f[^ĂB<br>
     * EtestRenameFile02_src.txtf[^<br>
     * <br>
     * ُP[X<br>
     * (checkFileExistݒFTRUE)<br>
     * ύX̃t@C݂邪bNĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    // This testcase is ignored, because of Windows environment dependency.
    public void _ignore_testRenameFile10() throws Exception {
        // ̐ݒ
        String classFileName = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(classFileName);
        String directoryPath = url.getPath().substring(0,
                url.getPath().length() - classFileName.length());

        String srcFile = directoryPath + "testRenameFile10_src.txt";

        String newFile = directoryPath + "testRenameFile10_new.txt";

        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", true);

        // eXgΏۃt@CB
        File testSrcFile = new File(srcFile);
        testSrcFile.delete();
        testSrcFile.createNewFile();

        File testNewFile = new File(newFile);
        testNewFile.delete();
        testNewFile.createNewFile();

        FileWriter testSrcFileFileWriter = null;
        FileWriter testNewFileFileWriter = null;
        FileInputStream fis = null;
        FileLock lock = null;
        BufferedReader postReader = null;
        try {
            testSrcFileFileWriter = new FileWriter(testSrcFile);
            testSrcFileFileWriter.write("testRenameFile10_src.txtf[^");
            testSrcFileFileWriter.flush();
            testSrcFileFileWriter.close();

            testNewFileFileWriter = new FileWriter(testNewFile);
            testNewFileFileWriter.write("testRenameFile10_new.txtf[^");
            testNewFileFileWriter.flush();
            testNewFileFileWriter.close();

            fis = new FileInputStream(testNewFile);
            lock = fis.getChannel().lock(0L, Long.MAX_VALUE, true);

            // eXg{
            FileUtility.renameFile(srcFile, newFile);
            fail("FileException܂łB");
        } catch (FileException e) {
            // O̊mF
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("File control operation was failed.", e.getMessage());
            assertEquals(newFile, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(FileUtility.class,
                    "checkAbsolutePath"));
            assertEquals(srcFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 0, 0));
            assertEquals(newFile, VMOUTUtil.getArgument(FileUtility.class,
                    "checkAbsolutePath", 1, 0));

            // t@C̕ύXmF
            File removeFile = new File(srcFile);
            assertTrue(removeFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(removeFile)));
            assertTrue(postReader.ready());
            String expectationResultData = "testRenameFile10_src.txtf[^";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());

            File renameFile = new File(newFile);
            assertTrue(renameFile.exists());
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(renameFile)));
            assertTrue(postReader.ready());
            expectationResultData = "testRenameFile10_new.txtf[^";
            data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (lock != null) {
                lock.release();
            }
            if (fis != null) {
                fis.close();
            }
            if (testSrcFileFileWriter != null) {
                testSrcFileFileWriter.close();
            }
            if (testNewFileFileWriter != null) {
                testNewFileFileWriter.close();
            }
            if (postReader != null) {
                postReader.close();
            }
            // eXgt@C폜
            File file = new File(srcFile);
            file.delete();
            file = new File(newFile);
            file.delete();
        }
    }

    /**
     * testIsCheckFileExist01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() FileUtility#checkFileExist():false<br>
     * <br>
     * ҒlF(߂l) boolean:false<br>
     * <br>
     * ̒l擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsCheckFileExist01() throws Exception {
        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXg{
        boolean result = FileUtility.isCheckFileExist();
        // 
        assertFalse(result);
    }

    /**
     * testSetCheckFileExist01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() checkFileExist:true<br>
     * () FileUtility#checkFileExist():false<br>
     * <br>
     * ҒlF(ԕω) checkFileExist:true<br>
     * <br>
     * ̒lɐݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetCheckFileExist01() throws Exception {
        // O̐ݒ
        UTUtil.setPrivateField(FileUtility.class, "checkFileExist", false);

        // eXg{
        FileUtility.setCheckFileExist(true);

        // ԕω̊mF
        assertEquals(true, UTUtil.getPrivateField(FileUtility.class,
                "checkFileExist"));
    }
}
