/*
 * $Id: VMOUTUtil.java 5230 2007-09-28 10:04:13Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */
package jp.terasoluna.fw.file.ut;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager;
import jp.co.dgic.testing.common.virtualmock.MockObjectManager;

/**
 * djUnitVirtual Mock Object@\𗘗p邽߂̃[eBeBNXB JUnit̃eXgP[X痘pꍇ́AsetUp\bhɂ {@link VMOUTUtil#initialize()}
 * \bhĂяoKvB
 * @author rc@MV
 * @see jp.co.dgic.testing.common.virtualmock.MockObjectManager
 */
public class VMOUTUtil {

    /**
     * VMȌsB <code>JUnit</code>̃eXgP[X痘pꍇ́A <code>setUp</code>\bhŕK̃\bhĂяoȂ΂ȂȂB
     */
    public static void initialize() {
        MockObjectManager.initialize();
    }

    /**
     * w肵\bh<code>index</code>ڂ̌ĂяoLZA w肵IuWFNgԋpB
     * @param cls NXB
     * @param methodname \bhB
     * @param index ڂ̌ĂяoBItZbg̓[B
     * @param returnValue ԋpIuWFNgBv~eBu^Ԃꍇ̓bp[IuWFNgw肷B <code>null</code>w\B
     */
    @SuppressWarnings("unchecked")
    public static void setReturnValueAt(Class cls, String methodname,
            int index, Object returnValue) {
        if (returnValue == null) {
            MockObjectManager.setReturnNullAt(cls.getName(), methodname, index);
        } else {
            MockObjectManager.setReturnValueAt(cls.getName(), methodname,
                    index, returnValue);
        }
    }

    /**
     * w肵\bȟ̖ĂяoLZAw肵IuWFNgԋpB
     * @param cls NXB
     * @param methodname \bhB
     * @param returnValue ԋpIuWFNgBv~eBu^Ԃꍇ̓bp[IuWFNgw肷B <code>null</code>w\B
     */
    @SuppressWarnings("unchecked")
    public static void setReturnValueAtAllTimes(Class cls, String methodname,
            Object returnValue) {
        if (returnValue == null) {
            MockObjectManager
                    .setReturnNullAtAllTimes(cls.getName(), methodname);
        } else {
            MockObjectManager.setReturnValueAtAllTimes(cls.getName(),
                    methodname, returnValue);
        }
    }

    /**
     * w肵\bh<code>index</code>ڂ̌ĂяoLZAw肵OԋpB
     * @param cls NXB
     * @param methodname \bhB
     * @param index ڂ̌ĂяoBItZbg̓[B
     * @param exception ԋpOB
     */
    @SuppressWarnings("unchecked")
    public static void setExceptionAt(Class cls, String methodname, int index,
            Throwable exception) {
        MockObjectManager.setReturnValueAt(cls.getName(), methodname, index,
                exception);
    }

    /**
     * w肵\bȟ̖ĂяoLZAw肵OԋpB
     * @param cls NXB
     * @param methodname \bhB
     * @param exception ԋpOB
     */
    @SuppressWarnings("unchecked")
    public static void setExceptionAtAllTimes(Class cls, String methodname,
            Throwable exception) {
        MockObjectManager.setReturnValueAtAllTimes(cls.getName(), methodname,
                exception);
    }

    /**
     * w肵\bh<code>index</code>ڂ̌ĂяoLZB <code>void</code>^̃\bĥ݂ŗp\B
     * @param cls NXB
     * @param methodname \bhB
     * @param index ڂ̌ĂяoBItZbg̓[B
     */
    @SuppressWarnings("unchecked")
    public static void cancelMethodAt(Class cls, String methodname, int index) {
        MockObjectManager.setReturnValueAt(cls.getName(), methodname, index);
    }

    /**
     * w肵\bȟ̖ĂяoLZB<code>void</code>^̃\bĥ݂ŗp\B
     * @param cls NXB
     * @param methodname \bhB
     */
    @SuppressWarnings("unchecked")
    public static void cancelMethodAtAllTimes(Class cls, String methodname) {
        MockObjectManager.setReturnValueAtAllTimes(cls.getName(), methodname);
    }

    /**
     * w肵\bhĂяoꂽǂmFB
     * @param cls mFNXB
     * @param methodname mF\bhB
     * @return ĂяoĂtrueB
     */
    @SuppressWarnings("unchecked")
    public static boolean isCalled(Class cls, String methodname) {
        return MockObjectManager.isCalled(cls.getName(), methodname);
    }

    /**
     * w肵\bhĂяoꂽ񐔂擾B
     * @param cls mFNXB
     * @param methodname mF\bhB
     * @return Ăяoꂽ񐔁B
     */
    @SuppressWarnings("unchecked")
    public static int getCallCount(Class cls, String methodname) {
        return MockObjectManager.getCallCount(cls.getName(), methodname);
    }

    /**
     * w肳ꂽ\bh<code>methodindex</code>ڂ̌ĂяoɂāA <code>argumentindex</code>ڂ̈Ƃl擾B
     * @param cls mFNXB
     * @param methodname mF\bhB
     * @param methodindex ڂ̌ĂяomFBItZbg̓[B
     * @param argumentindex ڂ̈擾BItZbg̓[B
     * @return 擾̒lB
     */
    @SuppressWarnings("unchecked")
    public static Object getArgument(Class cls, String methodname,
            int methodindex, int argumentindex) {
        return MockObjectManager.getArgument(cls.getName(), methodname,
                methodindex, argumentindex);
    }

    /**
     * w肳ꂽ\bh<code>methodindex</code>ڂ̌ĂяôׂĂ̈擾B
     * @param cls mFNXB
     * @param methodname mF\bhB
     * @param methodindex ڂ̌ĂяomFBItZbg̓[B
     * @return 擾̒lListB
     */
    @SuppressWarnings("unchecked")
    public static List getArguments(Class cls, String methodname,
            int methodindex) {
        ArrayList<Object> list = new ArrayList<Object>();
        int argumentindex = 0;
        while (true) {
            try {
                list.add(getArgument(cls, methodname, methodindex,
                        argumentindex++));
            } catch (ArrayIndexOutOfBoundsException ex) {
                break;
            }
        }
        return list;
    }

    @SuppressWarnings("unchecked")
    public static Hashtable getTestDataTable() throws NoSuchFieldException {
        return (Hashtable) UTUtil.getField(InternalMockObjectManager
                .getTestData(), "valueTable");
    }

    @SuppressWarnings("unchecked")
    public static Hashtable getAllTimesTestDataTable()
                                                      throws NoSuchFieldException {
        return (Hashtable) UTUtil.getField(InternalMockObjectManager
                .getTestData(), "valueAtAllTimesTable");
    }

    @SuppressWarnings("unchecked")
    public static Hashtable getArgumentValues() throws NoSuchFieldException {
        return (Hashtable) UTUtil.getField(InternalMockObjectManager
                .getCallsMade(), "argumentValues");
    }

}
