/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.PlainFileLineIterator} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CsIuWFNgpȂt@CǍNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.PlainFileLineIterator
 */
public class PlainFileLineIteratorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(PlainFileLineIteratorTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public PlainFileLineIteratorTest(String name) {
        super(name);
    }

    /**
     * testPlainFileLineIterator01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() PlainFileLineIterator01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:PlainFileLineIterator_Stub01<br>
     * @@FileFormat̐ݒLAׂďlB<br>
     * () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     * E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineIterator#AbstractFileLineIterator():1Ăяo邱ƂmFB<br>
     * ĂяoƂ̈AfileName,clazz,columnParserMapƓCX^Xł邱<br>
     * (ԕω) AbstractFileLineIterator#init():1Ăяo邱ƁB<br>
     * <br>
     * eNX̃RXgN^Ă΂AeNXinit\bhs邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testPlainFileLineIterator01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^̎Ȃ̂ŕsv

        // ̐ݒ
        URL url = this.getClass().getResource("PlainFileLineIterator01.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub01> clazz = PlainFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        // Ȃ

        // eXg{
        new PlainFileLineIterator(fileName, clazz, columnParserMap);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        // 
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "<init>"));

        List arguments = VMOUTUtil.getArguments(AbstractFileLineIterator.class,
                "<init>", 0);
        assertEquals(3, arguments.size());
        assertEquals(fileName, arguments.get(0));
        assertSame(clazz, arguments.get(1));
        assertSame(columnParserMap, arguments.get(2));

        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "init"));
    }

    /**
     * testSeparateColumns01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileLineString:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) O:UnSupportedOperationException<br>
     * bZ[WF"separateColumns(String) isn't supported."<br>
     * <br>
     * ̃NXłseparateColumnsT|[gĂȂBāAUnSupportedOperationException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSeparateColumns01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("PlainFileLineIterator01.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub01> clazz = PlainFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        PlainFileLineIterator plainFileLineIterator = new PlainFileLineIterator(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            plainFileLineIterator.separateColumns(fileLineString);
            fail("UnSupportedOperationExceptionX[܂ł");
        } catch (UnsupportedOperationException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            // 
            assertSame(UnsupportedOperationException.class, e.getClass());
            assertEquals("separateColumns(String) isn't supported.", e
                    .getMessage());
        }
    }

    /**
     * testNext01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() Ώۃt@C:ȉ̓e"PlainFileLineIterator_next01.txt"t@C݂B<br>
     * -------------------<br>
     * Psڃf[^<br>
     * -------------------<br>
     * f[^<br>
     * () this.readTrailer:false<br>
     * <br>
     * ҒlF(߂l) String:StringCX^X<br>
     * ireadLiněʁj<br>
     * (ԕω) AbstractFileLineIterator#readLine():1Ă΂<br>
     * (ԕω) currentLineCount:1<br>
     * <br>
     * hasNextb\hTRUEɂȂĂꍇreadLineb\hĂ΂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("PlainFileLineIterator01.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub01> clazz = PlainFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        PlainFileLineIterator plainFileLineIterator = new PlainFileLineIterator(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        String result = plainFileLineIterator.next();

        // ԋpl̊mF
        assertEquals("1sڃf[^", result);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));
        assertEquals(1, UTUtil.getPrivateField(plainFileLineIterator,
                "currentLineCount"));
    }

    /**
     * testNext02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FF.G <br>
     * <br>
     * ͒lF() Ώۃt@C:ȉ̓e"PlainFileLineIterator_next02.txt"t@C݂B<br>
     * -------------------<br>
     * <br>
     * -------------------<br>
     * f[^<br>
     * () this.readTrailer:false<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineIterator#readLine():Ă΂Ȃ<br>
     * (ԕω) currentLineCount:0<br>
     * (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     * EbZ[WF"The data which can be acquired doesn't exist."<br>
     * EOFNoSuchElementException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * EsԍF0<br>
     * EJFnull<br>
     * EJCfbNXF-1<br>
     * <br>
     * hasNextb\hFALSEɂȂĂꍇ<br>
     * NoSuchElementExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub01> clazz = PlainFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        PlainFileLineIterator plainFileLineIterator = new PlainFileLineIterator(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            plainFileLineIterator.next();
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            assertSame(FileLineException.class, e.getClass());
            assertEquals("The data which can be acquired doesn't exist.", e
                    .getMessage());
            assertSame(NoSuchElementException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals(1, e.getLineNo());
            assertNull(e.getColumnName());
            assertEquals(-1, e.getColumnIndex());

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(0, UTUtil.getPrivateField(plainFileLineIterator,
                    "currentLineCount"));

        }
    }

    /**
     * testNext03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FF.G <br>
     * <br>
     * ͒lF() Ώۃt@C:ȉ̓e"PlainFileLineIterator_next03.txt"t@C݂B<br>
     * -------------------<br>
     * 1sڃf[^<br>
     * 2sڃf[^<br>
     * -------------------<br>
     * f[^<br>
     * () this.readTrailer:true<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineIterator#readLine():Ă΂Ȃ<br>
     * (ԕω) currentLineCount:0<br>
     * (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     * EbZ[WF"Data part should be called before trailer part."<br>
     * EOFIllegalStateException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * EsԍF0<br>
     * <br>
     * hasNextb\hFALSEɂȂĂꍇ<br>
     * NoSuchElementExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("PlainFileLineIterator03.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub03> clazz = PlainFileLineIterator_Stub03.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        PlainFileLineIterator plainFileLineIterator = new PlainFileLineIterator(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(plainFileLineIterator, "readTrailer", true);

        // eXg{
        try {
            plainFileLineIterator.next();
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            assertSame(FileLineException.class, e.getClass());
            assertEquals("Data part should be called before trailer part.", e
                    .getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals(0, e.getLineNo());

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(0, UTUtil.getPrivateField(plainFileLineIterator,
                    "currentLineCount"));

        }
    }

    /**
     * n<br>
     * FileFormatencloseChardelimiterݒ肳ĂĂA
     * @throws Exception
     */
    public void testNext04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        PlainFileLineIterator fileLineIterator = new PlainFileLineIterator(
                fileName, PlainFileLineIterator_Stub02.class, columnParserMap);

        // eXg{
        String result1 = fileLineIterator.next();
        String result2 = fileLineIterator.next();
        String result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("\"1\",22,333,|4444|", result1);
        assertEquals("\"5\",66,777,|8888|", result2);
        assertEquals("\"9\",AA,BBB,|CCCC|", result3);
    }

    /**
     * testSkipint01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() skipLines:0<br>
     * () Ώۃt@C:ȉ̓e"PlainFileLineIterator_skip01.txt"t@C݂B<br>
     * -------------------<br>
     * 3sڃf[^<br>
     * -------------------<br>
     * () this.readLine():s<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.readLine:Ă΂Ȃ<br>
     * (ԕω) this.currentLineCount:0<br>
     * <br>
     * p^[B<br>
     * SkipΏۍsȂꍇÂ܂ܐI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = PlainFileLineIteratorTest.class
                .getResource("PlainFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        PlainFileLineIterator fileLineIterator = new PlainFileLineIterator(
                fileName, PlainFileLineIterator_Stub01.class, columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 0;

        // O̐ݒ
        fileLineIterator.init();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        fileLineIterator.skip(skipLines);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));
        assertEquals(0, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));
    }

    /**
     * testSkipint02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() skipLines:1<br>
     * () Ώۃt@C:ȉ̓e"PlainFileLineIterator_skip01.txt"t@C݂B<br>
     * -------------------<br>
     * 3sڃf[^<br>
     * -------------------<br>
     * () this.readLine():s<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.readLine:1Ă΂<br>
     * (ԕω) this.currentLineCount:1<br>
     * <br>
     * p^[B<br>
     * SkipΏۍsPs̏ꍇAΏۃf[^PsǂނƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = AbstractFileLineIteratorTest.class
                .getResource("PlainFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        PlainFileLineIterator fileLineIterator = new PlainFileLineIterator(
                fileName, PlainFileLineIterator_Stub01.class, columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 1;

        // O̐ݒ
        fileLineIterator.init();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        fileLineIterator.skip(skipLines);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));
        assertEquals(1, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));
    }

    /**
     * testSkipint03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() skipLines:3<br>
     * () Ώۃt@C:ȉ̓e"PlainFileLineIterator_skip01.txt"t@C݂B<br>
     * -------------------<br>
     * 3sڃf[^<br>
     * -------------------<br>
     * () this.readLine():s<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.readLine:3Ă΂<br>
     * (ԕω) this.currentLineCount:3<br>
     * <br>
     * p^[B<br>
     * SkipΏۍsRs̏ꍇAΏۃf[^RsǂނƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = AbstractFileLineIteratorTest.class
                .getResource("PlainFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        PlainFileLineIterator fileLineIterator = new PlainFileLineIterator(
                fileName, PlainFileLineIterator_Stub01.class, columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 3;

        // O̐ݒ
        fileLineIterator.init();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        fileLineIterator.skip(skipLines);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(3, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));
        assertEquals(3, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));
    }

    /**
     * testSkipint04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() skipLines:1<br>
     * () Ώۃt@C:ȉ̓e"PlainFileLineIterator_skip01.txt"t@C݂B<br>
     * -------------------<br>
     * 3sڃf[^<br>
     * -------------------<br>
     * () this.readLine():FileExceptionO𔭐B<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.currentLineCount:0<br>
     * (ԕω) Ȃ:this.readLine()ŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     * OB<br>
     * Ώۃf[^ǂޏŗOꍇA̗Ô܂ܕԂ邱ƂmFBB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = AbstractFileLineIteratorTest.class
                .getResource("PlainFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        PlainFileLineIterator fileLineIterator = new PlainFileLineIterator(
                fileName, PlainFileLineIterator_Stub01.class, columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 1;

        // O̐ݒ
        fileLineIterator.init();
        FileException exception = new FileException("readLine̗Oł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "readLine", exception);
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            fileLineIterator.skip(skipLines);
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // O̊mF
            assertSame(exception, e);

            // ԕω̊mF
            assertEquals(0, UTUtil.getPrivateField(fileLineIterator,
                    "currentLineCount"));
        }
    }

    /**
     * testSkipint05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() skipLines:100<br>
     * Ώۃt@C̍s𒴂ݒ<br>
     * () Ώۃt@C:ȉ̓e"PlainFileLineIterator_skip01.txt"t@C݂B<br>
     * -------------------<br>
     * 3sڃf[^<br>
     * -------------------<br>
     * () this.readLine():s<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.readLine:3Ă΂<br>
     * (ԕω) this.currentLineCount:3<br>
     * (ԕω) Ȃ:ȉ̐ݒFileLineExceptionB<br>
     * EbZ[WF"The data which can be acquired doesn't exist."<br>
     * EOFNoSuchElementException<br>
     * Et@CFΏۃt@C<br>
     * EsԍF4<br>
     * <br>
     * OB<br>
     * SkipΏۍs̐Ώۃf[^̐zꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = AbstractFileLineIteratorTest.class
                .getResource("PlainFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        PlainFileLineIterator fileLineIterator = new PlainFileLineIterator(
                fileName, PlainFileLineIterator_Stub01.class, columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 100;

        // O̐ݒ
        fileLineIterator.init();

        // eXg{
        try {
            fileLineIterator.skip(skipLines);
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // O̊mF
            assertEquals("The data which can be acquired doesn't exist.", e
                    .getMessage());
            assertTrue(NoSuchElementException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());
            assertEquals(4, e.getLineNo());

            // ԕω̊mF
            assertEquals(3, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(3, UTUtil.getPrivateField(fileLineIterator,
                    "currentLineCount"));
        }
    }

    /**
     * testGetDelimiter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() delimiter:'#'<br>
     * <br>
     * ҒlF(߂l) char:','<br>
     * <br>
     * delimitergetterɓ삷邱ƂmFB<br>
     * K','ԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetDelimiter01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("PlainFileLineIterator01.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub02> clazz = PlainFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        PlainFileLineIterator plainFileLineIterator = new PlainFileLineIterator(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        char result = plainFileLineIterator.getDelimiter();

        // ԋpl̊mF
        assertEquals(',', result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetEncloseChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() encloseChar:'\"'<br>
     * <br>
     * ҒlF(߂l) char:Character.MIN_VALUE<br>
     * <br>
     * encloseChargetterɓ삷邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetEncloseChar01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("PlainFileLineIterator01.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub02> clazz = PlainFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        PlainFileLineIterator plainFileLineIterator = new PlainFileLineIterator(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        char result = plainFileLineIterator.getEncloseChar();

        // ԋpl̊mF
        assertEquals(Character.MIN_VALUE, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetCurrentLineCount01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() currentLineCount:5<br>
     * <br>
     * ҒlF(߂l) int:5<br>
     * <br>
     * currentLineCountgetterɓ삷邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetCurrentLineCount01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("PlainFileLineIterator01.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub02> clazz = PlainFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        PlainFileLineIterator plainFileLineIterator = new PlainFileLineIterator(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(plainFileLineIterator, "currentLineCount", 5);
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        int result = plainFileLineIterator.getCurrentLineCount();

        // ԋpl̊mF
        assertEquals(5, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetTrailer01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() readTrailer:false<br>
     * <br>
     * ҒlF(߂l) List<String>:super#getTrailer()̖߂l<br>
     * gCf[^<br>
     * (ԕω) readTrailer:true<br>
     * <br>
     * getTrailer()ĂԂƂɂāAgCf[^擾AgCmFptOTrueɕω邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetTrailer01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("PlainFileLineIterator03.txt");
        String fileName = url.getPath();
        Class<PlainFileLineIterator_Stub03> clazz = PlainFileLineIterator_Stub03.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        PlainFileLineIterator plainFileLineIterator = new PlainFileLineIterator(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        List<String> trailer = plainFileLineIterator.getTrailer();

        // ԋpl̊mF
        assertEquals(1, trailer.size());
        assertEquals("gCf[^", trailer.get(0));

        // ԕω̊mF
        assertTrue((Boolean) UTUtil.getPrivateField(plainFileLineIterator,
                "readTrailer"));
    }
}
