/*
 * $Id: LineFeed2LineReaderTest.java 5354 2007-10-03 06:06:25Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.easymock.classextension.EasyMock;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.LineFeed2LineReader} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> ͂ݕȂAs؂蕶2̏ꍇ̃t@C1s̕擾鏈sB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.LineFeed2LineReader
 */
public class LineFeed2LineReaderTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(LineFeed2LineReaderTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public LineFeed2LineReaderTest(String name) {
        super(name);
    }

    /**
     * testLineFeed2LineReaderReaderString01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() reader:Reader̃CX^X<br>
     * () lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(ԕω) this.reader:readerƓ̃CX^X<br>
     * (ԕω) this.lineFeedChar:lineFeedCharƓ̃CX^X<br>
     * <br>
     * P[XB<br>
     * nꂽ̏IuWFNg邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testLineFeed2LineReader01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";

        // O̐ݒ
        // Ȃ

        // eXg{
        LineFeed2LineReader result = new LineFeed2LineReader(reader,
                lineFeedChar);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertSame(reader, UTUtil.getPrivateField(result, "reader"));
        assertEquals(lineFeedChar, UTUtil.getPrivateField(result,
                "lineFeedChar"));
    }

    /**
     * testLineFeed2LineReaderReaderString02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() reader:null<br>
     * () lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(ԕω) -:IllegalArgumentException<br>
     * EbZ[WF"reader is required."<br>
     * <br>
     * OB<br>
     * readernull̏ꍇɁA邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testLineFeed2LineReader02() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        BufferedReader reader = null;
        String lineFeedChar = "\r\n";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            new LineFeed2LineReader(reader, lineFeedChar);
            fail("IllegalArgumentExceptionX[܂ł");
        } catch (IllegalArgumentException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertSame(IllegalArgumentException.class, e.getClass());
            assertEquals("reader is required.", e.getMessage());
        }
    }

    /**
     * testLineFeed2LineReaderReaderString03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() reader:Reader̃CX^X<br>
     * () lineFeedChar:null<br>
     * <br>
     * ҒlF(ԕω) -:IllegalArgumentException<br>
     * EbZ[WF"lineFeedChar is required."<br>
     * <br>
     * OB<br>
     * lineFeedCharnull̏ꍇɁA邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testLineFeed2LineReader03() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = null;

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            new LineFeed2LineReader(reader, lineFeedChar);
            fail("IllegalArgumentExceptionX[܂ł");
        } catch (IllegalArgumentException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertSame(IllegalArgumentException.class, e.getClass());
            assertEquals("lineFeedChar is required.", e.getMessage());
        }
    }

    /**
     * testLineFeed2LineReaderReaderString04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() reader:Reader̃CX^X<br>
     * () lineFeedChar:"123"<br>
     * <br>
     * ҒlF(ԕω) -:IllegalArgumentException<br>
     * EbZ[WF"lineFeedChar should be defined by 2 digit of character string."<br>
     * <br>
     * OB<br>
     * lineFeedChar2ł͂ȂꍇɁA邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testLineFeed2LineReader04() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        byte[] buf = {};
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "123";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            new LineFeed2LineReader(reader, lineFeedChar);
            fail("IllegalArgumentExceptionX[܂ł");
        } catch (IllegalArgumentException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertSame(IllegalArgumentException.class, e.getClass());
            assertEquals(
                    "lineFeedChar should be defined by 2 digit of character string.",
                    e.getMessage());
        }
    }

    /**
     * testReadLine01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.reader:ȂReaderCX^X<br>
     * () this.lineFeedChar:"\r\n"<br>
     * () Reader.ready():IOExceptionOB<br>
     * <br>
     * ҒlF(ԕω) -:ȉ̏FileException<br>
     * EOFIOException(Reader.ready()Ŕ)<br>
     * EbZ[WF"Reader control operation was failed."<br>
     * <br>
     * OB<br>
     * Readeȑԃ`FbNŗOꍇA FileException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine01() throws Exception {
        // Mock쐬
        Reader reader = EasyMock.createMock(Reader.class);
        EasyMock.expect(reader.read()).andReturn(null).andThrow(
                new IOException());
        EasyMock.replay(reader);

        // eXgΏۂ̃CX^X
        String lineFeedChar = "\r\n";
        LineFeed2LineReader lineFeed2LineReader = new LineFeed2LineReader(
                reader, lineFeedChar);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            lineFeed2LineReader.readLine();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertSame(FileException.class, e.getClass());
            assertEquals("Reader control operation was failed.", e.getMessage());
            assertSame(IOException.class, e.getCause().getClass());
        }
    }

    /**
     * testReadLine02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() this.reader:ȉ̏ReaderCX^X<br>
     * ""()<br>
     * <br>
     * f[^ȂB<br>
     * () this.lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * p^[B<br>
     * ReaderɎ擾񂪖ꍇA̕񂪕ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine02() throws Exception {
        // eXgΏۂ̃CX^X
        byte[] buf = "".getBytes();
        InputStream inputStream = new ByteArrayInputStream(buf);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";
        LineFeed2LineReader lineFeed2LineReader = new LineFeed2LineReader(
                reader, lineFeedChar);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String result = lineFeed2LineReader.readLine();

        // ԋpl̊mF
        assertEquals("", result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testReadLine03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() this.reader:ȉ̏ReaderCX^X<br>
     * "aaa,aaa,aaa\r\n"<br>
     * <br>
     * Ō̍s؂蕶1sf[^<br>
     * () this.lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(߂l) String:"aaa,aaa,aaa"<br>
     * <br>
     * p^[B<br>
     * ReaderɂPs݂̏̂ꍇ(Ōɍs؂蕶)ÂPs̏񂪕ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine03() throws Exception {
        // eXgΏۂ̃CX^X
        String byteParm = "aaa,aaa,aaa\r\n";
        InputStream inputStream = new ByteArrayInputStream(byteParm.getBytes());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";
        LineFeed2LineReader lineFeed2LineReader = new LineFeed2LineReader(
                reader, lineFeedChar);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String result = lineFeed2LineReader.readLine();

        // ԋpl̊mF
        assertEquals("aaa,aaa,aaa", result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testReadLine04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() this.reader:ȉ̏ReaderCX^X<br>
     * "\"aaa\",\"aaa\",\"aa\r\na\"\r\n"<br>
     * <br>
     * s؂蕶镡sf[^<br>
     * () this.lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(߂l) String:"\"aaa\",\"aaa\",\"aa"<br>
     * <br>
     * p^[B<br>
     * Readerɕs̏񂪂ꍇAŏ̂Ps̏̂ݕԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine04() throws Exception {
        // eXgΏۂ̃CX^X
        String byteParm = "\"aaa\",\"aaa\",\"aa\r\na\"\r\n";
        InputStream inputStream = new ByteArrayInputStream(byteParm.getBytes());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";
        LineFeed2LineReader lineFeed2LineReader = new LineFeed2LineReader(
                reader, lineFeedChar);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String result = lineFeed2LineReader.readLine();

        // ԋpl̊mF
        assertEquals("\"aaa\",\"aaa\",\"aa", result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testReadLine05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.reader:ȂReaderCX^X<br>
     * () this.lineFeedChar:"\r\n"<br>
     * () Reader.read():IOExceptionOB<br>
     * <br>
     * ҒlF(ԕω) -:ȉ̏FileException<br>
     * EOFIOException(Reader.read()Ŕ)<br>
     * EbZ[WF"Reader control operation was failed."<br>
     * <br>
     * OB<br>
     * Reader̓ǂݏŗOꍇAFileException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine05() throws Exception {
        // Mock쐬
        Reader reader = EasyMock.createMock(Reader.class);
        EasyMock.expect(reader.read()).andReturn(null).andThrow(
                new IOException());
        EasyMock.replay(reader);

        // eXgΏۂ̃CX^X
        String lineFeedChar = "\r\n";
        LineFeed2LineReader lineFeed2LineReader = new LineFeed2LineReader(
                reader, lineFeedChar);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            lineFeed2LineReader.readLine();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertSame(FileException.class, e.getClass());
            assertEquals("Reader control operation was failed.", e.getMessage());
            assertSame(IOException.class, e.getCause().getClass());
        }
    }

    /**
     * testReadLine06() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() this.reader:ȉ̏ReaderCX^X<br>
     * "999,999,999"<br>
     * <br>
     * s؂蕶܂߂Ȃf[^<br>
     * () this.lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(߂l) String:"999,999,999"<br>
     * <br>
     * p^[B<br>
     * ReaderɂPs݂̏̂ꍇ(s؂蕶Ȃ)ÂPs̏񂪕ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine06() throws Exception {
        // eXgΏۂ̃CX^X
        String byteParm = "999,999,999";
        InputStream inputStream = new ByteArrayInputStream(byteParm.getBytes());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";
        LineFeed2LineReader lineFeed2LineReader = new LineFeed2LineReader(
                reader, lineFeedChar);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String result = lineFeed2LineReader.readLine();

        // ԋpl̊mF
        assertEquals(byteParm, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testReadLine07() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() this.reader:ȉ̏ReaderCX^X<br>
     * "101010,101010,101010\rn"<br>
     * <br>
     * s؂蕶̍ŏ݂̌̂f[^<br>
     * () this.lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(߂l) String:"101010,101010,101010\rn"<br>
     * <br>
     * p^[B<br>
     * s؂蕶̐擪̂݃f[^Ɋ܂܂ĂꍇÄʒuōs؂菈sȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine07() throws Exception {
        // eXgΏۂ̃CX^X
        String byteParm = "101010,101010,101010\rn";
        InputStream inputStream = new ByteArrayInputStream(byteParm.getBytes());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";
        LineFeed2LineReader lineFeed2LineReader = new LineFeed2LineReader(
                reader, lineFeedChar);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String result = lineFeed2LineReader.readLine();

        // ԋpl̊mF
        assertEquals("101010,101010,101010\rn", result);

        // ԕω̊mF
        // Ȃ

    }

    /**
     * testReadLine08() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() this.reader:ȉ̏ReaderCX^X<br>
     * "\r\n"<br>
     * <br>
     * s؂蕶̍ŏ݂̌̂f[^<br>
     * () this.lineFeedChar:"\r\n"<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * ̒ɑSp܂܂ĂꍇBPs̏񂪕ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine08() throws Exception {
        // eXgΏۂ̃CX^X
        String byteParm = "\r\n";
        InputStream inputStream = new ByteArrayInputStream(byteParm.getBytes());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String lineFeedChar = "\r\n";
        LineFeed2LineReader lineFeed2LineReader = new LineFeed2LineReader(
                reader, lineFeedChar);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String result = lineFeed2LineReader.readLine();

        // ԋpl̊mF
        assertEquals("", result);

        // ԕω̊mF
        // Ȃ

    }
}
