/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.IntColumnParser} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> w肳ꂽp[YAint^ɕϊB<br>
 * ϊʂt@CsIuWFNgint^̑ɒli[B
 * <p>
 * @author c Ni
 * @see jp.terasoluna.fw.file.dao.standard.IntColumnParser
 */
public class IntColumnParserTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(IntColumnParserTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public IntColumnParserTest(String name) {
        super(name);
    }

    /**
     * testParse01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * "1"<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂint^ setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉public<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵 intɕϊĊi[B<br>
     * "1"<br>
     * <br>
     * t@CsIuWFNgint^ɕݒ肷邱Ƃł邱Ƃ mFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse01() throws Exception {
        // eXgΏۂ̃CX^X
        IntColumnParser intColumnParser = new IntColumnParser();

        // ̐ݒ
        String column = "1";
        IntColumnParser_Stub01 t = new IntColumnParser_Stub01();
        Method method = IntColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Integer.TYPE });
        String columnFormat = "";

        // O̐ݒ
        // Ȃ

        // eXg{
        intColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        assertEquals(1, result);
    }

    /**
     * testParse02() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * "1"<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂint^ setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉private<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:IllegalAccessException邱Ƃ mFB<br>
     * <br>
     * t@CsIuWFNgint^setter\bhɃANZXłȂꍇA IllegalAccessExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse02() throws Exception {
        // eXgΏۂ̃CX^X
        IntColumnParser intColumnParser = new IntColumnParser();

        // ̐ݒ
        String column = "1";
        IntColumnParser_Stub01 t = new IntColumnParser_Stub01();
        Method method = IntColumnParser_Stub01.class.getDeclaredMethod(
                "setAPrivate", new Class[] { Integer.TYPE });
        String columnFormat = "";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            intColumnParser.parse(column, t, method, columnFormat);
            fail("IllegalAccessExceptionX[܂łB");
        } catch (IllegalAccessException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(IllegalAccessException.class, e.getClass());
        }
    }

    /**
     * testParse03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * "1"<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂint^ setter\bh<br>
     * method:setter\bhOX[<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:InvocationTargetException邱Ƃ mFB<br>
     * <br>
     * t@CsIuWFNgint^setter\bhOX[ꍇA setter\bhX[ObvInvocationTargetException X[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse03() throws Exception {
        // eXgΏۂ̃CX^X
        IntColumnParser intColumnParser = new IntColumnParser();

        // ̐ݒ
        String column = "1";
        IntColumnParser_Stub01 t = new IntColumnParser_Stub01();
        Method method = IntColumnParser_Stub01.class.getDeclaredMethod(
                "setAException", new Class[] { Integer.TYPE });
        String columnFormat = "";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            intColumnParser.parse(column, t, method, columnFormat);
            fail();
        } catch (InvocationTargetException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(InvocationTargetException.class, e.getClass());
        }
    }

    /**
     * testParse04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * "1"<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂint^ setter\bh<br>
     * method:setter\bḧ<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException邱Ƃ mFB<br>
     * <br>
     * t@CsIuWFNgint^setter\bḧꍇA IllegalArgumentExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse04() throws Exception {
        // eXgΏۂ̃CX^X
        IntColumnParser intColumnParser = new IntColumnParser();

        // ̐ݒ
        String column = "1";
        IntColumnParser_Stub01 t = new IntColumnParser_Stub01();
        Method method = IntColumnParser_Stub01.class.getDeclaredMethod(
                "setAAndB", new Class[] { Integer.TYPE, Integer.TYPE });
        String columnFormat = "";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            intColumnParser.parse(column, t, method, columnFormat);

            // 
            fail();
        } catch (IllegalArgumentException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
        }
    }

    /**
     * testParse05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:ȊO̕<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂint^ setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉public<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:NumberFormatException邱ƂmFB<br>
     * <br>
     * ̕񂪐ȊO(int^ɕϊłȂ)̏ꍇA NumberFormatExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse05() throws Exception {
        // eXgΏۂ̃CX^X
        IntColumnParser intColumnParser = new IntColumnParser();

        // ̐ݒ
        String column = "a";
        IntColumnParser_Stub01 t = new IntColumnParser_Stub01();
        Method method = IntColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Integer.TYPE });
        String columnFormat = "";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            intColumnParser.parse(column, t, method, columnFormat);

            // 
            fail();
        } catch (NumberFormatException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(NumberFormatException.class, e.getClass());
        }
    }

    /**
     * testParse06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:null<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂint^setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉public<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * ""<br>
     * <br>
     * ҒlF(ԕω) O:NumberFormatException邱ƂmFB<br>
     * <br>
     * ̕null̏ꍇANumberFormatExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse06() throws Exception {
        // eXgΏۂ̃CX^X
        IntColumnParser intColumnParser = new IntColumnParser();

        // ̐ݒ
        String column = null;
        IntColumnParser_Stub01 t = new IntColumnParser_Stub01();
        Method method = IntColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Integer.TYPE });
        String columnFormat = "";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            intColumnParser.parse(column, t, method, columnFormat);

            // 
            fail();
        } catch (NumberFormatException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(NumberFormatException.class, e.getClass());
        }
    }

    /**
     * testParse07() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * "1"<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂint^setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉public<br>
     * () tH[}bgp̕<br>
     * columnFormat:null<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵intɕϊĊi[B<br>
     * "1"<br>
     * <br>
     * ̃tH[}bgpnull̏ꍇAt@CsIuWFNgint^ɕݒ肷邱Ƃł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse07() throws Exception {
        // eXgΏۂ̃CX^X
        IntColumnParser intColumnParser = new IntColumnParser();

        // ̐ݒ
        String column = "1";
        IntColumnParser_Stub01 t = new IntColumnParser_Stub01();
        Method method = IntColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { Integer.TYPE });
        String columnFormat = null;

        // O̐ݒ
        // Ȃ

        // eXg{
        intColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        assertEquals(1, result);
    }
}
