/*
 * $Id: DecimalColumnParserTest.java 5354 2007-10-03 06:06:25Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.DecimalColumnParser} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> w肳ꂽp[YABigDecimal^ɕϊB<br>
 * ϊʂt@CsIuWFNgBigDecimal^̑ɒli[B
 * <p>
 * @author c Ni
 * @see jp.terasoluna.fw.file.dao.standard.DecimalColumnParser
 */
public class DecimalColumnParserTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(DecimalColumnParserTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public DecimalColumnParserTest(String name) {
        super(name);
    }

    /**
     * testParse01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,E <br>
     * <br>
     * ͒lF() column:"123456"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal01<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:null<br>
     * <br>
     * ҒlF(ԕω) t:ΏۃtB[hBigDecimal.valueOf(123456)li[B<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕null̏ꍇA tB[hsetter\bhݒ肳ĂꍇɁA ̕񂪐BigDecimalɕϊĊi[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse01() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "123456";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        stub.setDecimal01(null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal01",
                        new Class[] { BigDecimal.class });
        String columnFormat = null;

        // eXg{
        decimalColumnParser.parse(column, stub, method, columnFormat);

        // 
        BigDecimal result = stub.getDecimal01();
        assertNotNull(result);
        assertEquals(BigDecimal.valueOf(123456), result);
    }

    /**
     * testParse02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() column:"-\\123,456.00"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal02<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:"-\\###,###,###.##"<br>
     * <br>
     * ҒlF(ԕω) t:ΏۃtB[hBigDecimal.valueOf(12345600, 2)li[B<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕񂪂ꍇA tB[hsetter\bhݒ肳ĂꍇɁA ̕񂪐tH[}bgɏ]BigDecimalɕϊĊi[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse02() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "-\\123,456.00";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        stub.setDecimal02(null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal02",
                        new Class[] { BigDecimal.class });
        String columnFormat = "-\\###,###,###.##";

        // eXg{
        decimalColumnParser.parse(column, stub, method, columnFormat);

        // 
        BigDecimal result = stub.getDecimal02();
        assertNotNull(result);
        assertEquals(BigDecimal.valueOf(12345600, 2), result);
    }

    /**
     * testParse03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"-\\123,456.00"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal03<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:"###,###,###.##"<br>
     * <br>
     * tH[}bgłȂ<br>
     * <br>
     * ҒlF(ԕω) -:ParseException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * tH[}bgŃp[VOłȂf[^nꂽꍇA ParseException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse03() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "-\\123,456.00";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        stub.setDecimal03(null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal03",
                        new Class[] { BigDecimal.class });
        String columnFormat = "###,###,###.##";

        try {
            // eXg{
            decimalColumnParser.parse(column, stub, method, columnFormat);
            fail("ParseException܂łB");
        } catch (ParseException e) {
            // 
            assertTrue(e instanceof ParseException);
        }
    }

    /**
     * testParse04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"-\\123,456.00"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal04<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFprivate<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:"-\\###,###,###.##"<br>
     * <br>
     * ҒlF(ԕω) -:IllegalAccessException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * tB[hsetter\bhprivateŐ錾ꂽꍇA IllegalAccessException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse04() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "-\\123,456.00";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        UTUtil.setPrivateField(stub, "decimal04", null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal04",
                        new Class[] { BigDecimal.class });
        String columnFormat = "\\###,###,###.##";

        try {
            // eXg{
            decimalColumnParser.parse(column, stub, method, columnFormat);
            fail("IllegalAccessException܂łB");
        } catch (IllegalAccessException e) {
            // 
            assertTrue(e instanceof IllegalAccessException);
        }
    }

    /**
     * testParse05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"-\\123,456.00"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal05<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFOB<br>
     * () columnFormat:"-\\###,###,###.##"<br>
     * <br>
     * ҒlF(ԕω) -:InvocationTargetException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * tB[hsetter\bh̏ŗOꍇA IvocationTargetException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse05() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "-\\123,456.00";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        UTUtil.setPrivateField(stub, "decimal05", null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal05",
                        new Class[] { BigDecimal.class });
        String columnFormat = "-\\###,###,###.##";

        try {
            // eXg{
            decimalColumnParser.parse(column, stub, method, columnFormat);
            fail("InvocationTargetException܂łB");
        } catch (InvocationTargetException e) {
            // 
            assertTrue(e instanceof InvocationTargetException);
        }
    }

    /**
     * testParse06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"-\\123,456.00"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal06<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EFQ(BigDecimal^Q)<br>
     * EFԖڂ̈ΏۃtB[hɊi[B<br>
     * () columnFormat:"-\\###,###,###.##"<br>
     * <br>
     * ҒlF(ԕω) -:IllegalArgumentException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * tB[hsetter\bhBigDecimal^PȊOꍇA llegalArgumentException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse06() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "-\\123,456.00";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        UTUtil.setPrivateField(stub, "decimal06", null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal06", new Class[] {
                        BigDecimal.class, BigDecimal.class });

        String columnFormat = "-\\###,###,###.##";

        try {
            // eXg{
            decimalColumnParser.parse(column, stub, method, columnFormat);
            fail("IllegalArgumentException܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(e instanceof IllegalArgumentException);
        }
    }

    /**
     * testParse07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:null<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal06<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:"-\\###,###,###.##"<br>
     * <br>
     * ҒlF(ԕω) -:NullPointerException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * null̏ꍇANullPointerException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse07() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = null;
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        UTUtil.setPrivateField(stub, "decimal07", null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal07",
                        new Class[] { BigDecimal.class });
        String columnFormat = "-\\###,###,###.##";

        try {
            // eXg{
            decimalColumnParser.parse(column, stub, method, columnFormat);
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            // 
            assertTrue(e instanceof NullPointerException);
        }
    }

    /**
     * testParse08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:"abcACEL"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal06<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:"-\\###,###,###.##"<br>
     * <br>
     * ҒlF(ԕω) -:ParseException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * ł͂ȂꍇAParseException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse08() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "abcACEL";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        UTUtil.setPrivateField(stub, "decimal08", null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal08",
                        new Class[] { BigDecimal.class });
        String columnFormat = "-\\###,###,###.##";

        try {
            // eXg{
            decimalColumnParser.parse(column, stub, method, columnFormat);
            fail("ParseException܂łB");
        } catch (ParseException e) {
            // 
            assertTrue(e instanceof ParseException);
            String errorMessage = "Unparseable number: \"abcACEL\"";
            assertEquals(errorMessage, e.getMessage());
        }
    }

    /**
     * testParse09() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,E <br>
     * <br>
     * ͒lF() column:"123456"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal09<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:""<br>
     * <br>
     * ҒlF(ԕω) t:ΏۃtB[hBigDecimal.valueOf(123456)li[B<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕񂪋󕶎̏ꍇA tB[hsetter\bhݒ肳ĂꍇɁA ̕񂪐BigDecimalɕϊĊi[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse09() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "123456";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        stub.setDecimal09(null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal09",
                        new Class[] { BigDecimal.class });
        String columnFormat = "";

        // eXg{
        decimalColumnParser.parse(column, stub, method, columnFormat);

        // 
        BigDecimal result = stub.getDecimal09();
        assertNotNull(result);
        assertEquals(BigDecimal.valueOf(123456), result);
    }

    /**
     * testParse10() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() column:"-\\123,456.00"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal02<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:"-\\###,###,###.##"<br>
     * () dfMap:vfȂConcurrentHashMapCX^X<br>
     * <br>
     * ҒlF(ԕω) t:ΏۃtB[hBigDecimal.valueOf(12345600, 2)li[B<br>
     * (ԕω) DecimalFormatLocal#<init>:1Ă΂<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕ɑ΂DecimalFormatLocalLbVɑ݂ȂꍇA Ȃs邱ƂmFB<br>
     * ܂AVꂽtH[}bgp̕ɑ΂ DecimalFormatLocalLbV邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse10() throws Exception {
        // O
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "-\\123,456.00";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        stub.setDecimal10(null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal10",
                        new Class[] { BigDecimal.class });
        String columnFormat = "-\\###,###,###.##";

        ConcurrentHashMap<String, DecimalFormatLocal> dfMap = new ConcurrentHashMap<String, DecimalFormatLocal>();
        UTUtil.setPrivateField(decimalColumnParser, "dfMap", dfMap);
        dfMap.clear();

        // eXg{
        decimalColumnParser.parse(column, stub, method, columnFormat);

        // 
        BigDecimal result = stub.getDecimal10();
        assertNotNull(result);
        assertEquals(BigDecimal.valueOf(12345600, 2), result);

        assertSame(dfMap, UTUtil.getPrivateField(decimalColumnParser, "dfMap"));
        assertEquals(1, dfMap.size());
        assertTrue(dfMap.containsKey(columnFormat));
        DecimalFormatLocal dfMapValue = dfMap.get(columnFormat);
        assertNotNull(dfMapValue);
        assertEquals(columnFormat, UTUtil
                .getPrivateField(dfMapValue, "pattern"));

        assertEquals(1, VMOUTUtil.getCallCount(DecimalFormatLocal.class,
                "<init>"));
    }

    /**
     * testParse11() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() column:"-\\123,456.00"<br>
     * () t:ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal02<br>
     * - ^FBigDecimal<br>
     * - lFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * setter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂setter\bh̃CX^X<br>
     * EFpublic<br>
     * EF1(BigDecimal^)<br>
     * EFΏۃtB[hɊi[B<br>
     * () columnFormat:"-\\###,###,###.##"<br>
     * () dfMap:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"-\\###,###,###.##"<br>
     * valueFL[ɑ΂DecimalFormatLocalCX^X<br>
     * <br>
     * ҒlF(ԕω) t:ΏۃtB[hBigDecimal.valueOf(12345600, 2)li[B<br>
     * (ԕω) dfMap:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"-\\###,###,###.##"<br>
     * valueFL[ɑ΂DecimalFormatLocalCX^X<br>
     * (ԕω) DecimalFormatLocal#<init>:Ă΂Ȃ<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕ɑ΂DecimalFormatLocalLbVɑ݂ꍇA Ȃs邱ƂmFB<br>
     * ܂AtH[}bgp̕ɑ΂ DecimalFormatLocalVȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse11() throws Exception {
        DecimalColumnParser decimalColumnParser = new DecimalColumnParser();

        // O()
        String column = "-\\123,456.00";
        DecimalColumnParser_FileLineObjectStub01 stub = new DecimalColumnParser_FileLineObjectStub01();

        stub.setDecimal11(null);

        Method method = DecimalColumnParser_FileLineObjectStub01.class
                .getDeclaredMethod("setDecimal11",
                        new Class[] { BigDecimal.class });
        String columnFormat = "-\\###,###,###.##";

        ConcurrentHashMap<String, DecimalFormatLocal> dfMap = new ConcurrentHashMap<String, DecimalFormatLocal>();
        DecimalFormatLocal dfMapValue = new DecimalFormatLocal(columnFormat);
        dfMap.put(columnFormat, dfMapValue);
        UTUtil.setPrivateField(decimalColumnParser, "dfMap", dfMap);

        VMOUTUtil.initialize();

        // eXg{
        decimalColumnParser.parse(column, stub, method, columnFormat);

        // 
        BigDecimal result = stub.getDecimal11();
        assertNotNull(result);
        assertEquals(BigDecimal.valueOf(12345600, 2), result);

        assertSame(dfMap, UTUtil.getPrivateField(decimalColumnParser, "dfMap"));
        assertEquals(1, dfMap.size());
        assertTrue(dfMap.containsKey(columnFormat));
        DecimalFormatLocal formatLocal = dfMap.get(columnFormat);
        assertSame(dfMapValue, formatLocal);

        assertFalse(VMOUTUtil.isCalled(DecimalFormatLocal.class, "<init>"));
    }
}
