/*
 * $Id: CSVFileLineIteratorTest.java 5654 2007-12-04 06:34:19Z pakucn $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.NullStringConverter;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.CSVFileLineIterator} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> CSVt@Cp̃t@CANZX(f[^擾)NXB
 * <p>
 * @author cNi
 * @author O
 * @see jp.terasoluna.fw.file.dao.standard.CSVFileLineIterator
 */
public class CSVFileLineIteratorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(CSVFileLineIteratorTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public CSVFileLineIteratorTest(String name) {
        super(name);
    }

    /**
     * testCSVFileLineIterator01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:CSVFileLineIterator01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:ȉ̐ݒFileFormatAme[VX^u<br>
     * CSVFileLineIterator_Stub02<br>
     * @Ame[VFileFormatFencloseChar(͂ݕ)lȊO<br>
     * @FileFormat(encloseChar = '"')<br>
     *                         () columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     *                         vf1<br>
     *                         key:"java.lang.String"<br>
     *                         value:ColumnParserCX^X<br>
     *                         CSVFileLineIterator_ColumnParserStub01CX^X<br>
     *                         <br>
     * <br>
     *                         ҒlF(ԕω) AbstractFileLineIteratorRXgN^:1Ă΂AׂēnĂ邱ƁB<br>
     *                         (ԕω) encloseChar:lȊO(ݒ肵)<br>
     *                         (ԕω) AbstractFileLineIterator#init():2Ă΂B<br>
     * <br>
     *                         p^[<br>
     *                         RXgN^̌ďoɍs邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCSVFileLineIterator01() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub02> clazz = CSVFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);

        // OȂ

        // eXg{
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub02>(
                fileName, clazz, columnParserMap);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(AbstractFileLineIterator.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertSame(columnParserMap, arguments.get(2));
        assertEquals('"', csvFileLineIterator.getEncloseChar());
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "init"));
    }

    /**
     * testCSVFileLineIterator02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileName:CSVFileLineIterator01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:ȉ̐ݒFileFormatAme[VX^u<br>
     * CSVFileLineIterator_Stub03<br>
     * @Ame[VFileFormatFdelimiter(؂蕶)lȊO<br>
     * @FileFormat(delimiter = '"')<br>
     *                       () columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     *                       vf1<br>
     *                       key:"java.lang.String"<br>
     *                       value:ColumnParserCX^X<br>
     *                       CSVFileLineIterator_ColumnParserStub01CX^X<br>
     *                       <br>
     * <br>
     *                       ҒlF(ԕω) AbstractFileLineIteratorRXgN^:1Ă΂B<br>
     *                       ƓCX^XnB<br>
     *                       (ԕω) AbstractFileLineIterator#init():Ă΂ȂB<br>
     *                       (ԕω) Ȃ:"Delimiter can not change."̃bZ[WAIllegalStateExceptionAt@CFileExceptionB<br>
     * <br>
     *                       OB@FileFormatdelimiterɏlȊOݒ肵ꍇAO邱ƂmFB<br>
     *                       t@C͒lfileNameɈv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCSVFileLineIterator02() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub03> clazz = CSVFileLineIterator_Stub03.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);

        // OȂ

        // eXg{
        try {
            new CSVFileLineIterator<CSVFileLineIterator_Stub03>(fileName,
                    clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {

            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "<init>"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineIterator.class, "<init>", 0);
            assertEquals(fileName, arguments.get(0));
            assertEquals(clazz, arguments.get(1));
            assertSame(columnParserMap, arguments.get(2));
            assertFalse(VMOUTUtil.isCalled(VariableFileLineIterator.class,
                    "init"));
            assertEquals("Delimiter can not change.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testCSVFileLineIterator03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:CSVFileLineIterator01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:ȉ̐ݒFileFormatAme[VX^u<br>
     * CSVFileLineIterator_Stub01<br>
     * @Ame[VFileFormatFl<br>
     * @FileFormat()<br> () columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     *                   vf1<br>
     *                   key:"java.lang.String"<br>
     *                   value:ColumnParserCX^X<br>
     *                   CSVFileLineIterator_ColumnParserStub01CX^X<br>
     *                   <br>
     * <br>
     *                   ҒlF(ԕω) AbstractFileLineIteratorRXgN^:1Ă΂AׂēnĂ邱ƁB<br>
     *                   (ԕω) encloseChar:lݒ肳Ă邱ƁB<br>
     * <br>
     *                   clazzɐݒ肳ꂽNX͂ݕA؂蕶ftHĝ܂܂̏ꍇ́ARXgN^Ăяoɍs邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testCSVFileLineIterator03() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub01> clazz = CSVFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);

        // OȂ

        // eXg{
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(AbstractFileLineIterator.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertSame(columnParserMap, arguments.get(2));
        assertEquals(Character.MIN_VALUE, csvFileLineIterator.getEncloseChar());
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "init"));
    }

    /**
     * ُn<br>
     * t@CsIuWFNgInputFileColumnAme[V
     * @throws Exception ̃\bhŔO
     */
    public void testCSVFileLineIterator04() throws Exception {
        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<FileLineObject_Empty> clazz = FileLineObject_Empty.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);

        // eXg{
        try {
            new CSVFileLineIterator<FileLineObject_Empty>(fileName, clazz,
                    columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("InputFileColumn is not found.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testSeparateColumns01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() fileLineString:null<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * <br>
     * ҒlF(߂l) String[]:new String[0]<br>
     * <br>
     * p^[B<br>
     * null͋󕶎ƂēnꂽꍇAvf0̔zԋp邱ƂmFB<br>
     * ʏ̏ł̕ԋpl߂邱Ƃ͂ȂB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub01> clazz = CSVFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = null;

        // O
        UTUtil.setPrivateField(csvFileLineIterator, "columnEncloseChar",
                new char[] {});

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(0, result.length);

        // ԕωȂ
    }

    /**
     * testSeparateColumns02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileLineString:"aaa"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * <br>
     * ҒlF(߂l) String[]:{"aaa"}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * vf1̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub01> clazz = CSVFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa";

        // O(CX^XŐݒ肳)

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(1, result.length);
        assertEquals(fileLineString, result[0]);
    }

    /**
     * testSeparateColumns03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileLineString:"aaa,bbb,ccc"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * <br>
     * ҒlF(߂l) String[]:{"aaa","bbb","ccc"}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * vf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub01> clazz = CSVFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa,bbb,ccc";

        // O(CX^XŐݒ肳)

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("bbb", result[1]);
        assertEquals("ccc", result[2]);

        // ԕωȂ
    }

    /**
     * testSeparateColumns04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"\"aaa\""<br>
     * () this.encloseChar:\"'<br>
     * () this.fields[]:zvf0<br>
     * <br>
     * ҒlF(߂l) String[]:{"aaa"}<br>
     * <br>
     * p^[B(͂ݕꍇ̏)<br>
     * ͂ݕGXP[vAvf1̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub02> clazz = CSVFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub02>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aaa\"";

        // O
        UTUtil.setPrivateField(csvFileLineIterator, "columnEncloseChar",
                new char[] { '\"', '\"' });

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(1, result.length);
        assertEquals("aaa", result[0]);
    }

    /**
     * testSeparateColumns05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileLineString:"\"aaa\""<br>
     * () this.encloseChar:\"<br>
     * () this.fields[]:zvf1<br>
     * () this.field[]̃Ame[VInputFileColumn:@InputFileColumn(columnIndex = 0)<br>
     * private String column1 = null;<br>
     * <br>
     * ҒlF(߂l) String[]:{"aaa"}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * vf1̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub04> clazz = CSVFileLineIterator_Stub04.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub04>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aaa\"";

        // O(CX^XŐݒ肳)

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(1, result.length);
        assertEquals("aaa", result[0]);
    }

    /**
     * testSeparateColumns06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"\"aaa\",\"bbb\",\"ccc\""<br>
     * () this.encloseChar:\"'<br>
     * () this.fields[]:zvf3<br>
     * () this.field[]̃Ame[VInputFileColumn:@InputFileColumn(columnIndex = 0)<br>
     * private String column1 = null;<br>
     * <br>
     * @InputFileColumn(columnIndex = 1)<br>
     *                              private String column2 = null;<br>
     * <br>
     * @InputFileColumn(columnIndex = 2)<br>
     *                              private String column3 = null;<br>
     * <br>
     *                              ҒlF(߂l) String[]:{"aaa","bbb","ccc"}<br>
     * <br>
     *                              p^[B(͂ݕꍇ̏B)<br>
     *                              ͂ݕGXP[vAvf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub05> clazz = CSVFileLineIterator_Stub05.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub05>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aaa\",\"bbb\",\"ccc\"";

        // O(CX^XŐݒ肳)

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("bbb", result[1]);
        assertEquals("ccc", result[2]);

        // ԕωȂ
    }

    /**
     * testSeparateColumns07() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"\"aa\ra\",\"bb,b\",\"cc\"\"c\""<br>
     * ͂ݕA<br>
     * s؂蕶܂܂A<br>
     * ؂蕶܂܂A<br>
     * ͂ݕ܂܂ꍇ<br>
     * () this.encloseChar:\"'<br>
     * () this.fields[]:zvf3<br>
     * () this.field[]̃Ame[VInputFileColumn:@InputFileColumn(columnIndex = 0)<br>
     * private String column1 = null;<br>
     * <br>
     * @InputFileColumn(columnIndex = 1)<br>
     *                              private String column2 = null;<br>
     * <br>
     * @InputFileColumn(columnIndex = 2)<br>
     *                              private String column3 = null;<br>
     * <br>
     *                              ҒlF(߂l) String[]:{"aa\ra","bb,b","cc\"c"}<br>
     * <br>
     *                              p^[B(͂ݕꍇ̏B)<br>
     *                              vf3̔zԋp邱ƂmFB<br>
     *                              ؂蕶A͂ݕꂼGXP[v邱ƂmFBs؂蕶̓GXP[vȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub05> clazz = CSVFileLineIterator_Stub05.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub05>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aa\ra\",\"bb,b\",\"cc\"\"c\"";

        // O(CX^XŐݒ肳)

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aa\ra", result[0]);
        assertEquals("bb,b", result[1]);
        assertEquals("cc\"c", result[2]);

        // ԕωȂ
    }

    /**
     * testSeparateColumns08() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"aaa,bbb,ccc"<br>
     * () this.encloseChar:\"'<br>
     * <br>
     * ҒlF(߂l) String[]:{"aaa","bbb","ccc"}<br>
     * <br>
     * p^[B(encloseCharݒ肳ĂA͂ݕȂꍇ̏)<br>
     * vf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns08() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub02> clazz = CSVFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub02>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa,bbb,ccc";

        // O
        UTUtil.setPrivateField(csvFileLineIterator, "columnEncloseChar",
                new char[] { Character.MIN_VALUE, Character.MIN_VALUE,
                        Character.MIN_VALUE });

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("bbb", result[1]);
        assertEquals("ccc", result[2]);

        // ԕωȂ
    }

    /**
     * testSeparateColumns09() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() fileLineString:,,,,<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * <br>
     * ҒlF(߂l) String[]:{"", "", "", "", ""}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * 󔒕T̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns09() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub01> clazz = CSVFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = ",,,,";

        // O(CX^XŐݒ肳)

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(5, result.length);
        assertEquals("", result[0]);
        assertEquals("", result[1]);
        assertEquals("", result[2]);
        assertEquals("", result[3]);
        assertEquals("", result[4]);

        // ԕωȂ
    }

    /**
     * testSeparateColumns10() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() fileLineString:""(󕶎)<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * <br>
     * ҒlF(߂l) String[]:new String[0]<br>
     * <br>
     * 󕶎ƂēnꂽꍇAvf0̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns10() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub01> clazz = CSVFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "";

        // O(CX^XŐݒ肳)

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(0, result.length);

        // ԕωȂ
    }

    /**
     * testSeparateColumns11() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"\"aa\"bb\""<br>
     * () this.encloseChar:\"'<br>
     * <br>
     * ҒlF(߂l) String[]:{"aabb\""}<br>
     * <br>
     * ͂ݕݒ肳ĂAGXP[vĂȂ͂ݕf[^ƂĊi[Ăꍇ́A\ʃf[^ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns11() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub02> clazz = CSVFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub02>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aa\"bb\"";

        // O
        UTUtil.setPrivateField(csvFileLineIterator, "columnEncloseChar",
                new char[] { '\"', '\"', '\"' });

        // eXg{
        String[] result = csvFileLineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(1, result.length);
        assertEquals("aabb\"", result[0]);

        // ԕωȂ
    }

    /**
     * testGetDelimiter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.delimiter:','(Œ)<br>
     * <br>
     * ҒlF(߂l) char:','(Œ)<br>
     * <br>
     * delimitergetterɓ삷邱ƂmFB<br>
     * KAJ}ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetDelimiter01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub01> clazz = CSVFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "buildLineReader", null);

        // Ȃ

        // O(CX^XŐݒ肳)

        // eXg{
        char result = csvFileLineIterator.getDelimiter();

        // ԋpl̊mF
        assertEquals(',', result);

        // ԕωȂ
    }

    /**
     * testGetEncloseChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.encloseChar:not null<br>
     * '"'<br>
     * <br>
     * ҒlF(߂l) char:not null<br>
     * '"'<br>
     * <br>
     * encloseChargetterɓ삷邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetEncloseChar01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileLineIterator_Stub02> clazz = CSVFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        CSVFileLineIterator csvFileLineIterator = new CSVFileLineIterator<CSVFileLineIterator_Stub02>(
                fileName, clazz, columnParserMap);

        // Ȃ

        // O(CX^XŐݒ肳)

        // eXg{
        char result = csvFileLineIterator.getEncloseChar();

        // ԋpl̊mF
        assertEquals('"', result);

        // ԕωȂ
    }

    /**
     * n<br>
     * InputFileColumncolumnEncloseCharɂāAX̃JɈ͂ݕݒ
     * @throws Exception
     */
    public void testNext01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        CSVFileLineIterator<CSVFileLine_Stub01> fileLineIterator = new CSVFileLineIterator<CSVFileLine_Stub01>(
                fileName, CSVFileLine_Stub01.class, columnParserMap);

        // eXg{
        CSVFileLine_Stub01 result1 = fileLineIterator.next();
        CSVFileLine_Stub01 result2 = fileLineIterator.next();
        CSVFileLine_Stub01 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("1", result1.getColumn1());
        assertEquals("22", result1.getColumn2());
        assertEquals("333", result1.getColumn3());
        assertEquals("4444", result1.getColumn4());

        assertEquals("5", result2.getColumn1());
        assertEquals("66", result2.getColumn2());
        assertEquals("777", result2.getColumn3());
        assertEquals("8888", result2.getColumn4());

        assertEquals("9", result3.getColumn1());
        assertEquals("AA", result3.getColumn2());
        assertEquals("BBB", result3.getColumn3());
        assertEquals("CCCC", result3.getColumn4());
    }

    /**
     * n<br>
     * FileFormatencloseCharInputFileColumncolumnEncloseCharɂāAJɈ͂ݕݒ
     * @throws Exception
     */
    public void testNext02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        CSVFileLineIterator<CSVFileLine_Stub02> fileLineIterator = new CSVFileLineIterator<CSVFileLine_Stub02>(
                fileName, CSVFileLine_Stub02.class, columnParserMap);

        // eXg{
        CSVFileLine_Stub02 result1 = fileLineIterator.next();
        CSVFileLine_Stub02 result2 = fileLineIterator.next();
        CSVFileLine_Stub02 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("1", result1.getColumn1());
        assertEquals("22", result1.getColumn2());
        assertEquals("333", result1.getColumn3());
        assertEquals("4444", result1.getColumn4());

        assertEquals("5", result2.getColumn1());
        assertEquals("66", result2.getColumn2());
        assertEquals("777", result2.getColumn3());
        assertEquals("8888", result2.getColumn4());

        assertEquals("9", result3.getColumn1());
        assertEquals("AA", result3.getColumn2());
        assertEquals("BBB", result3.getColumn3());
        assertEquals("CCCC", result3.getColumn4());
    }

    /**
     * n<br>
     * LbVĂAme[V̏𗘗pĂ鎖mFB<br>
     * @throws Exception
     */
    public void testNext03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        CSVFileLineIterator<CSVFileLine_Stub03> fileLineIterator = new CSVFileLineIterator<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnParserMap);

        // t@CsIuWFNgɐݒ肵ĂlSď㏑
        // ȉ̐ݒ肪Kp΁At@CsIuWFNg
        // Ame[VɃANZXĂȂƂɂȂB
        char[] charArray = new char[] { 0, 0, 0, 0 };
        // O
        UTUtil.setPrivateField(fileLineIterator, "lineFeedChar", "\r\n");
        UTUtil.setPrivateField(fileLineIterator, "delimiter", '_');
        UTUtil.setPrivateField(fileLineIterator, "inputFileColumns", null);
        UTUtil.setPrivateField(fileLineIterator, "columnFormats", new String[] {
                "", "", "", "" });
        UTUtil.setPrivateField(fileLineIterator, "columnBytes", new int[] { -1,
                -1, -1, -1 });
        UTUtil.setPrivateField(fileLineIterator, "totalBytes", 0);
        UTUtil.setPrivateField(fileLineIterator, "trimChars", charArray);
        UTUtil
                .setPrivateField(fileLineIterator, "columnEncloseChar",
                        charArray);
        UTUtil.setPrivateField(fileLineIterator, "stringConverters",
                new NullStringConverter[] { new NullStringConverter(),
                        new NullStringConverter(), new NullStringConverter(),
                        new NullStringConverter() });
        LineReader reader = (LineReader) UTUtil.getPrivateField(
                fileLineIterator, "lineReader");
        UTUtil.setPrivateField(reader, "lineFeedChar", "\r\n");

        // eXg{
        CSVFileLine_Stub03 result1 = fileLineIterator.next();
        CSVFileLine_Stub03 result2 = fileLineIterator.next();
        CSVFileLine_Stub03 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("\"1\"", result1.getColumn1());
        assertEquals("22", result1.getColumn2());
        assertEquals("333", result1.getColumn3());
        assertEquals("|4444|", result1.getColumn4());

        assertEquals("\"5\"", result2.getColumn1());
        assertEquals("66", result2.getColumn2());
        assertEquals("777", result2.getColumn3());
        assertEquals("|8888|", result2.getColumn4());

        assertEquals("\"9\"", result3.getColumn1());
        assertEquals("AA", result3.getColumn2());
        assertEquals("BBB", result3.getColumn3());
        assertEquals("|CCCC|", result3.getColumn4());
    }
}
