package jp.terasoluna.fw.file.dao.standard;

import java.util.Map;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineWriter;
import jp.terasoluna.fw.file.dao.standard.ColumnFormatter;

/**
 * AbstractFileLineWriterImplNXB<br>
 * <br>
 * u؂蕶vƁu͂ݕvݒłB<br>
 * RXgN^init()sĂȂ߁ARXgN^ȊO̎ł<br>
 * CX^XAKinit()sĂ痘p邱ƁB
 * @author O
 * @param <T> t@CsIuWFNg
 */
public class AbstractFileLineWriterImpl01<T> extends AbstractFileLineWriter<T> {

    /**
     * ؂蕶
     */
    private char delimiter = Character.MIN_VALUE;

    /**
     * ͂ݕ
     */
    private char encloseChar = Character.MIN_VALUE;

    /**
     * RXgN^B
     * @param fileName t@C
     * @param clazz p[^NX
     * @param columnFormatterMap eLXg擾[
     */
    public AbstractFileLineWriterImpl01(String fileName, Class<T> clazz,
            Map<String, ColumnFormatter> columnFormatterMap) {
        super(fileName, clazz, columnFormatterMap);

        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        this.delimiter = fileFormat.delimiter();
        this.encloseChar = fileFormat.encloseChar();
    }

    /**
     * t@CsIuWFNgɃAme[Vݒ肳Ă鎖`FbN邩ǂԂB
     * @return `FbNsꍇtrueB
     */
    @Override
    protected boolean isCheckColumnAnnotationCount() {
        return false;
    }

    /**
     * delimiter擾B
     * @return delimiter
     */
    public char getDelimiter() {
        return delimiter;
    }

    /**
     * delimiterݒ肷B
     * @param delimiter delimiter
     */
    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    /**
     * encloseChar擾B
     * @return encloseChar
     */
    public char getEncloseChar() {
        return encloseChar;
    }

    /**
     * encloseCharݒ肷B
     * @param encloseChar encloseChar
     */
    public void setEncloseChar(char encloseChar) {
        this.encloseChar = encloseChar;
    }
}
