/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockQueue;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class MockQueueBrowser
implements QueueBrowser {
    private MockConnection connection;
    private MockQueue queue;
    private boolean closed;
    private String messageSelector;

    public MockQueueBrowser(MockConnection mockConnection, MockQueue mockQueue) {
        this(mockConnection, mockQueue, null);
    }

    public MockQueueBrowser(MockConnection mockConnection, MockQueue mockQueue, String string) {
        this.connection = mockConnection;
        this.queue = mockQueue;
        this.closed = false;
        this.messageSelector = string;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Queue getQueue() throws JMSException {
        this.connection.throwJMSException();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.connection.throwJMSException();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.connection.throwJMSException();
        if (this.isClosed()) {
            throw new JMSException("Browser is closed");
        }
        return new Vector(this.queue.getCurrentMessageList()).elements();
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        this.closed = true;
    }
}

