/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.exception;

import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.batch.util.MessageUtil;

/**
 * ob`OB<br>
 * <br>
 * ob`sɔOێB
 */
public class BatchException extends RuntimeException {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 7677068837918514733L;

    /**
     * bZ[WID
     */
    private String messageId = null;

    /**
     * Ô߂̃p[^
     */
    private Object[] params = null;

    /**
     * BatchException𐶐
     */
    public BatchException() {
        super();
    }

    /**
     * BatchException𐶐
     * @param message
     */
    public BatchException(String message) {
        super(message);
    }

    /**
     * BatchException𐶐
     * @param message
     * @param cause
     */
    public BatchException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * BatchException𐶐
     * @param cause
     */
    public BatchException(Throwable cause) {
        super(cause);
    }

    /**
     * BatchException𐶐
     * @param messageId G[R[h
     * @param message G[bZ[W
     */
    public BatchException(String messageId, String message) {
        super(message);

        this.messageId = messageId;
    }

    /**
     * BatchException𐶐
     * @param messageId bZ[WID
     * @param message G[bZ[W
     * @param cause ƂȂO
     */
    public BatchException(String messageId, String message, Throwable cause) {
        super(message, cause);

        this.messageId = messageId;
    }

    /**
     * BatchException𐶐
     * @param messageId bZ[WID
     * @param message G[bZ[W
     * @param params Ô߂̃p[^
     */
    public BatchException(String messageId, String message, Object... params) {
        super(message);

        this.messageId = messageId;
        this.params = params;
    }

    /**
     * BatchException𐶐
     * @param messageId bZ[WID
     * @param message G[bZ[W
     * @param cause ƂȂO
     * @param params Ô߂̃p[^
     */
    public BatchException(String messageId, String message, Throwable cause,
            Object... params) {
        super(message, cause);

        this.messageId = messageId;
        this.params = params;
    }

    /**
     * BatchExceptioñt@Ng\bh
     * @param messageId bZ[WID
     * @return ̓eō쐬ꂽBatchExceptionCX^X
     */
    public static BatchException createException(String messageId) {
        return new BatchException(messageId, MessageUtil.getMessage(messageId));
    }

    /**
     * BatchExceptioñt@Ng\bh
     * @param messageId bZ[WID
     * @param params Ô߂̃p[^
     * @return ̓eō쐬ꂽBatchExceptionCX^X
     */
    public static BatchException createException(String messageId,
            Object... params) {
        return new BatchException(messageId, MessageUtil.getMessage(messageId,
                params), params);
    }

    /**
     * BatchExceptioñt@Ng\bh
     * @param messageId bZ[WID
     * @param cause ƂȂO
     * @return ̓eō쐬ꂽBatchExceptionCX^X
     */
    public static BatchException createException(String messageId,
            Throwable cause) {
        return new BatchException(messageId, MessageUtil.getMessage(messageId),
                cause);
    }

    /**
     * BatchExceptioñt@Ng\bh
     * @param messageId bZ[WID
     * @param cause ƂȂO
     * @param params Ô߂̃p[^
     * @return ̓eō쐬ꂽBatchExceptionCX^X
     */
    public static BatchException createException(String messageId,
            Throwable cause, Object... params) {
        return new BatchException(messageId, MessageUtil.getMessage(messageId,
                params), cause, params);
    }

    /**
     * Oo͗p쐬
     * @return Oo͗p
     */
    public String getLogMessage() {

        StringBuilder logMsg = new StringBuilder();

        logMsg.append(BatchUtil.cat("[", messageId, "] ", getMessage()));

        if (params != null) {
            logMsg.append(" (\n");
            for (Object option : params) {
                logMsg.append(BatchUtil.cat("\t", option, "\n"));
            }
            logMsg.append(")");
        }

        return logMsg.toString();
    }

    /**
     * bZ[WID擾.
     * @return the messageId
     */
    public String getMessageId() {
        return messageId;
    }
}
