/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.fw.logger;

import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.message.MessageManager;

/**
 * ėpK[NXB<br>
 * <p>
 * CommonsLogging̃K[bvK[łB<br>
 * ObZ[WvpeBt@CŊǗAOo̓\bḧɃOIDnƂŁAvpeBt@C̃OIDɑ΂郁bZ[Wo͂ł܂B
 * </p>
 * <h3>K[擾</h3>
 * <p>
 * K[̎擾͑̃K[CuƂقړłB
 * </p>
 * 
 * <pre>
 * TLogger logger = TLogger.getLogger(XX.class);
 * ܂
 * TLogger logger = TLogger.getLogger("JeS");
 * </pre>
 * 
 * <h3>Oo</h3>
 * <p>
 * ̂悤ȃObZ[WvpeBt@Cꍇ
 * </p>
 * 
 * <pre>
 * DEB001=debug message
 * ERR001=error message
 * </pre>
 * <p>
 * ̃bZ[Wo͂ɂ
 * </p>
 * 
 * <pre>
 * logger.debug(&quot;DEB001&quot;);
 * logger.error(&quot;ERR001&quot;);
 * </pre>
 * <p>
 * ̂悤ɃOxɉ\bhɃOIDnĎs܂B o̓bZ[W
 * </p>
 * 
 * <pre>
 * [DEB001] debug message
 * [ERR001] error message
 * </pre>
 * <p>
 * ƂȂ܂BbZ[W̑O[OID]ŕt܂B<br>
 * 
 * Ox
 * <ul>
 * <li>FATAL</li>
 * <li>ERROR</li>
 * <li>WARN</li>
 * <li>INFO</li>
 * <li>DEBUG</li>
 * <li>TRACE</li>
 * </ul>
 * ܂B<code>log(String logId)</code>\bhgpƁAOID̈ꕶڂăOx𔻒f܂B
 * </p>
 * <h3>p[^u</h3>
 * <p>
 * o͂郍ObZ[W쐬ۂɁA{@link java.text.MessageFormat}
 * gpĂ܂Bup[^ϒzœnƂł܂B
 * </p>
 * 
 * <pre>
 * DEB002={0} is {1}.
 * </pre>
 * <p>
 * Ƃ`ꍇA
 * </p>
 * 
 * <pre>
 * logger.debug(&quot;DEB002&quot;, &quot;hoge&quot;, &quot;foo&quot;);
 * </pre>
 * <p>
 * sƏo̓bZ[W
 * </p>
 * 
 * <pre>
 * [DEB002] hoge is foo.
 * </pre>
 * <p>
 * ƂȂ܂B <br>
 * ŃbZ[W쐬ۂɃOx̃`FbNsĂ̂ŁA
 * </p>
 * 
 * <pre>
 * if (logger.isDebugEnabled()) {
 *     logger.debug(&quot;DEB002&quot;, &quot;hoge&quot;, &quot;foo&quot;);
 * }
 * </pre>
 * <p>
 * ƂifKv܂B(A
 * p[^쐬ۂɃ\bhĂяoĂꍇifĖIɃOx`FbNsĂB)
 * </p>
 * <h3>bZ[WvpeBt@CɂȂbZ[W̏o</h3>
 * <p>
 * bZ[WvpeBt@C̃OIDnɁAڃbZ[Wn@܂B1false
 * ݒ肵A2ɃbZ[W{𒼐ڋLqł܂B3ȍ~͒up[^łB̏ꍇ͓ROID͏o͂܂B
 * </p>
 * 
 * <pre>
 * logger.warn(false, &quot;warn!!&quot;);
 * logger.info(false, &quot;Hello {0}!&quot;, &quot;World&quot;);
 * </pre>
 * <p>
 * o̓bZ[W
 * </p>
 * 
 * <pre>
 * warn!!
 * Hello World!
 * </pre>
 * <p>
 * ƂȂ܂B
 * </p>
 * <h3>ݒt@C</h3>
 * <p>
 * NXpX<code>META-INF</code>fBNg<code>terasoluna-logger.properties</code>
 * 쐬ĂB
 * </p>
 * <h4>bZ[WvpeBt@C̃x[Xl[ݒ</h4>
 * <p>
 * <code>terasoluna-logger.properties</code><code>message.basename</code>
 * L[ɃbZ[WvpeBt@C̃x[Xl[NXpX(FQCN)Őݒ肵ĂB<br>
 * {@link java.util.ResourceBundle}œǂݍނ̂ŁAۉɑΉĂ܂B
 * </p>
 * 
 * <pre>
 * message.basename = hoge
 * </pre>
 * <p>
 * ƏƃNXpXhoge.propertiesǂݍ܂܂B
 * </p>
 * 
 * <pre>
 * message.basename=hoge,foo,bar
 * </pre>
 * <p>
 * ̂悤ɔpJ}؂Őݒ肷ƑSĂǂݍ݂܂B<br>
 * <code>META-INF/terasoluna-logger.properies</code>
 * <code>message.basename</code>̓W[ɐݒł܂B K[͑SẴW[(jar)A
 * <code>message.basename</code>̒l}[WăbZ[W擾܂B <br>
 * ɂAW[ɃObZ[WǗ邱Ƃł܂B
 * </p>
 * <h4>o̓OIDtH[}bgݒ</h4>
 * <p>
 * Oo͎Ɏŕt郍OID̃tH[}bgݒł܂B<br>
 * <code>message.id.format</code>L[
 * {@link java.lang.String#format(String, Object...)}
 * ̃tH[}bg`Őݒ肵ĂBOIDƂēn܂B <br>
 * ݒ肵Ȃꍇ́u[%s]vftHglƂĎgp܂B <br>
 * </p>
 * 
 * <pre>
 * message.id.format=[%-8s]
 * </pre>
 * <p>
 * ̂悤ɐݒ肷ƁAW[ԂňقȂ钷̃OID񂹂őďo͂ł܂B <br>
 * ̐ݒl̓W[ɊǗ邱Ƃ͂ł܂B <br>
 * NX[_̓ǂݍݗDxԍ<code>terasoluna-logger.properties</code>̒lf܂B
 * (ʏAAv̐ݒƂȂ܂B)
 * </p>
 */
public class TLogger implements Log {
    /**
     * K[́B
     */
    private final Log logger;

    /**
     * K[ݒt@CB
     */
    private static final String CONFIG_FILENAME = "META-INF/terasoluna-logger.properties";
    /**
     * bZ[WǗB
     */
    private static final MessageManager MESSAGE_MANAGER = new MessageManager(
            CONFIG_FILENAME);

    /**
     * P[ێXbh[JB
     */
    private static final ThreadLocal<Locale> locale = new ThreadLocal<Locale>();

    /**
     * RXgN^B
     * 
     * @param clazz JeSƂȂNX
     */
    protected TLogger(Class<?> clazz) {
        logger = LogFactory.getLog(clazz);
    }

    /**
     * RXgN^B
     * 
     * @param name JeS
     */
    protected TLogger(String name) {
        logger = LogFactory.getLog(name);
    }

    /**
     * P[ݒ肵܂B
     * 
     * @param locale P[
     */
    public static void setLocale(Locale locale) {
        TLogger.locale.set(locale);
    }

    /**
     * ObZ[W쐬܂B
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param args up[^
     * @return ObZ[W
     * @see {@link MessageManager#getMessage(boolean, String, Locale, Object...)}
     */
    protected String createMessage(boolean resource, String logIdOrPattern,
            Object... args) {
        String message = MESSAGE_MANAGER.getMessage(resource, logIdOrPattern,
                locale.get(), args);
        return message;
    }

    /**
     * K[擾܂B
     * 
     * @param clazz JeSƂȂNX
     * @return K[
     */
    public static TLogger getLogger(Class<?> clazz) {
        return new TLogger(clazz);
    }

    /**
     * K[擾܂B
     * 
     * @param name JeS
     * @return K[
     */
    public static TLogger getLogger(String name) {
        return new TLogger(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.commons.logging.Log#isFatalEnabled()
     */
    public boolean isFatalEnabled() {
        return logger.isFatalEnabled();
    }

    /**
     * FATALOo͂܂B
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param args up[^
     */
    public void fatal(boolean resource, String logIdOrPattern, Object... args) {
        if (isFatalEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.fatal(message);
        }
    }

    /**
     * FATALOo͂܂B
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param throwable NO
     * @param args up[^
     */
    public void fatal(boolean resource, String logIdOrPattern,
            Throwable throwable, Object... args) {
        if (isFatalEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.fatal(message, throwable);
        }
    }

    /**
     * FATALOo͂܂B
     * 
     * @param logId OID
     * @param args up[^
     */
    public void fatal(String logId, Object... args) {
        fatal(true, logId, args);
    }

    /**
     * FATALOo͂܂B
     * 
     * @param logId OID
     * @param throwable NO
     * @param args up[^
     */
    public void fatal(String logId, Throwable throwable, Object... args) {
        fatal(true, logId, throwable, args);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.commons.logging.Log#isErrorEnabled()
     */
    public boolean isErrorEnabled() {
        return logger.isErrorEnabled();
    }

    /**
     * ERROROo͂܂B<br>
     * <p>
     * K[̃OxERROR荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param args up[^
     */
    public void error(boolean resource, String logIdOrPattern, Object... args) {
        if (isErrorEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.error(message);
        }
    }

    /**
     * ERROROo͂܂B<br>
     * <p>
     * K[̃OxERROR荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param throwable NO
     * @param args up[^
     */
    public void error(boolean resource, String logIdOrPattern,
            Throwable throwable, Object... args) {
        if (isErrorEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.error(message, throwable);
        }
    }

    /**
     * ERROROo͂܂B<br>
     * <p>
     * K[̃OxERROR荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param args up[^
     */
    public void error(String logId, Object... args) {
        error(true, logId, args);
    }

    /**
     * ERROROo͂܂B<br>
     * <p>
     * K[̃OxERROR荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     * @param args up[^
     */
    public void error(String logId, Throwable throwable, Object... args) {
        error(true, logId, throwable, args);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.commons.logging.Log#isWarnEnabled()
     */
    public boolean isWarnEnabled() {
        return logger.isWarnEnabled();
    }

    /**
     * WARNOo͂܂B<br>
     * <p>
     * K[̃OxWARN荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param args up[^
     */
    public void warn(boolean resource, String logIdOrPattern, Object... args) {
        if (isWarnEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.warn(message);
        }
    }

    /**
     * WARNOo͂܂B<br>
     * <p>
     * K[̃OxWARN荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param throwable NO
     * @param args up[^
     */
    public void warn(boolean resource, String logIdOrPattern,
            Throwable throwable, Object... args) {
        if (isWarnEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.warn(message, throwable);
        }
    }

    /**
     * WARNOo͂܂B<br>
     * <p>
     * K[̃OxWARN荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId @OID
     * @param args up[^
     */
    public void warn(String logId, Object... args) {
        warn(true, logId, args);
    }

    /**
     * WARNOo͂܂B<br>
     * <p>
     * K[̃OxWARN荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     * @param args up[^
     */
    public void warn(String logId, Throwable throwable, Object... args) {
        warn(true, logId, throwable, args);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.commons.logging.Log#isInfoEnabled()
     */
    public boolean isInfoEnabled() {
        return logger.isInfoEnabled();
    }

    /**
     * INFOOo͂܂B<br>
     * <p>
     * K[̃OxINFO荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param args up[^
     */
    public void info(boolean resource, String logIdOrPattern, Object... args) {
        if (isInfoEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.info(message);
        }
    }

    /**
     * INFOOo͂܂B<br>
     * <p>
     * K[̃OxINFO荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param throwable NO
     * @param args up[^
     */
    public void info(boolean resource, String logIdOrPattern,
            Throwable throwable, Object... args) {
        if (isInfoEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.info(message, throwable);
        }
    }

    /**
     * INFOOo͂܂B<br>
     * <p>
     * K[̃OxINFO荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param args up[^
     */
    public void info(String logId, Object... args) {
        info(true, logId, args);
    }

    /**
     * INFOOo͂܂B<br>
     * <p>
     * K[̃OxINFO荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     * @param args up[^
     */
    public void info(String logId, Throwable throwable, Object... args) {
        info(true, logId, throwable, args);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.commons.logging.Log#isDebugEnabled()
     */
    public boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    /**
     * DEBUGOo͂܂B<br>
     * <p>
     * K[̃OxDEBUG荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param args up[^
     */
    public void debug(boolean resource, String logIdOrPattern, Object... args) {
        if (isDebugEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.debug(message);
        }
    }

    /**
     * DEBUGOo͂܂B<br>
     * <p>
     * K[̃OxDEBUG荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param throwable NO
     * @param args up[^
     */
    public void debug(boolean resource, String logIdOrPattern,
            Throwable throwable, Object... args) {
        if (isDebugEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.debug(message, throwable);
        }
    }

    /**
     * DEBUGOo͂܂B<br>
     * <p>
     * K[̃OxDEBUG荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param args up[^
     */
    public void debug(String logId, Object... args) {
        debug(true, logId, args);
    }

    /**
     * DEBUGOo͂܂B<br>
     * <p>
     * K[̃OxDEBUG荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     * @param args up[^
     */
    public void debug(String logId, Throwable throwable, Object... args) {
        debug(true, logId, throwable, args);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.commons.logging.Log#isTraceEnabled()
     */
    public boolean isTraceEnabled() {
        return logger.isTraceEnabled();
    }

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * K[̃OxTRACE荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param args up[^
     */
    public void trace(boolean resource, String logIdOrPattern, Object... args) {
        if (isTraceEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.trace(message);
        }
    }

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * K[̃OxTRACE荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param resource \[XL
     * @param logIdOrPattern OIDi\[XL̏ꍇj / ObZ[Wp^[(\[X̏ꍇ)
     * @param throwable NO
     * @param args up[^
     */
    public void trace(boolean resource, String logIdOrPattern,
            Throwable throwable, Object... args) {
        if (isTraceEnabled()) {
            String message = createMessage(resource, logIdOrPattern, args);
            logger.trace(message, throwable);
        }
    }

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * K[̃OxTRACE荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param args up[^
     */
    public void trace(String logId, Object... args) {
        trace(true, logId, args);
    }

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * K[̃OxTRACE荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     * @param args up[^
     */
    public void trace(String logId, Throwable throwable, Object... args) {
        trace(true, logId, throwable, args);
    }

    /**
     * OID̈ȉ̋Kɍx̃Oo͂܂B<br>
     * <p>
     * OID̐擪
     * <ul>
     * <li>T...TRACEO</li>
     * <li>D...DEBUGO</li>
     * <li>I...INFOO</li>
     * <li>W...WARNO</li>
     * <li>E...ERRORO</li>
     * <li>F...FATALO</li>
     * <li>ȊO...DEBUGO</li> </u>
     * </p>
     * 
     * @param logId OID
     * @param args up[^
     */
    public void log(String logId, Object... args) {
        if (logId != null && logId.length() > 0) {
            char messageType = logId.charAt(0);
            switch (messageType) {
            case 'T':
                trace(logId, args);
                break;
            case 'D':
                debug(logId, args);
                break;
            case 'I':
                info(logId, args);
                break;
            case 'W':
                warn(logId, args);
                break;
            case 'E':
                error(logId, args);
                break;
            case 'F':
                fatal(logId, args);
                break;
            default:
                debug(logId, args);
                break;
            }
        }
    }

    /**
     * OID̈ȉ̋Kɍx̃Oo͂܂B<br>
     * <p>
     * OID̐擪
     * <ul>
     * <li>T...TRACEO</li>
     * <li>D...DEBUGO</li>
     * <li>I...INFOO</li>
     * <li>W...WARNO</li>
     * <li>E...ERRORO</li>
     * <li>F...FATALO</li>
     * <li>ȊO...DEBUGO</li> </u>
     * </p>
     * 
     * @param logId OID
     * @param args up[^
     */
    public void log(String logId, Throwable throwable, Object... args) {
        if (logId != null && logId.length() > 0) {
            char messageType = logId.charAt(0);
            switch (messageType) {
            case 'T':
                trace(logId, throwable, args);
                break;
            case 'D':
                debug(logId, throwable, args);
                break;
            case 'I':
                info(logId, throwable, args);
                break;
            case 'W':
                warn(logId, throwable, args);
                break;
            case 'E':
                error(logId, throwable, args);
                break;
            case 'F':
                fatal(logId, throwable, args);
                break;
            default:
                debug(logId, throwable, args);
                break;
            }
        }
    }

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #trace(String, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * 
     */
    @Deprecated
    public void trace(Object message) {
        trace(false, "{0}", message);
    }

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #trace(String, Throwable, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * @param t NO
     * 
     */
    @Deprecated
    public void trace(Object message, Throwable t) {
        trace(false, "{0}", t, message);
    }

    /**
     * DEBUGOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #debug(String, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * 
     */
    @Deprecated
    public void debug(Object message) {
        debug(false, "{0}", message);
    }

    /**
     * DEBUGOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #debug(String, Throwable, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * @param t NO
     * 
     */
    @Deprecated
    public void debug(Object message, Throwable t) {
        debug(false, "{0}", t, message);
    }

    /**
     * INFOOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #info(String, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * 
     */
    @Deprecated
    public void info(Object message) {
        info(false, "{0}", message);
    }

    /**
     * INFOOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #info(String, Throwable, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * @param t NO
     * 
     */
    @Deprecated
    public void info(Object message, Throwable t) {
        info(false, "{0}", t, message);
    }

    /**
     * WARNOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #warn(String, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * 
     */
    @Deprecated
    public void warn(Object message) {
        warn(false, "{0}", message);
    }

    /**
     * WARNOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #warn(String, Throwable, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * @param t NO
     * 
     */
    @Deprecated
    public void warn(Object message, Throwable t) {
        warn(false, "{0}", t, message);
    }

    /**
     * ERROROo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #error(String, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * 
     */
    @Deprecated
    public void error(Object message) {
        error(false, "{0}", message);
    }

    /**
     * ERROROo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #error(String, Throwable, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * @param t NO
     * 
     */
    @Deprecated
    public void error(Object message, Throwable t) {
        error(false, "{0}", t, message);
    }

    /**
     * FATALOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #fatal(String, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * 
     */
    @Deprecated
    public void fatal(Object message) {
        fatal(false, "{0}", message);
    }

    /**
     * FATALOo͂܂B<br>
     * <p>
     * CommonsLoggingLogC^tF[X邽߂APIłAgpȂłB<br>
     * {@link #fatal(String, Throwable, Object...)}gpĂB
     * </p>
     * 
     * @param message bZ[W
     * @param t NO
     * 
     */
    @Deprecated
    public void fatal(Object message, Throwable t) {
        fatal(false, "{0}", t, message);
    }

    /**
     * ObZ[W擾܂B
     * 
     * @param logId OID
     * @param args up[^
     * @return ObZ[W
     */
    public String getLogMessage(String logId, Object... args) {
        String message = createMessage(true, logId, args);
        return message;
    }

    // CommonsLoggingLogC^tF[Xŗp邽߂APIpӂ߂̑Ή

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * K[̃OxTRACE荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     */
    public void trace(String logId) {
        trace(logId, (Object[]) null);
    }

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * K[̃OxTRACE荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     */
    public void trace(String logId, Throwable throwable) {
        trace(logId, throwable, (Object[]) null);
    }

    /**
     * DEBUGOo͂܂B<br>
     * <p>
     * K[̃OxDEBUG荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     */
    public void debug(String logId) {
        debug(logId, (Object[]) null);
    }

    /**
     * DEBUGOo͂܂B<br>
     * <p>
     * K[̃OxDEBUG荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     */
    public void debug(String logId, Throwable throwable) {
        debug(logId, throwable, (Object[]) null);
    }

    /**
     * WARNOo͂܂B<br>
     * <p>
     * K[̃OxWARN荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     */
    public void warn(String logId) {
        warn(logId, (Object[]) null);
    }

    /**
     * TRACEOo͂܂B<br>
     * <p>
     * K[̃OxTRACE荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     */
    public void warn(String logId, Throwable throwable) {
        warn(logId, throwable, (Object[]) null);
    }

    /**
     * INFOOo͂܂B<br>
     * <p>
     * K[̃OxINFO荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     */
    public void info(String logId) {
        info(logId, (Object[]) null);
    }

    /**
     * INFOOo͂܂B<br>
     * <p>
     * K[̃OxINFO荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     */
    public void info(String logId, Throwable throwable) {
        info(logId, throwable, (Object[]) null);
    }

    /**
     * ERROROo͂܂B<br>
     * <p>
     * K[̃OxERROR荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     */
    public void error(String logId) {
        error(logId, (Object[]) null);
    }

    /**
     * ERROROo͂܂B<br>
     * <p>
     * K[̃OxERROR荂ꍇ͏o͂܂B<br>
     * ڍׂ{@link TLogger}QƂĂB
     * </p>
     * 
     * @param logId OID
     * @param throwable NO
     */
    public void error(String logId, Throwable throwable) {
        error(logId, throwable, (Object[]) null);
    }

    /**
     * FATALOo͂܂B
     * 
     * @param logId OID
     * @param throwable NO
     * @param args up[^
     */
    public void fatal(String logId) {
        fatal(logId, (Object[]) null);
    }

    /**
     * FATALOo͂܂B
     * 
     * @param logId OID
     * @param throwable NO
     */
    public void fatal(String logId, Throwable throwable) {
        fatal(logId, throwable, (Object[]) null);
    }
}
