/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.batch.constants.JobStatusConstants;
import jp.terasoluna.fw.batch.constants.LogId;
import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.executor.vo.BatchJobListParam;
import jp.terasoluna.fw.batch.executor.vo.BatchJobListResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobManagementParam;
import jp.terasoluna.fw.batch.executor.vo.BatchJobManagementUpdateParam;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;

import org.springframework.dao.DataAccessException;

/**
 * WuǗ֘A[eBeBB<br>
 * <br>
 * Ƀt[[NAbstractJobBatchExecutor痘p郆[eBeBB<br>
 * @see jp.terasoluna.fw.batch.executor.AbstractJobBatchExecutor
 */
public class JobUtil {

    /**
     * K[.
     */
    private static final TLogger LOGGER = TLogger.getLogger(JobUtil.class);

    /**
     * RXgN^
     */
    protected JobUtil() {
    }

    /**
     * <h6>WuXg擾.</h6>
     * @param queryDAO QueryDAO
     * @return WuXg
     */
    public static List<BatchJobListResult> selectJobList(QueryDAO queryDAO) {
        return selectJobList(null, queryDAO);
    }

    /**
     * <h6>WuXg擾.</h6>
     * @param queryDAO QueryDAO
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return WuXg
     */
    public static List<BatchJobListResult> selectJobList(QueryDAO queryDAO,
            int beginIndex, int maxCount) {
        return selectJobList(null, queryDAO, beginIndex, maxCount);
    }

    /**
     * <h6>WuXg擾.</h6>
     * @param jobAppCd WuƖR[h
     * @param queryDAO QueryDAO
     * @return WuXg
     */
    public static List<BatchJobListResult> selectJobList(String jobAppCd,
            QueryDAO queryDAO) {
        return selectJobList(jobAppCd, queryDAO, -1, -1);
    }

    /**
     * <h6>WuXg擾.</h6> {Xe[^X̃Wûݎ擾
     * @param jobAppCd WuƖR[h
     * @param queryDAO QueryDAO
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return WuXg
     */
    public static List<BatchJobListResult> selectJobList(String jobAppCd,
            QueryDAO queryDAO, int beginIndex, int maxCount) {
        // Xe[^X
        List<String> curAppStatusList = new ArrayList<String>();

        // Xe[^Xi{j
        curAppStatusList.add(JobStatusConstants.JOB_STATUS_UNEXECUTION);

        return selectJobList(jobAppCd, curAppStatusList, queryDAO, beginIndex,
                maxCount);
    }

    /**
     * <h6>WuXg擾.</h6>
     * @param jobAppCd WuƖR[h
     * @param curAppStatusList 擾Xe[^Ẍꗗ
     * @param queryDAO QueryDAO
     * @param beginIndex 擾JnCfbNX
     * @param maxCount 擾錏
     * @return WuXg
     */
    public static List<BatchJobListResult> selectJobList(String jobAppCd,
            List<String> curAppStatusList, QueryDAO queryDAO, int beginIndex,
            int maxCount) {

        BatchJobListParam param = new BatchJobListParam();

        // WuƖR[h
        param.setJobAppCd(jobAppCd);

        // 擾Xe[^X
        if (curAppStatusList != null) {
            param.setCurAppStatusList(curAppStatusList);
        }

        List<BatchJobListResult> result = null;
        try {
            if (beginIndex == -1 || maxCount == -1) {
                result = queryDAO.executeForObjectList(
                        "batchExecutor.selectJobList", param);
            } else {
                result = queryDAO.executeForObjectList(
                        "batchExecutor.selectJobList", param, beginIndex,
                        maxCount);
            }
        } catch (Exception e) {
            throw new BatchException(LOGGER.getLogMessage(LogId.EAL025039), e);
        }

        return result;
    }

    /**
     * <h6>Wu1擾.</h6>
     * @param jobSequenceId
     * @param forUpdate
     * @param queryDAO
     * @return
     */
    public static BatchJobData selectJob(String jobSequenceId,
            boolean forUpdate, QueryDAO queryDAO) {
        BatchJobManagementParam param = new BatchJobManagementParam();

        // WuV[PXR[h
        param.setJobSequenceId(jobSequenceId);

        // FOR UPDATEt^
        param.setForUpdate(forUpdate);

        BatchJobData result = null;
        try {
            result = (BatchJobData) queryDAO.executeForObject(
                    "batchExecutor.selectJob", param, BatchJobData.class);
        } catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(LogId.EAL025040, e);
            }
            if (e instanceof DataAccessException) {
                throw (DataAccessException) e;
            }
        }

        return result;
    }

    /**
     * <h6>WuR[hXV.</h6>
     * @param jobSequenceId
     * @param curAppStatus
     * @param jobRetCount
     * @param errAppStatus
     * @param updateDAO
     * @return
     */
    public static boolean updateJobStatus(String jobSequenceId,
            String curAppStatus, String jobRetCount, String blogicAppStatus,
            QueryDAO queryDAO, UpdateDAO updateDAO) {
        BatchJobManagementUpdateParam param = new BatchJobManagementUpdateParam();

        // WuV[PXR[h
        param.setJobSequenceId(jobSequenceId);

        // ƖXe[^X
        param.setBLogicAppStatus(blogicAppStatus);

        // Xe[^X
        param.setCurAppStatus(curAppStatus);

        // XVi~bj
        Timestamp updDateTime = getCurrentTime(queryDAO);
        param.setUpdDateTime(updDateTime);

        int count = -1;
        try {
            count = updateDAO.execute("batchExecutor.updateJobTable", param);
        } catch (Exception e) {
            LOGGER.error(LogId.EAL025041, e);
            if (e instanceof DataAccessException) {
               throw (DataAccessException) e;
            }
            return false;
        }

        if (count != 1) {
            LOGGER.error(LogId.EAL025042);

            return false;
        }

        return true;
    }

    /**
     * <h6>Jg擾.</h6>
     * @param queryDAO
     * @return Timestamp Jg
     */
    @Deprecated
    public static Timestamp getCurrentTime(QueryDAO queryDAO) {
        Timestamp result = null;
        try {
            result = (Timestamp) queryDAO.executeForObject(
                    "batchExecutor.currentTimeReader", null, Timestamp.class);
        } catch (Exception e) {
            LOGGER.error(LogId.EAL025043, e);
            if (e instanceof DataAccessException) {
                throw (DataAccessException) e;
            }
        }
        return result;
    }

    /**
     * <h6>Jgt擾.</h6>
     * @param queryDAO
     * @return Date Jgt
     */
    @Deprecated
    public static Date getCurrentDate(QueryDAO queryDAO) {
        Date result = null;
        try {
            result = (Date) queryDAO.executeForObject(
                    "batchExecutor.currentDateReader", null, Date.class);
        } catch (Exception e) {
            LOGGER.error(LogId.EAL025043, e);

        }
        return result;
    }

    /**
     * <h6>w肳ꂽϐ̒l擾.</h6>
     * <p>
     * VXeŕϐ`Ȃꍇ ""i󕶎j Ԃ
     * </p>
     * @param name
     * @return
     */
    public static String getenv(String name) {
        String ret = System.getenv(name);
        if (ret == null) {
            return "";
        }
        return ret;
    }
}
