/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.util;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.util.strategy.ComparatorCompareStrategy;
import jp.terasoluna.fw.collector.util.strategy.CompareStrategy;
import jp.terasoluna.fw.logger.TLogger;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBreakChecker {
    private static final TLogger LOGGER = TLogger.getLogger(ControlBreakChecker.class);

    protected ControlBreakChecker() {
    }

    public static boolean isPreBreak(Collector<?> collector, String ... keys) {
        return ControlBreakChecker.isPreBreak(collector, null, keys);
    }

    public static boolean isPreBreak(Collector<?> collector, CompareStrategy<?>[] compareStrategies, String[] keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getPrevious();
            return ControlBreakChecker.isBreakInternal(current, other, compareStrategies, keys);
        }
        return false;
    }

    public static boolean isBreak(Collector<?> collector, String ... keys) {
        return ControlBreakChecker.isBreak(collector, null, keys);
    }

    public static boolean isBreak(Collector<?> collector, CompareStrategy<?>[] compareStrategies, String[] keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getNext();
            return ControlBreakChecker.isBreakInternal(current, other, compareStrategies, keys);
        }
        return false;
    }

    protected static boolean isBreakInternal(Object current, Object other, Comparator<?>[] comparators, String ... keys) {
        if (comparators != null) {
            CompareStrategy[] compareStrategies = new CompareStrategy[comparators.length];
            for (int i = 0; i < comparators.length; ++i) {
                compareStrategies[i] = new ComparatorCompareStrategy(comparators[i]);
            }
            return ControlBreakChecker.isBreakInternal(current, other, compareStrategies, keys);
        }
        return ControlBreakChecker.isBreakInternal(current, other, (CompareStrategy[])null, keys);
    }

    protected static boolean isBreakInternal(Object current, Object other, CompareStrategy<?>[] compareStrategies, String ... keys) {
        if (keys == null || keys.length == 0) {
            return false;
        }
        if (current != null && other == null || current == null && other != null) {
            return true;
        }
        if (other != null && current != null) {
            for (int keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
                String key = keys[keyIndex];
                CompareStrategy<?> compareStrategy = null;
                if (compareStrategies != null) {
                    if (compareStrategies.length == 1) {
                        compareStrategy = compareStrategies[0];
                    } else if (keyIndex < compareStrategies.length) {
                        compareStrategy = compareStrategies[keyIndex];
                    }
                }
                if (key == null || key.length() == 0) continue;
                Object currentValue = null;
                Object otherValue = null;
                try {
                    currentValue = PropertyUtils.getProperty((Object)current, (String)key);
                }
                catch (Exception e) {
                    ControlBreakChecker.logOutputPropNotFound(e, current, key);
                    continue;
                }
                try {
                    otherValue = PropertyUtils.getProperty((Object)other, (String)key);
                }
                catch (Exception e) {
                    ControlBreakChecker.logOutputPropNotFound(e, other, key);
                    continue;
                }
                if (ControlBreakChecker.equalsObjects(currentValue, otherValue, compareStrategy)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> getPreBreakKey(Collector<?> collector, String ... keys) {
        return ControlBreakChecker.getPreBreakKey(collector, null, keys);
    }

    public static Map<String, Object> getPreBreakKey(Collector<?> collector, CompareStrategy<?>[] compareStrategies, String[] keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getPrevious();
            return ControlBreakChecker.getBreakKeyInternal(current, other, compareStrategies, keys);
        }
        return new LinkedHashMap<String, Object>();
    }

    public static Map<String, Object> getBreakKey(Collector<?> collector, String ... keys) {
        return ControlBreakChecker.getBreakKey(collector, null, keys);
    }

    public static Map<String, Object> getBreakKey(Collector<?> collector, CompareStrategy<?>[] compareStrategies, String[] keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getNext();
            return ControlBreakChecker.getBreakKeyInternal(current, other, compareStrategies, keys);
        }
        return new LinkedHashMap<String, Object>();
    }

    protected static Map<String, Object> getBreakKeyInternal(Object current, Object other, Comparator<?>[] comparators, String ... keys) {
        if (comparators != null) {
            CompareStrategy[] compareStrategies = new CompareStrategy[comparators.length];
            for (int i = 0; i < comparators.length; ++i) {
                compareStrategies[i] = new ComparatorCompareStrategy(comparators[i]);
            }
            return ControlBreakChecker.getBreakKeyInternal(current, other, compareStrategies, keys);
        }
        return ControlBreakChecker.getBreakKeyInternal(current, other, (CompareStrategy[])null, keys);
    }

    protected static Map<String, Object> getBreakKeyInternal(Object current, Object other, CompareStrategy<?>[] compareStrategies, String ... keys) {
        boolean inBreak = false;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (keys == null || keys.length == 0) {
            return result;
        }
        for (int keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
            String key = keys[keyIndex];
            CompareStrategy<?> compareStrategy = null;
            Object currentValue = null;
            Object otherValue = null;
            if (compareStrategies != null) {
                if (compareStrategies.length == 1) {
                    compareStrategy = compareStrategies[0];
                } else if (keyIndex < compareStrategies.length) {
                    compareStrategy = compareStrategies[keyIndex];
                }
            }
            if (key != null && key.length() != 0) {
                if (current != null) {
                    try {
                        currentValue = PropertyUtils.getProperty((Object)current, (String)key);
                    }
                    catch (Exception e) {
                        ControlBreakChecker.logOutputPropNotFound(e, current, key);
                        continue;
                    }
                }
                if (other != null) {
                    try {
                        otherValue = PropertyUtils.getProperty((Object)other, (String)key);
                    }
                    catch (Exception e) {
                        ControlBreakChecker.logOutputPropNotFound(e, other, key);
                        continue;
                    }
                }
                if (!inBreak) {
                    if (current != null && other == null || current == null && other != null) {
                        inBreak = true;
                    }
                    if (!ControlBreakChecker.equalsObjects(currentValue, otherValue, compareStrategy)) {
                        inBreak = true;
                    }
                }
            }
            if (!inBreak) continue;
            result.put(key, currentValue);
        }
        return result;
    }

    protected static boolean equalsObjects(Object value1, Object value2) {
        return ControlBreakChecker.equalsObjects(value1, value2, null);
    }

    protected static void logOutputPropNotFound(Exception e, Object obj, String key) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("WAL041002", new Object[]{key, obj == null ? null : obj.getClass().getSimpleName(), e == null ? null : e.getMessage()});
        }
    }

    protected static boolean equalsObjects(Object value1, Object value2, CompareStrategy compareStrategy) {
        if (value1 != null && value2 != null) {
            if (compareStrategy != null) {
                return compareStrategy.equalsObjects(value1, value2);
            }
            Class<Class> clazz = value1.getClass();
            if (value1 instanceof Comparable) {
                return ((Comparable)value1).compareTo(value2) == 0;
            }
            if (clazz.isAssignableFrom(Class.class)) {
                return value1.equals(value2);
            }
            return EqualsBuilder.reflectionEquals((Object)value1, (Object)value2);
        }
        return value1 == null && value2 == null;
    }
}

