/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ValueExpression;
import org.h2.fulltext.FullTextSettings;
import org.h2.fulltext.IndexInfo;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.tools.SimpleResultSet;
import org.h2.util.ByteUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ObjectUtils;
import org.h2.util.StringUtils;

public class FullText
implements Trigger {
    private static final String TRIGGER_PREFIX = "FT_";
    private static final String SCHEMA = "FT";
    private static final String FIELD_QUERY = "QUERY";
    private static final String FIELD_SCHEMA = "SCHEMA";
    private static final String FIELD_TABLE = "TABLE";
    private static final String FIELD_COLUMNS = "COLUMNS";
    private static final String FIELD_KEYS = "KEYS";
    private IndexInfo index;
    private int[] dataTypes;
    private PreparedStatement prepInsertWord;
    private PreparedStatement prepInsertRow;
    private PreparedStatement prepInsertMap;
    private PreparedStatement prepDeleteRow;
    private PreparedStatement prepDeleteMap;
    private PreparedStatement prepSelectRow;
    static /* synthetic */ Class class$org$h2$fulltext$FullText;

    public static void createIndex(Connection connection, String string, String string2, String string3) throws SQLException {
        FullText.init(connection);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO FT.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.execute();
        FullText.createTrigger(connection, string, string2);
        FullText.indexExistingRows(connection, string, string2);
    }

    private static void createTrigger(Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        String string3 = StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + string2);
        statement.execute("DROP TRIGGER IF EXISTS " + string3);
        StringBuffer stringBuffer = new StringBuffer("CREATE TRIGGER IF NOT EXISTS ");
        stringBuffer.append(string3);
        stringBuffer.append(" AFTER INSERT, UPDATE, DELETE ON ");
        stringBuffer.append(StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(string2));
        stringBuffer.append(" FOR EACH ROW CALL \"");
        stringBuffer.append((class$org$h2$fulltext$FullText == null ? (class$org$h2$fulltext$FullText = FullText.class$("org.h2.fulltext.FullText")) : class$org$h2$fulltext$FullText).getName());
        stringBuffer.append("\"");
        statement.execute(stringBuffer.toString());
    }

    private static void indexExistingRows(Connection connection, String string, String string2) throws SQLException {
        FullText fullText = new FullText();
        fullText.init(connection, string, null, string2, false, 1);
        StringBuffer stringBuffer = new StringBuffer("SELECT * FROM ");
        stringBuffer.append(StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(string2));
        ResultSet resultSet = connection.createStatement().executeQuery(stringBuffer.toString());
        int n = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = resultSet.getObject(i + 1);
            }
            fullText.fire(connection, null, objectArray);
        }
    }

    public static void reindex(Connection connection) throws SQLException {
        FullText.init(connection);
        FullText.removeAllTriggers(connection);
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        fullTextSettings.getWordList().clear();
        Statement statement = connection.createStatement();
        statement.execute("TRUNCATE TABLE FT.WORDS");
        statement.execute("TRUNCATE TABLE FT.ROWS");
        statement.execute("TRUNCATE TABLE FT.MAP");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM FT.INDEXES");
        while (resultSet.next()) {
            String string = resultSet.getString(FIELD_SCHEMA);
            String string2 = resultSet.getString(FIELD_TABLE);
            FullText.createTrigger(connection, string, string2);
            FullText.indexExistingRows(connection, string, string2);
        }
    }

    public static void setIgnoreList(Connection connection, String string) throws SQLException {
        FullText.init(connection);
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        FullText.setIgnoreList(fullTextSettings, string);
        Statement statement = connection.createStatement();
        statement.execute("TRUNCATE TABLE FT.IGNORELIST");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO FT.IGNORELIST VALUES(?)");
        preparedStatement.setString(1, string);
        preparedStatement.execute();
    }

    private static void setIgnoreList(FullTextSettings fullTextSettings, String string) {
        String[] stringArray = StringUtils.arraySplit(string, ',', true);
        HashSet hashSet = fullTextSettings.getIgnoreList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ((string2 = fullTextSettings.convertWord(string2)) == null) continue;
            hashSet.add(stringArray[i]);
        }
    }

    private static void removeAllTriggers(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
        Statement statement2 = connection.createStatement();
        while (resultSet.next()) {
            String string = resultSet.getString("TRIGGER_SCHEMA");
            String string2 = resultSet.getString("TRIGGER_NAME");
            if (!string2.startsWith(TRIGGER_PREFIX)) continue;
            string2 = StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(string2);
            statement2.execute("DROP TRIGGER " + string2);
        }
    }

    public static void dropAll(Connection connection) throws SQLException {
        FullText.init(connection);
        Statement statement = connection.createStatement();
        statement.execute("DROP SCHEMA IF EXISTS FT");
        FullText.removeAllTriggers(connection);
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        fullTextSettings.getIgnoreList().clear();
        fullTextSettings.getWordList().clear();
    }

    public static void init(Connection connection) throws SQLException {
        Object object;
        Statement statement = connection.createStatement();
        statement.execute("CREATE SCHEMA IF NOT EXISTS FT");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.INDEXES(ID INT AUTO_INCREMENT PRIMARY KEY, SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, UNIQUE(SCHEMA, TABLE))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.WORDS(ID INT AUTO_INCREMENT PRIMARY KEY, NAME VARCHAR, UNIQUE(NAME))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.ROWS(ID IDENTITY, HASH INT, INDEXID INT, KEY VARCHAR, UNIQUE(HASH, INDEXID, KEY))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.MAP(ROWID INT, WORDID INT, PRIMARY KEY(WORDID, ROWID))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.IGNORELIST(LIST VARCHAR)");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_CREATE_INDEX FOR \"" + (class$org$h2$fulltext$FullText == null ? (class$org$h2$fulltext$FullText = FullText.class$("org.h2.fulltext.FullText")) : class$org$h2$fulltext$FullText).getName() + ".createIndex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH FOR \"" + (class$org$h2$fulltext$FullText == null ? (class$org$h2$fulltext$FullText = FullText.class$("org.h2.fulltext.FullText")) : class$org$h2$fulltext$FullText).getName() + ".search\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH_DATA FOR \"" + (class$org$h2$fulltext$FullText == null ? (class$org$h2$fulltext$FullText = FullText.class$("org.h2.fulltext.FullText")) : class$org$h2$fulltext$FullText).getName() + ".searchData\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_REINDEX FOR \"" + (class$org$h2$fulltext$FullText == null ? (class$org$h2$fulltext$FullText = FullText.class$("org.h2.fulltext.FullText")) : class$org$h2$fulltext$FullText).getName() + ".reindex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_DROP_ALL FOR \"" + (class$org$h2$fulltext$FullText == null ? (class$org$h2$fulltext$FullText = FullText.class$("org.h2.fulltext.FullText")) : class$org$h2$fulltext$FullText).getName() + ".dropAll\"");
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM FT.IGNORELIST");
        while (resultSet.next()) {
            object = resultSet.getString(1);
            FullText.setIgnoreList(fullTextSettings, (String)object);
        }
        resultSet = statement.executeQuery("SELECT * FROM FT.WORDS");
        object = fullTextSettings.getWordList();
        while (resultSet.next()) {
            String string = resultSet.getString("NAME");
            int n = resultSet.getInt("ID");
            if ((string = fullTextSettings.convertWord(string)) == null) continue;
            ((HashMap)object).put(string, ObjectUtils.getInteger(n));
        }
    }

    public void init(Connection connection, String string, String string2, String string3, boolean bl, int n) throws SQLException {
        Object object;
        Object object2;
        FullText.init(connection);
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        ArrayList<String> arrayList = new ArrayList<String>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, string, string3, null);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (resultSet.next()) {
            arrayList2.add(resultSet.getString("COLUMN_NAME"));
        }
        this.dataTypes = new int[arrayList2.size()];
        this.index = new IndexInfo();
        this.index.schemaName = string;
        this.index.tableName = string3;
        this.index.columnNames = new String[arrayList2.size()];
        arrayList2.toArray(this.index.columnNames);
        resultSet = databaseMetaData.getColumns(null, string, string3, null);
        int n2 = 0;
        while (resultSet.next()) {
            this.dataTypes[n2] = resultSet.getInt("DATA_TYPE");
            ++n2;
        }
        if (arrayList.size() == 0) {
            resultSet = databaseMetaData.getPrimaryKeys(null, string, string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        if (arrayList.size() == 0) {
            throw new SQLException("No primary key for table " + string3);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT ID, COLUMNS FROM FT.INDEXES WHERE SCHEMA=? AND TABLE=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string3);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            this.index.id = resultSet.getInt(1);
            object2 = resultSet.getString(2);
            if (object2 != null) {
                object = StringUtils.arraySplit((String)object2, ',', true);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    arrayList3.add(object[i]);
                }
            }
        }
        if (arrayList3.size() == 0) {
            arrayList3.addAll(arrayList2);
        }
        this.index.keys = new int[arrayList.size()];
        this.setColumns(this.index.keys, arrayList, arrayList2);
        this.index.indexColumns = new int[arrayList3.size()];
        this.setColumns(this.index.indexColumns, arrayList3, arrayList2);
        fullTextSettings.addIndexInfo(this.index);
        this.prepInsertWord = connection.prepareStatement("INSERT INTO FT.WORDS(NAME) VALUES(?)");
        this.prepInsertRow = connection.prepareStatement("INSERT INTO FT.ROWS(HASH, INDEXID, KEY) VALUES(?, ?, ?)");
        this.prepInsertMap = connection.prepareStatement("INSERT INTO FT.MAP(ROWID, WORDID) VALUES(?, ?)");
        this.prepDeleteRow = connection.prepareStatement("DELETE FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND KEY=?");
        this.prepDeleteMap = connection.prepareStatement("DELETE FROM FT.MAP WHERE ROWID=? AND WORDID=?");
        this.prepSelectRow = connection.prepareStatement("SELECT ID FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND KEY=?");
        object2 = connection.prepareStatement("SELECT ROWID FROM FT.MAP WHERE WORDID=?");
        object = connection.prepareStatement("SELECT KEY, INDEXID FROM FT.ROWS WHERE ID=?");
        fullTextSettings.setPrepSelectMapByWordId((PreparedStatement)object2);
        fullTextSettings.setPrepSelectRowById((PreparedStatement)object);
    }

    private void setColumns(int[] nArray, ArrayList arrayList, ArrayList arrayList2) throws SQLException {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            int n = -1;
            for (int j = 0; n == -1 && j < arrayList2.size(); ++j) {
                String string2 = (String)arrayList2.get(j);
                if (!string2.equals(string)) continue;
                n = j;
            }
            if (n < 0) {
                throw new SQLException("FULLTEXT", "Column not found: " + string);
            }
            nArray[i] = n;
        }
    }

    public void fire(Connection connection, Object[] objectArray, Object[] objectArray2) throws SQLException {
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        if (objectArray != null) {
            this.delete(fullTextSettings, objectArray);
        }
        if (objectArray2 != null) {
            this.insert(fullTextSettings, objectArray2);
        }
    }

    private String getKey(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.index.keys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" AND ");
            }
            int n = this.index.keys[i];
            stringBuffer.append(StringUtils.quoteIdentifier(this.index.columnNames[n]));
            Object object = objectArray[n];
            if (object == null) {
                stringBuffer.append(" IS NULL");
                continue;
            }
            stringBuffer.append("=");
            stringBuffer.append(this.quoteSQL(object, this.dataTypes[n]));
        }
        String string = stringBuffer.toString();
        return string;
    }

    private String quoteString(String string) {
        if (string.indexOf(39) < 0) {
            return "'" + string + "'";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\'');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    private String quoteBinary(byte[] byArray) {
        return "'" + ByteUtils.convertBytesToString(byArray) + "'";
    }

    private String asString(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return object.toString();
            }
            case 2005: {
                try {
                    return IOUtils.readStringAndClose((Reader)object, -1);
                }
                catch (IOException iOException) {
                    throw Message.convert(iOException);
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: {
                throw new SQLException("FULLTEXT", "Unsupported column data type: " + n);
            }
        }
        return "";
    }

    private String quoteSQL(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return object.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return this.quoteString(object.toString());
            }
            case -4: 
            case -3: 
            case -2: {
                return this.quoteBinary((byte[])object);
            }
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw new SQLException("FULLTEXT", "Unsupported key data type: " + n);
            }
        }
        return "";
    }

    private static void addWords(FullTextSettings fullTextSettings, HashSet hashSet, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f+\"*%&/()=?'!,.;:-_#@|^~`{}[]");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((string2 = fullTextSettings.convertWord(string2)) == null) continue;
            hashSet.add(string2);
        }
    }

    private int[] getWordIds(FullTextSettings fullTextSettings, Object[] objectArray) throws SQLException {
        Object object;
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.index.indexColumns.length; ++i) {
            int n = this.index.indexColumns[i];
            object = this.asString(objectArray[n], this.dataTypes[n]);
            FullText.addWords(fullTextSettings, hashSet, (String)object);
        }
        HashMap hashMap = fullTextSettings.getWordList();
        int[] nArray = new int[hashSet.size()];
        object = hashSet.iterator();
        int n = 0;
        while (object.hasNext()) {
            int n2;
            String string = (String)object.next();
            Integer n3 = (Integer)hashMap.get(string);
            if (n3 == null) {
                this.prepInsertWord.setString(1, string);
                this.prepInsertWord.execute();
                ResultSet resultSet = JdbcUtils.getGeneratedKeys(this.prepInsertWord);
                resultSet.next();
                n2 = resultSet.getInt(1);
                hashMap.put(string, ObjectUtils.getInteger(n2));
            } else {
                n2 = n3;
            }
            nArray[n] = n2;
            ++n;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private void insert(FullTextSettings fullTextSettings, Object[] objectArray) throws SQLException {
        String string = this.getKey(objectArray);
        int n = string.hashCode();
        this.prepInsertRow.setInt(1, n);
        this.prepInsertRow.setInt(2, this.index.id);
        this.prepInsertRow.setString(3, string);
        this.prepInsertRow.execute();
        ResultSet resultSet = JdbcUtils.getGeneratedKeys(this.prepInsertRow);
        resultSet.next();
        int n2 = resultSet.getInt(1);
        this.prepInsertMap.setInt(1, n2);
        int[] nArray = this.getWordIds(fullTextSettings, objectArray);
        for (int i = 0; i < nArray.length; ++i) {
            this.prepInsertMap.setInt(2, nArray[i]);
            this.prepInsertMap.execute();
        }
    }

    private void delete(FullTextSettings fullTextSettings, Object[] objectArray) throws SQLException {
        String string = this.getKey(objectArray);
        int n = string.hashCode();
        this.prepSelectRow.setInt(1, n);
        this.prepSelectRow.setInt(2, this.index.id);
        this.prepSelectRow.setString(3, string);
        ResultSet resultSet = this.prepSelectRow.executeQuery();
        if (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            this.prepDeleteMap.setInt(1, n2);
            int[] nArray = this.getWordIds(fullTextSettings, objectArray);
            for (int i = 0; i < nArray.length; ++i) {
                this.prepDeleteMap.setInt(2, nArray[i]);
                this.prepDeleteMap.executeUpdate();
            }
            this.prepDeleteRow.setInt(1, n);
            this.prepDeleteRow.setInt(2, this.index.id);
            this.prepDeleteRow.setString(3, string);
            this.prepDeleteRow.executeUpdate();
        }
    }

    public static ResultSet searchData(Connection connection, String string, int n, int n2) throws SQLException {
        return FullText.search(connection, string, n, n2, true);
    }

    public static ResultSet search(Connection connection, String string, int n, int n2) throws SQLException {
        return FullText.search(connection, string, n, n2, false);
    }

    static SimpleResultSet createResultSet(boolean bl) throws SQLException {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        if (bl) {
            simpleResultSet.addColumn(FIELD_SCHEMA, 12, 0, 0);
            simpleResultSet.addColumn(FIELD_TABLE, 12, 0, 0);
            simpleResultSet.addColumn(FIELD_COLUMNS, 2003, 0, 0);
            simpleResultSet.addColumn(FIELD_KEYS, 2003, 0, 0);
        } else {
            simpleResultSet.addColumn(FIELD_QUERY, 12, 0, 0);
        }
        return simpleResultSet;
    }

    private static ResultSet search(Connection connection, String string, int n, int n2, boolean bl) throws SQLException {
        Object object;
        Object object2;
        SimpleResultSet simpleResultSet = FullText.createResultSet(bl);
        if (connection.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return simpleResultSet;
        }
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        HashSet hashSet = new HashSet();
        FullText.addWords(fullTextSettings, hashSet, string);
        HashSet<Object> hashSet2 = null;
        HashSet<Object> hashSet3 = null;
        HashMap hashMap = fullTextSettings.getWordList();
        PreparedStatement preparedStatement = fullTextSettings.getPrepSelectMapByWordId();
        Object object3 = hashSet.iterator();
        while (object3.hasNext()) {
            hashSet3 = hashSet2;
            hashSet2 = new HashSet<Object>();
            String string2 = (String)object3.next();
            object2 = (Integer)hashMap.get(string2);
            if (object2 == null) continue;
            preparedStatement.setInt(1, (Integer)object2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = ObjectUtils.getInteger(resultSet.getInt(1));
                if (hashSet3 != null && !hashSet3.contains(object)) continue;
                hashSet2.add(object);
            }
        }
        if (hashSet2 == null || hashSet2.size() == 0) {
            return simpleResultSet;
        }
        object3 = fullTextSettings.getPrepSelectRowById();
        int n3 = 0;
        object2 = hashSet2.iterator();
        while (object2.hasNext()) {
            Object object4;
            Object object5;
            int n4 = (Integer)object2.next();
            object3.setInt(1, n4);
            object = object3.executeQuery();
            if (!object.next()) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            String string3 = object.getString(1);
            int n5 = object.getInt(2);
            IndexInfo indexInfo = fullTextSettings.getIndexInfo(n5);
            if (bl) {
                object5 = FullText.parseKey(connection, string3);
                object4 = new Object[]{indexInfo.schemaName, indexInfo.tableName, object5[0], object5[1]};
                simpleResultSet.addRow((Object[])object4);
            } else {
                object5 = new StringBuffer();
                ((StringBuffer)object5).append(StringUtils.quoteIdentifier(indexInfo.schemaName));
                ((StringBuffer)object5).append('.');
                ((StringBuffer)object5).append(StringUtils.quoteIdentifier(indexInfo.tableName));
                ((StringBuffer)object5).append(" WHERE ");
                ((StringBuffer)object5).append(string3);
                object4 = ((StringBuffer)object5).toString();
                simpleResultSet.addRow(new String[]{object4});
            }
            if (n <= 0 || ++n3 < n) continue;
            break;
        }
        return simpleResultSet;
    }

    static Object[][] parseKey(Connection connection, String string) throws SQLException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        JdbcConnection jdbcConnection = (JdbcConnection)connection;
        Session session = (Session)jdbcConnection.getSession();
        Parser parser = new Parser(session);
        Expression expression = parser.parseExpression(string);
        FullText.addColumnData(arrayList, arrayList2, expression);
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        Object[] objectArray2 = new Object[arrayList.size()];
        arrayList2.toArray(objectArray2);
        Object[][] objectArray3 = new Object[][]{objectArray, objectArray2};
        return objectArray3;
    }

    private static void addColumnData(ArrayList arrayList, ArrayList arrayList2, Expression expression) {
        if (expression instanceof ConditionAndOr) {
            ConditionAndOr conditionAndOr = (ConditionAndOr)expression;
            Expression expression2 = conditionAndOr.getExpression(true);
            Expression expression3 = conditionAndOr.getExpression(false);
            FullText.addColumnData(arrayList, arrayList2, expression2);
            FullText.addColumnData(arrayList, arrayList2, expression3);
        } else {
            Comparison comparison = (Comparison)expression;
            ExpressionColumn expressionColumn = (ExpressionColumn)comparison.getExpression(true);
            ValueExpression valueExpression = (ValueExpression)comparison.getExpression(false);
            String string = expressionColumn.getColumnName();
            arrayList.add(string);
            if (valueExpression == null) {
                arrayList2.add(null);
            } else {
                arrayList2.add(valueExpression.getValue(null).getString());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

