/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.common.filter;

import java.util.List;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.UserValueObject;
import jp.terasoluna.fw.web.thin.AuthenticationController;
import jp.terasoluna.toursample.common.TourUVO;

/**
 * AuthenticationControllerOIF؍ς݃`FbNsNXB<br>
 * <br>
 * EʏCP0002FOCς݌
 * 
 * <h5>Tv</h5>
 * <p>
 * AuthenticationControllerɂẮA evWFNgƂɎNX쐬B <br>
 * ̎AOIF؍ς݃`FbN@̓vWFNgƂɈقȂׁA Cӂ̎sƁB
 * </p>
 * <p>
 * TvAvP[Vł́ABean`ɂ pX擾䂷悤ĂB <br>
 * </p>
 * <p>
 * OIF؍ς݃`FbN̏ΏۂƂȂpXɂẮA
 * 炩Bean`t@CɂauthenticatedNoCheckPathsɐK\Őݒ肵ĂA
 * NGXg̃pXauthenticatedNoCheckPaths̐K\ɈvȂꍇɁA ZbV
 * {@link jp.terasoluna.toursample.common.TourUVO} i[Ă邩ǂŁA`FbNsB
 * </p>
 * 
 * @see jp.terasoluna.fw.web.thin.AuthenticationController
 * @see jp.terasoluna.fw.web.thin.AuthenticationControlFilter
 * @see jp.terasoluna.fw.web.UserValueObject
 * @see jp.terasoluna.toursample.common.TourUVO
 * 
 * 
 * 
 */
public class TourAuthenticationController implements AuthenticationController {

    /**
     * F؃`FbNsȂpX񃊃XgB
     */
    private List<String> authenticatedNoCheckPaths = null;

    /**
     * F؃`FbNsȂpX񃊃Xgݒ肷B
     * 
     * @param authenticatedNoCheckPaths
     *            pX񃊃Xg
     */
    public void setAuthenticatedNoCheckPaths(
            List<String> authenticatedNoCheckPaths) {

        this.authenticatedNoCheckPaths = authenticatedNoCheckPaths;
    }

    /**
     * NGXg̃pXɑ΂āAOIF؍ς݂ǂ𔻒肷B
     * <p>
     * F؍ς݂ǂ̓ZbV {@link jp.terasoluna.toursample.common.TourUVO}
     * i[Ă邩ǂŔ肷B
     * </p>
     * 
     * @param pathInfo
     *            pX
     * @param req
     *            NGXg
     * @return F؍ς݂łtrueB
     */
    public boolean isAuthenticated(String pathInfo, ServletRequest req) {

        HttpSession session = ((HttpServletRequest) req).getSession();

        // ZbVIuWFNg擾
        Object getObject = session
            .getAttribute(UserValueObject.USER_VALUE_OBJECT_KEY);

        // `FbN
        if (getObject == null) {
            return false;
        }

        // `FbN
        if (getObject instanceof TourUVO) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * NGXg̃pXɑ΂A F؃`FbNsׂpXǂ𔻒肷B
     * <p>
     * ANZX悤ƂĂpXF؃`FbNsȂȂpX̐K\ XgɓȂꍇtrueԂB
     * </p>
     * 
     * @param req
     *            ΏۂƂȂServletRequestNXCX^X
     * @return F؃`FbNvꍇtrueB
     */
    public boolean isCheckRequired(ServletRequest req) {

        // pathInfo̎擾
        String pathInfo = RequestUtil.getPathInfo(req);

        // F؃`FbNsȂpX̃XgɂȂ΁A`FbN
        for (int i = 0; i < authenticatedNoCheckPaths.size(); i++) {
            String path = authenticatedNoCheckPaths.get(i);

            // `FbN
            if (pathInfo.matches(path)) {
                return false;
            }
        }
        return true;
    }

}
