/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.executor;

import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.batch.constants.LogId;
import jp.terasoluna.fw.logger.TLogger;

import org.springframework.context.ApplicationContext;

public class ThreadGroupApplicationContextHolder {
    /** K[. */
    private static final TLogger LOGGER = TLogger
            .getLogger(ThreadGroupApplicationContextHolder.class);

    /** XbhO[vApplicationContextێ. */
    private static final ConcurrentHashMap<ThreadGroup, ApplicationContext> tga = new ConcurrentHashMap<ThreadGroup, ApplicationContext>();

    /**
     * RXgN^
     */
    protected ThreadGroupApplicationContextHolder() {
    }

    /**
     * ApplicationContext擾.<br>
     * <p>
     * JgXbhXbhO[vɊ蓖ĂꂽApplicationContext擾B
     * </p>
     * @return ApplicationContextԋp
     */
    public static ApplicationContext getCurrentThreadGroupApplicationContext() {
        return getThreadGroupApplicationContext(getThreadGroup());
    }

    /**
     * ApplicationContext擾.<br>
     * <p>
     * œnXbhO[vɊ蓖ĂꂽApplicationContext擾B
     * </p>
     * @param threadGroup ThreadGroup
     * @return ApplicationContextԋp
     */
    public static ApplicationContext getThreadGroupApplicationContext(
            ThreadGroup threadGroup) {
        ApplicationContext applicationContext = null;

        if (threadGroup != null) {
            applicationContext = tga.get(threadGroup);

            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(LogId.TAL025003, getThreadMessage());
            }

        }

        return applicationContext;
    }

    /**
     * ApplicationContextݒ肷.<br>
     * <p>
     * Őݒ肷ApplicationContext̓XbhO[vɕێB
     * </p>
     * @param applicationContext ApplicationContext
     */
    protected static void setApplicationContext(
            ApplicationContext applicationContext) {
        if (applicationContext == null) {

            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(LogId.WAL025004, getThreadMessage());
            }

            return;
        }

        ThreadGroup tg = getThreadGroup();
        if (tg != null) {
            tga.put(tg, applicationContext);

            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(LogId.TAL025004, getThreadMessage());
            }

        }
    }

    /**
     * ApplicationContext폜.<br>
     */
    protected static void removeApplicationContext() {
        ThreadGroup tg = getThreadGroup();
        if (tg != null) {
            tga.remove(tg);

            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(LogId.TAL025005, getThreadMessage());
            }

        }
    }

    /**
     * XbhO[v擾.
     * @return ThreadGroup
     */
    private static ThreadGroup getThreadGroup() {
        Thread ct = Thread.currentThread();
        if (ct != null && ct.getThreadGroup() != null) {
            return ct.getThreadGroup();
        }
        return null;
    }

    /**
     * XbhO[vƃXbhԂ\bh.<br>
     * fobOpbZ[WԂB
     * @return String
     */
    private static String getThreadMessage() {
        StringBuilder sb = new StringBuilder();
        Thread ct = Thread.currentThread();

        if (ct != null && getThreadGroup() != null) {
            sb.append(" tg:[");
            sb.append(getThreadGroup().getName());
            sb.append("]");
        }
        if (ct != null) {
            sb.append(" t:[");
            sb.append(ct.getName());
            sb.append("]");
        }

        return sb.toString();
    }
}
