/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.exception.handler;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import jp.terasoluna.fw.batch.constants.LogId;
import jp.terasoluna.fw.logger.TLogger;

/**
 * Onh̃ftHg.
 */
public class DefaultExceptionHandler implements ExceptionHandler {
    /**
     * K[B
     */
    private static final TLogger LOGGER = TLogger
            .getLogger(DefaultExceptionHandler.class);

    /**
     * ftHgOnh̃^[R[h.
     */
    protected static final int DEFAULT_EXCEPTION_HANDLER_STATUS = 255;

    /**
     * ONXƕԋpXe[^Xl̃}bv<br>
     * <p>
     * Bean`ɗǑ^ƑΉXe[^XlƂ̃}bsO`邱ƂŁAOƂɕԋpXe[^Xlς邱ƂłB<br>
     * }bsOݒȗꍇ́AׂĂ̗Oɑ΂ăXe[^Xl255ԋpB<br>
     * </p>
     * <p>
     * <fieldset style="border:1pt solid black;padding:10px;width:100%;"><br>
     * <legend>Bean`Lq</legend>
     *
     * <pre>
     * &lt;property name=&quot;exceptionToStatusMap&quot;&gt;
     *   &lt;map&gt;
     *     &lt;entry key=&quot;jp.terasoluna.fw.batch.exception.BatchException&quot; value=&quot;123&quot;/&gt;
     *     &lt;entry key=&quot;java.lang.Exception&quot; value=&quot;100&quot;/&gt;
     *   &lt;/map&gt;
     * &lt;/property&gt;
     * </pre>
     *
     * </fieldset>
     * </p>
     */
    protected Map<Class<? extends Throwable>, Integer> exceptionToStatusMap = null;

    /**
     * ONXƕԋpXe[^Xl̃}bvݒ肷B
     * @param exceptionToStatusMap Map&lt;Class&lt;? extends Throwable&gt;, Integer&gt;
     */
    public void setExceptionToStatusMap(
            Map<Class<? extends Throwable>, Integer> exceptionToStatusMap) {
        this.exceptionToStatusMap = exceptionToStatusMap;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.batch.exception.handler.ExceptionHandler#handleThrowableException(java.lang.Throwable)
     */
    public int handleThrowableException(Throwable e) {
        // WARNOo͂
        LOGGER.warn(LogId.WAL025007,e);

        // ONXƕԋpXe[^Xl̃}bvݒ肳Ăꍇ͂ɏ]
        if (this.exceptionToStatusMap != null && e != null) {
            Class<? extends Throwable> exClass = e.getClass();

            Set<Entry<Class<? extends Throwable>, Integer>> es = this.exceptionToStatusMap
                    .entrySet();

            for (Entry<Class<? extends Throwable>, Integer> ent : es) {
                if (ent != null && ent.getKey() != null
                        && ent.getValue() != null) {
                    Class<? extends Throwable> entClass = ent.getKey();

                    if (entClass.isAssignableFrom(exClass)) {
                        if(LOGGER.isDebugEnabled()){
                            LOGGER.debug(LogId.DAL025017, exClass.getName(),entClass.getName(),ent.getValue());
                        }

                        return ent.getValue().intValue();
                    }
                }
            }
        }

        // ftHg̃Xe[^XlԂB
        return DEFAULT_EXCEPTION_HANDLER_STATUS;
    }
}
