package jp.terasoluna.fw.collector.db;

import java.util.concurrent.atomic.AtomicInteger;

public class DBCollectorPrePostProcessStub002 implements DBCollectorPrePostProcess {

    protected AtomicInteger preprocessExecCount = new AtomicInteger(0);
    
    protected boolean retryFlag = false;

    public <P> void preprocess(DBCollector<P> collector) {
    	// preprocess\bhĂ΂邽тɎs񐔂CNg
    	preprocessExecCount.getAndIncrement();
    	if(preprocessExecCount.get() >= 2) {
    		// 2ȏケ̏sĂꍇ̓gCtOtrueɂ
    		retryFlag = true;
    	}
    }

    public <P> void postprocessComplete(DBCollector<P> collector) {
    	/* NOP */
    }

    public <P> DBCollectorPrePostProcessStatus postprocessException(
            DBCollector<P> collector, Throwable throwable) {
        if (preprocessExecCount.get() == 1) {
        	// 1ڂRETRYԂăgC
        	return DBCollectorPrePostProcessStatus.RETRY;
        } else {
        	// 2ڈȍ~ENDԂďI
        	return DBCollectorPrePostProcessStatus.END;
        }
    }

    public boolean getRetryFlag() {
    	return retryFlag;
    }
}
