package jp.terasoluna.fw.collector.concurrent;

import static org.junit.Assert.*;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ArrayBlockingQueueExTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * RXgN^̊mF
     * ArrayBlockingQueueEx(int capacity, boolean fair)
     * fair̎w肪truȅꍇ
     */
    @Test
    public void testConstructor001() {
    	int capacity = 3;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity, true);
    	
    	// capacity ̊mF
    	int capacityResult = (Integer) ReflectionUtils.getField(queue, "capacity");
    	assertEquals(capacity, capacityResult);
    	
    	// fair ̊mF(true ɐݒ肵ꍇ́AFairSync, false ̏ꍇ NonFairSysc)
    	//    ReflectionUtil 𗘗pAqueue  lock 擾
    	//    locǩFair isyncFairSync ̃CX^Xjł邱ƂmFB
    	ReentrantLock lockResult = ReflectionUtils.getField(queue, ArrayBlockingQueue.class, "lock");
    	assertTrue(lockResult.isFair());    	
    	
    }

    /**
     * RXgN^̊mF
     * ArrayBlockingQueueEx(int capacity, boolean fair)
     * fair̎w肪falsȅꍇ
     */
    @Test
    public void testConstructor002() {
    	int capacity = 3;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity, false);
    	
    	// capacity ̊mF
    	int capacityResult = (Integer) ReflectionUtils.getField(queue, "capacity");
    	assertEquals(capacity, capacityResult);
    	
    	// fair ̊mF(true ɐݒ肵ꍇ́AFairSync, false ̏ꍇ NonFairSysc)
    	//    ReflectionUtil 𗘗pAqueue  lock 擾
    	//    locǩNonFair isyncFairSync ̃CX^Xł͂Ȃjł邱ƂmFB
    	ReentrantLock lockResult = ReflectionUtils.getField(queue, ArrayBlockingQueue.class, "lock");
    	assertFalse(lockResult.isFair());
    	
    }

    /**
     * RXgN^̊mF
     * ArrayBlockingQueueEx(int capacity)
     */
    @Test
    public void testConstructor003() {
    	int capacity = 3;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	// capacity ̊mF
    	int capacityResult = (Integer) ReflectionUtils.getField(queue, "capacity");
    	assertEquals(capacity, capacityResult);
    	
    }
    

    // AbstractCollector#setFinish ̎ɂĎ{B
//    @Test
//    public void testFinishQueueing001() {
//    }
    
    
    
    /**
     * poll(long timeout, TimeUnit unit) ̃eXg
     * ُnFInterruptedException̊mF
     */
    @Test
    public void testPoll001() throws Exception{
    	int capacity = 1;
    	
    	final long timeout = 20000;
    	final TimeUnit unit = TimeUnit.MILLISECONDS;

    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	try {
    		// ʃXbhoffersiL[Ȃ̂ő҂ɂȂj
            ErrorFeedBackThread thread01 = new ErrorFeedBackThread() {
            	@Override
            	public void doRun() throws Exception {
            		long timeStart = System.currentTimeMillis();
    				// ҂Ԃ
    				queue.poll(timeout, unit);
    				long timeEnd = System.currentTimeMillis();
    				long timeDiff = timeEnd - timeStart;
    				if(timeDiff < 100) {
    					fail();
    				}
            	}
            };
            
    		thread01.start();

    		Thread.sleep(100);
    		
    		// 荞
    		thread01.interrupt();
    		
    		thread01.throwErrorOrExceptionIfThrown();
    		
    		fail();
    	} catch (InterruptedException e) {
    		/* NOP */ 
    	} catch (Exception ex) {
    		fail();
    	}
    }

    /**
     * poll(long timeout, TimeUnit unit) ̃eXg
     * nF^CAEgɃL[̏ꍇnullԂmF
     */
    @Test
    public void testPoll002() throws Exception{
    	int capacity = 1;
    	
    	long timeout = 100;
    	TimeUnit unit = TimeUnit.MILLISECONDS;

    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	// L[ł邱Ƃ̊mF
    	assertEquals(0, queue.size());
    	
    	// poll̎sƏԌv
    	long timeStart = System.currentTimeMillis();
    	DataValueObject objResult = queue.poll(timeout, unit);
    	long timeEnd = System.currentTimeMillis();
    	long timeDiff = timeEnd - timeStart;
    	
    	// ʊmF
    	if (timeDiff < timeout) {
    		fail();
    	}
    	assertNull(objResult);
    }

    /**
     * poll(long timeout, TimeUnit unit) ̃eXg
     * nFL[CȌIʒmɃL[̏ꍇnullԂmF
     */
    @Test
    public void testPoll003() throws Exception{
    	int capacity = 1;

    	long timeout = 20000;
    	final long sleeptime = 1000;
    	TimeUnit unit = TimeUnit.MILLISECONDS;

    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	Thread thread01 = new Thread() {
    		@Override
    		public void run() {
    			try {
					sleep(sleeptime);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
    			queue.finishQueueing();
    		}
    	};
    	
    	// L[ł邱Ƃ̊mF
    	assertEquals(0, queue.size());

    	thread01.start();
    	
    	// poll̎sƏԌv
    	long timeStart = System.currentTimeMillis();
    	DataValueObject objResult = queue.poll(timeout, unit);
    	long timeEnd = System.currentTimeMillis();
    	long timeDiff = timeEnd - timeStart;
    	
    	// ʊmF
    	if (timeDiff < sleeptime) {
    		fail();
    	}
    	assertNull(objResult);
    }

    /**
     * poll(long timeout, TimeUnit unit) ̃eXg
     * nFL[̐擪擾폜邱Ƃ̊mF
     */
    @Test
    public void testPoll004() throws Exception{
        int capacity = 3;

    	long timeout = 100;
    	TimeUnit unit = TimeUnit.MILLISECONDS;

    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	DataValueObject obj1 = new DataValueObject("hoge");
    	DataValueObject obj2 = new DataValueObject("fuga");
    	DataValueObject obj3 = new DataValueObject("piyo");
    	
    	// L[ɗvfl߂iaddgpj
    	queue.add(obj1);
    	queue.add(obj2);
    	queue.add(obj3);
    	int sizeBefore = queue.size();
    	
    	// pollŗvf1擾
    	DataValueObject objPoll = queue.poll(timeout, unit);
    	int sizeAfter = queue.size();
    	
    	// 擾vfaddōŏɋl߂vfi擪̗vfjł邱ƂmF
    	assertEquals(obj1, objPoll);
    	
    	// vf1Ă邱ƂmF
    	assertEquals(1, sizeBefore - sizeAfter);
    }

    /**
     * offer(E o, long timeout, TimeUnit unit) ̃eXg
     * ُnFNullPointerException̊mF
     */
    @Test
    public void testOffer001() {
    	int capacity = 3;
    	
    	long timeout = 15;
    	TimeUnit unit = TimeUnit.SECONDS;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	try {
    		queue.offer(null, timeout, unit);
    		fail();
    	} catch (NullPointerException e) {
    		/* NOP */ 
    	} catch (Exception ex) {
    		fail();
    	}
    }

    /**
     * offer(E o, long timeout, TimeUnit unit) ̃eXg
     * ُnFInterruptedException̊mF
     */
    @Test
    public void testOffer002() {
    	int capacity = 1;
    	
    	final long timeout = 20000;
    	final TimeUnit unit = TimeUnit.MILLISECONDS;
    	DataValueObject obj1 = new DataValueObject("hoge1");
    	boolean result1 = false;
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	try {
    		// L[ςɂ
    		result1 = queue.offer(obj1, timeout, unit);
    		assertTrue(result1);
    		
    		// ʃXbhoffersiL[ςȂ̂ő҂ɂȂj
            ErrorFeedBackThread thread01 = new ErrorFeedBackThread() {
            	@Override
            	public void doRun() throws Exception {
    				DataValueObject obj2 = new DataValueObject("hoge2");
            		
    				// ҂Ԃ
    				long timeStart = System.currentTimeMillis();
    				queue.offer(obj2, timeout, unit);
    				long timeEnd = System.currentTimeMillis();
    				long timeDiff = timeEnd - timeStart;
    				if(timeDiff < 100) {
    					fail();
    				}
            	}
            };
            
    		thread01.start();

    		Thread.sleep(100);
    		
    		// 荞
    		thread01.interrupt();
    		
    		thread01.throwErrorOrExceptionIfThrown();
    		
    		fail();
    	} catch (InterruptedException e) {
    		/* NOP */ 
    	} catch (Exception ex) {
    		fail();
    	}
    }


    /**
     * offer(E o, long timeout, TimeUnit unit) ̃eXg
     * nF w肳ꂽvf̃L[̖ɑ}iԒʂɂȂĂ邱Ɓj + n̍ۂ return true
     */
    @Test
    public void testOffer003() throws Exception {
    	int capacity = 3;
    	
    	long timeout = 15;
    	TimeUnit unit = TimeUnit.SECONDS;
    	DataValueObject obj1 = new DataValueObject("hoge1");
    	DataValueObject obj2 = new DataValueObject("hoge2");
    	boolean result1;
    	boolean result2;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
		result1 = queue.offer(obj1, timeout, unit);
		result2 = queue.offer(obj2, timeout, unit);
		
		assertTrue(result1);
		assertEquals(obj1.getValue(), queue.poll(timeout, unit).getValue());
		assertTrue(result2);
		assertEquals(obj2.getValue(), queue.poll(timeout, unit).getValue());
    }

    /**
     * offer(E o, long timeout, TimeUnit unit) ̃eXg
     * nF bN܂܃^CAEgꍇ
     */
    @Test
    public void testOffer004() throws Exception{
    	int capacity = 1;
    	
    	long timeout = 50;
    	TimeUnit unit = TimeUnit.MILLISECONDS;
    	DataValueObject obj1 = new DataValueObject("hoge1");
    	DataValueObject obj2 = new DataValueObject("hoge2");
    	boolean result2;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
		// L[ςɂ
		queue.offer(obj1, timeout, unit);
		
		// L[ɓ悤Ƃi^CAEgɂȂ܂ő҂AfalseԂj
		long timeStart = System.currentTimeMillis();
		result2 = queue.offer(obj2, timeout, unit);
		long timeEnd = System.currentTimeMillis();
		long timeDiff = timeEnd - timeStart;
		
		if (timeDiff < timeout) {
			fail();
		}
		assertFalse(result2);
		assertEquals(obj1.getValue(), queue.poll(timeout, unit).getValue());
		assertNull(queue.poll(timeout, unit));
    }
    
    /**
     * offer(E o, long timeout, TimeUnit unit) ̃eXg
     * nF signal ʒm̊mF
     */
    @Test
    public void testOffer005() throws Exception{
    	int capacity = 1;
    	
    	long timeout = 50;
    	TimeUnit unit = TimeUnit.MILLISECONDS;
    	DataValueObject obj1 = new DataValueObject("hoge");
    	
    	final AtomicBoolean checkflg = new AtomicBoolean();
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	// Xbhpeeksiŏ̓L[Ȃ̂ő҂j
    	Thread thread01 = new Thread() {
    		public void run() {
    			long timeStart = System.currentTimeMillis();
    			queue.peek();
    			long timeEnd = System.currentTimeMillis();
    			long timeDiff = timeEnd - timeStart;
    			
    			if (timeDiff < 100) {
    				fail();
    			}
    			checkflg.set(true);
    		}
    	};
    	thread01.start();
    	
    	Thread.sleep(100);
    	// tOmFiofferOpeekĂȂƁj
    	assertFalse(checkflg.get());
    	// L[ɗvfl߂iɂVOiopeek͂j
    	queue.offer(obj1, timeout, unit);

    	// XbhԕƑ҂
    	Thread.sleep(1000);

    	// tOmF
    	assertTrue(checkflg.get());
    }

    
    /**
     * offer(E o) ̃eXg
     * ُnF NullPointerException ̊mF
     */
    @Test
    public void testOffer006() throws Exception{
        int capacity = 1;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	try {
    		queue.offer(null);
    		fail();
    	} catch (NullPointerException e) {
    		/* NOP */
    	} catch (Exception e) {
    		fail();
    	}
		
    }
    
    /**
     * offer(E o) ̃eXg
     * nFL[̖ɗvf}邱Ƃ̊mF
     */
    @Test
    public void testOffer007() throws Exception{
    	int capacity = 3;
    	long timeout = 50;
    	TimeUnit unit = TimeUnit.MILLISECONDS;
    	
    	DataValueObject obj1 = new DataValueObject("hoge");
    	DataValueObject obj2 = new DataValueObject("fuga");
    	DataValueObject obj3 = new DataValueObject("piyo");
    	boolean result1 = false;
    	boolean result2 = false;
    	boolean result3 = false;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	result1 = queue.offer(obj1);
    	result2 = queue.offer(obj2);
    	result3 = queue.offer(obj3);
    	
    	assertTrue(result1);
    	assertTrue(result2);
    	assertTrue(result3);
    	assertEquals(obj1.getValue(), queue.poll(timeout, unit).getValue());
    	assertEquals(obj2.getValue(), queue.poll(timeout, unit).getValue());
    	assertEquals(obj3.getValue(), queue.poll(timeout, unit).getValue());
    }

    /**
     * offer(E o) ̃eXg
     * nF vfǉs̏ꍇfalseԂmF
     */
    @Test
    public void testOffer008() throws Exception{
    	int capacity = 1;
    	DataValueObject obj1 = new DataValueObject("hoge");
    	DataValueObject obj2 = new DataValueObject("fuga");
    	boolean result2 = false;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	queue.offer(obj1);
    	result2 = queue.offer(obj2);
    	
    	assertFalse(result2);
    }

    /**
     * offer(E o) ̃eXg
     * nF signal ̊mF
     */
    @Test
    public void testOffer009() throws Exception{
    	int capacity = 1;
    	
    	DataValueObject obj1 = new DataValueObject("hoge");
    	
    	final AtomicBoolean checkflg = new AtomicBoolean();
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	// Xbhpeeksiŏ̓L[Ȃ̂ő҂j
    	Thread thread01 = new Thread() {
    		public void run() {
    			long timeStart = System.currentTimeMillis();
    			queue.peek();
    			long timeEnd = System.currentTimeMillis();
    			long timeDiff = timeEnd - timeStart;
    			
    			if (timeDiff < 100) {
    				fail();
    			}
    			checkflg.set(true);
    		}
    	};
    	thread01.start();
    	
    	Thread.sleep(100);
    	// tOmFiofferOpeekĂȂƁj
    	assertFalse(checkflg.get());
    	// L[ɗvfl߂iɂVOiopeek͂j
    	queue.offer(obj1);

    	// XbhԕƑ҂
    	Thread.sleep(1000);

    	// tOmF
    	assertTrue(checkflg.get());
    }

    /**
     * put(E o) ̃eXg
     * ُnF NullPointerException ̊mF
     */
    @Test
    public void testPut001() throws Exception{
    	int capacity = 1;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	try {
    		queue.put(null);
    		fail();
    	} catch (NullPointerException e) {
    		/* NOP */
    	} catch (Exception e) {
    		fail();
    	}
    }

    /**
     * put(E o) ̃eXg
     * ُnF InterruptedException ̊mF
     */
    @Test
    public void testPut002() throws Exception{
    	int capacity = 1;
    	
    	DataValueObject obj1 = new DataValueObject("hoge1");
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	try {
    		// L[ςɂ
    		queue.put(obj1);
    		    		
    		// ʃXbhputsiL[ςȂ̂ő҂ɂȂj
            ErrorFeedBackThread thread01 = new ErrorFeedBackThread() {
            	@Override
            	public void doRun() throws Exception {
    				DataValueObject obj2 = new DataValueObject("hoge2");
            		
    				// ҂Ԃ
    				long timeStart = System.currentTimeMillis();
    				queue.put(obj2);
    				long timeEnd = System.currentTimeMillis();
    				long timeDiff = timeEnd - timeStart;
    				if(timeDiff < 100) {
    					fail();
    				}
            	}
            };
            
    		thread01.start();

    		Thread.sleep(100);
    		
    		// 荞
    		thread01.interrupt();
    		
    		thread01.throwErrorOrExceptionIfThrown();
    		
    		fail();
    	} catch (InterruptedException e) {
    		/* NOP */ 
    	} catch (Exception ex) {
    		fail();
    	}
    }

    /**
     * put(E o) ̃eXg
     * nF w肳ꂽvf̃L[̖ɒǉ邱Ƃ̊mF
     */
    @Test
    public void testPut003() throws Exception{
    	int capacity = 3;
    	long timeout = 50;
    	TimeUnit unit = TimeUnit.MILLISECONDS;
    	
    	DataValueObject obj1 = new DataValueObject("hoge");
    	DataValueObject obj2 = new DataValueObject("fuga");
    	DataValueObject obj3 = new DataValueObject("piyo");
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	queue.put(obj1);
    	queue.put(obj2);
    	queue.put(obj3);
    	
    	assertEquals(obj1.getValue(), queue.poll(timeout, unit).getValue());
    	assertEquals(obj2.getValue(), queue.poll(timeout, unit).getValue());
    	assertEquals(obj3.getValue(), queue.poll(timeout, unit).getValue());

    }

    /**
     * put(E o)̃eXg
     * nFԂp\ɂȂ܂őҋ@Ăvfǉ邱Ƃ̊mF
     */
    @Test
    public void testPut004() throws Exception {
    	int capacity = 1;
    	long timeout = 50;
    	TimeUnit unit = TimeUnit.MILLISECONDS;
    	
    	final AtomicBoolean checkflg = new AtomicBoolean();
    	
    	DataValueObject obj1 = new DataValueObject("hoge");
    	final DataValueObject obj2 = new DataValueObject("fuga");
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	queue.put(obj1);
    	
    	Thread thread01 = new Thread() {
    		public void run() {
    			long timeStart = System.currentTimeMillis();
    			try {
					queue.put(obj2);	// L[󂭂܂ő҂Ăs
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
    			long timeEnd = System.currentTimeMillis();
    			long timeDiff = timeEnd - timeStart;
    			if(timeDiff < 100) {
    				fail();
    			}
    			checkflg.set(true);
    		}
    	};
    	thread01.start();
    	Thread.sleep(100); // Xbhn߂ʂ܂łƑ҂
    	// tOmFipollOputĂȂƁj
    	assertFalse(checkflg.get());
    	queue.poll(timeout, unit);
    	Thread.sleep(1000);
    	
    	assertTrue(checkflg.get());
   		assertEquals(obj2.getValue(), queue.poll(timeout, unit).getValue());
    	
    }
    
    /**
     * put(E o) ̃eXg
     * nF signal̊mF
     */
    @Test
    public void testPut005() throws Exception{
    	int capacity = 1;
    	
    	DataValueObject obj1 = new DataValueObject("hoge");
    	
    	final AtomicBoolean checkflg = new AtomicBoolean();
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	// Xbhpeeksiŏ̓L[Ȃ̂ő҂j
    	Thread thread01 = new Thread() {
    		public void run() {
    			long timeStart = System.currentTimeMillis();
    			queue.peek();
    			long timeEnd = System.currentTimeMillis();
    			long timeDiff = timeEnd - timeStart;
    			
    			if (timeDiff < 100) {
    				fail();
    			}
    			checkflg.set(true);
    		}
    	};
    	thread01.start();
    	
    	// L[ɗvfl߂iɂVOiopeek͂j
    	Thread.sleep(100);
    	// tOmFiputOpeekĂȂƁj
    	assertFalse(checkflg.get());
    	queue.put(obj1);

    	// XbhԕƑ҂
    	Thread.sleep(1000);

    	// tOmF
    	assertTrue(checkflg.get());
    }

    /**
     * peek() ̃eXg
     * nFL[̐擪擾邪폜ȂmF
     */
    @Test
    public void testPeek001() throws Exception{
    	int capacity = 3;
    	long timeout = 50;
    	TimeUnit unit = TimeUnit.MILLISECONDS;
    	
    	DataValueObject obj1 = new DataValueObject("hoge");
    	DataValueObject obj2 = new DataValueObject("fuga");
    	DataValueObject obj3 = new DataValueObject("piyo");
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	queue.put(obj1);
    	queue.put(obj2);
    	queue.put(obj3);

    	assertEquals(obj1.getValue(), queue.peek().getValue());
    	
    	assertEquals(obj1.getValue(), queue.poll(timeout, unit).getValue());
    	assertEquals(obj2.getValue(), queue.poll(timeout, unit).getValue());
    	assertEquals(obj3.getValue(), queue.poll(timeout, unit).getValue());
    }

    /**
     * peek() ̃eXg
     * nFL[̏ꍇAL[ɗvf̂҂mF
     */
    @Test
    public void testPeek002() throws Exception{
    	int capacity = 1;
    	final long waittime = 1000;
    	
    	final DataValueObject obj1 = new DataValueObject("hoge");
		
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	Thread thread01 = new Thread() {
    		@Override
    		public void run() {
    			try {
					sleep(waittime);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
    			queue.add(obj1);
    		}
    	};
    	
    	// L[ł邱Ƃ̊mF
    	assertEquals(0, queue.size());

    	thread01.start();
    	
    	long timeStart = System.currentTimeMillis(); 
    	// ʃXbhŃL[֗vfǉȂpeek()͂܂ł҂
    	DataValueObject objPeek = queue.peek();
    	long timeEnd = System.currentTimeMillis();
    	long timeDiff = timeEnd - timeStart;
    	
    	// L[ɗvf̂҂ƂmF
    	if(timeDiff < waittime) {
    		fail();
    	}
    	// L[̗vfǉĂ邱Ƃ̊mF
    	assertEquals(obj1.getValue(), objPeek.getValue());
    	
    }
    
    /**
     * peek() ̃eXg
     * nFL[̏ꍇAL[CȌIʒm҂mF
     */
    @Test
    public void testPeek003() throws Exception{
    	int capacity = 1;
    	final long waittime = 1000;
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	Thread thread01 = new Thread() {
    		@Override
    		public void run() {
    			try {
					sleep(waittime);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
    			queue.finishQueueing();
    		}
    	};
    	
    	// L[ł邱Ƃ̊mF
    	assertEquals(0, queue.size());

    	thread01.start();
    	
    	// ʃXbhŃL[COIʒmȂpeek()͂܂ł҂
    	// L[̗vfǉĂȂꍇnullԂ
    	long timeStart = System.currentTimeMillis();
    	DataValueObject objPeek = queue.peek();
    	long timeEnd = System.currentTimeMillis();
    	long timeDiff = timeEnd - timeStart;
    	
    	// L[COI܂ő҂ƂmF
    	if(timeDiff < waittime) {
    		fail();
    	}
    	// PeeǩʂNULLł邱ƂmF
    	assertNull(objPeek);
    }
    
    /**
     * peek() ̃eXg
     * ُnFL[őҋ@Ă鎞InterruptedExeceptionꍇnullԂmF
     */
    @Test
    public void testPeek004() throws Exception {
    	int capacity = 1;
    	final long sleeptime = 200;
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);

    	// ʃXbhpeeksiL[Ȃ̂ő҂ɂȂj
        ErrorFeedBackThread thread01 = new ErrorFeedBackThread() {
          	@Override
           	public void doRun() throws Exception {
          		// ҂Ԃ
    			long timeStart = System.currentTimeMillis();
    			DataValueObject result = queue.peek();
    			long timeEnd = System.currentTimeMillis();
    			// result̊mF
    			assertNull(result);
    			// Ԃ̊mFiinterruptɂďIj
    			long timeDiff = timeEnd - timeStart;
    			if(timeDiff < sleeptime) {
    				fail();
    			}
            }
        };
        
    	thread01.start();

    	// ҂
    	Thread.sleep(sleeptime);
    	
    	// 荞
    	thread01.interrupt();
    	
    	thread01.throwErrorOrExceptionIfThrown();
    }

    /**
     * isEmpty() ̃eXg
     * nFL[̗vfȂꍇtrueԂmFiҋ@ʗvfȂj
     */
    @Test
    public void testIsEmpty001() throws Exception {
    	int capacity = 1;
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	Thread thread01 = new Thread() {
    		@Override
    		public void run() {
    			try {
					sleep(2000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
    			queue.finishQueueing();
    		}
    	};
    	
    	thread01.start();
    	
    	// ʃXbhŃL[COIʒmstrueԂ
    	assertTrue(queue.isEmpty());
    }
    
    /**
     * isEmpty() ̃eXg
     * nFL[̗vfꍇfalseԂmFiҋ@ɗvfǉj
     */
    @Test
    public void testIsEmpty002() throws Exception {
    	int capacity = 1;
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	Thread thread01 = new Thread() {
    		@Override
    		public void run() {
    			try {
					sleep(2000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
    			DataValueObject obj1 = new DataValueObject("hoge");
    			queue.add(obj1);
    		}
    	};
    	
    	thread01.start();
    	
    	// ʃXbhŃL[COIʒmstrueԂ
    	assertFalse(queue.isEmpty());
    	
    }

    /**
     * isEmpty() ̃eXg
     * nFL[̗vfꍇfalseԂmFiŏvfj
     */
    @Test
    public void testIsEmpty003() throws Exception {
    	int capacity = 1;
		DataValueObject obj1 = new DataValueObject("hoge");
		    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	queue.add(obj1);
    	
    	assertFalse(queue.isEmpty());
    	
    }

    /**
     * isEmpty() ̃eXg
     * nFL[̗vfȂꍇtrueԂmFiҋ@Ȃj
     */
    @Test
    public void testIsEmpty004() throws Exception {
    	int capacity = 1;
    	
    	ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	queue.finishQueueing();
    	
    	assertTrue(queue.isEmpty());
    }

    /**
     * isEmpty() ̃eXg
     * ُnFL[őҋ@Ă鎞InterruptedExeceptionꍇtrueԂmF
     */
    @Test
    public void testIsEmpty005() throws Exception {
    	int capacity = 1;
    	final long sleeptime = 200;
    	
    	final ArrayBlockingQueueEx<DataValueObject> queue = new ArrayBlockingQueueEx<DataValueObject>(capacity);
    	
    	// ʃXbhisEmptysiL[Ȃ̂ő҂ɂȂj
        ErrorFeedBackThread thread01 = new ErrorFeedBackThread() {
           	@Override
           	public void doRun() throws Exception {
    			// ҂Ԃ
    			long timeStart = System.currentTimeMillis();
    			boolean result = queue.isEmpty();
    			long timeEnd = System.currentTimeMillis();
    			// result̊mF
    			assertTrue(result);
    			// Ԃ̊mFiinterruptɂďIj
    			long timeDiff = timeEnd - timeStart;
    			if(timeDiff < sleeptime) {
    				fail();
    			}
            }
        };
        
    	thread01.start();

   		// ҂
   		Thread.sleep(sleeptime);
   		
   		// 荞
   		thread01.interrupt();
   		
   		thread01.throwErrorOrExceptionIfThrown();
    }

    /**
     * G[tB[hobNłXbhB
     * ʃXbhŎ{e doRun() throws Exception ɎB
     * IAthrowErrorOrExceptionIfThrown\bhsƁA
     * doRun\bhɂđzÕG[ꍇɁÃG[X[B
     */
    abstract class ErrorFeedBackThread extends Thread {
        private Exception exception;
        private Error error;
        @Override
        public void run() {
            try {
                doRun();
            } catch (Exception e) {
                exception = e;
            } catch (Error e) {
                error = e;
            }
        }
        
        public void throwErrorOrExceptionIfThrown() throws Exception {
            join();
            if (error != null) {
                throw error;
            } else if (exception != null) {
                throw exception;
            }
        }
        
        abstract void doRun() throws Exception;
    }
}
