/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * bNDAOۃNXłB
 * 
 * <pre>
 * {NXpbNDAONXł
 * 
 * EҒl̐ݒiOj
 * E\bhs̈擾ij
 * 
 * s܂B
 * 
 * ݒ肵Ғl͓ŃL[ɒǉAǉԂŃ\bhsɕԂlƂĎo܂B
 * </pre>
 * 
 */
public class AbstractMockDao {
    /**
     * \bhsʂ̊ҒlێL[
     */
    protected final LinkedList<Object> results = new LinkedList<Object>();

    /**
     * \bhs̃p[^ێ郊Xg
     */
    protected final List<DaoParam> params = new ArrayList<DaoParam>();

    /**
     * ҒlL[oĕԋp܂B
     * 
     * <pre>
     * L[̏ꍇnullԋp܂B
     * Ғl{@link RuntimeException}pȌꍇA̗OX[܂B
     * </pre>
     * 
     * @return Ғl
     */
    protected Object poll() {
        Object result = results.poll();

        if (result instanceof RuntimeException) {
            throw (RuntimeException) result;
        }

        return result;
    }

    /**
     * ҒlointƂĕԋp܂B
     * 
     * <pre>
     * 肾IuWFNgIntegeroȂꍇA{@link ClassCastException}X[܂B
     * </pre>
     * 
     * @return Ғl(int)
     * @throws ClassCastException
     * @see {@link #poll()}
     */
    protected int pollInt() throws ClassCastException {
        Object result = poll();

        if (result != null && result instanceof Integer) {
            return (Integer) result;
        } else {
            throw new ClassCastException(
                    "Integer was expected but the actual was " + result);
        }
    }

    /**
     * ҒloĔzƂĕԋp܂B
     * 
     * <pre>
     * oIuWFNgzłȂꍇA{@link ClassCastException}X[܂B
     * </pre>
     * 
     * @return Ғl(z)
     * @throws ClassCastException
     * @see {@link #poll()}
     */
    protected Object[] pollArray() throws ClassCastException {
        Object result = poll();

        if (result == null || !result.getClass().isArray()) {
            throw new ClassCastException(
                    "Array was expected but the actual was " + result);
        }

        return (Object[]) result;
    }

    /**
     * ҒloăXgƂĕԋp܂B
     * 
     * <pre>
     * oIuWFNgXgłȂꍇA{@link ClassCastException}X[܂B
     * </pre>
     * 
     * @return Ғl(Xg)
     * @throws ClassCastException
     * @see {@link #poll()}
     */
    protected List<?> pollList() throws ClassCastException {
        Object result = poll();

        if (!(result instanceof List)) {
            throw new ClassCastException(
                    "java.util.List was expected but the actual was " + result);
        }

        return (List<?>) result;
    }

    /**
     * Ғloă}bvƂĕԋp܂B
     * 
     * <pre>
     * oIuWFNg}bvłȂꍇA{@link ClassCastException}X[܂B
     * </pre>
     * 
     * @return Ғl(}bv)
     * @throws ClassCastException
     * @see {@link #poll()}
     */
    @SuppressWarnings("unchecked")
    protected Map<String, Object> pollMap() throws ClassCastException {
        Object result = poll();

        if (!(result instanceof Map)) {
            throw new ClassCastException(
                    "java.util.Map was expected but the actual was " + result);
        }

        return (Map<String, Object>) result;
    }

    /**
     * Ғloă}bvzƂĕԋp܂B
     * 
     * <pre>
     * oIuWFNgzłȂꍇA{@link ClassCastException}X[܂B
     * </pre>
     * 
     * @return Ғl(}bvz)
     * @throws ClassCastException
     * @see {@link #pollArray()}
     */
    @SuppressWarnings("unchecked")
    protected Map<String, Object>[] pollMapArray() throws ClassCastException {
        return (Map<String, Object>[]) pollArray();
    }

    /**
     * Ғloă}bvXgƂĕԋp܂B
     * 
     * <pre>
     * oIuWFNgXgłȂꍇA{@link ClassCastException}X[܂B
     * </pre>
     * 
     * @return Ғl(}bvXg)
     * @throws ClassCastException
     * @see {@link #pollList()}
     */
    @SuppressWarnings("unchecked")
    protected List<Map<String, Object>> pollMapList() throws ClassCastException {
        return (List<Map<String, Object>>) pollList();
    }

    /**
     * R[obNoĎs܂B
     * 
     * <pre>
     * oIuWFNgR[obN̏ꍇAs܂B
     * ҈ʒu{@link RuntimeException}pȌꍇA̗OX[܂B
     * </pre>
     * 
     * @param args
     * @throws ClassCastException
     * @see {@link #poll()}
     */
    protected void pollAndExecuteIfCallback(Object[] args)
            throws ClassCastException {
        Object first = results.peek();
        if (first instanceof Callback) {
            ((Callback) poll()).execute(args);
        } else if (first instanceof RuntimeException) {
            poll();
        }
    }

    /**
     * \bhs̃p[^Xgɒǉ܂B
     * 
     * @param param p[^
     */
    protected void addParam(DaoParam param) {
        String methodName = null;

        StackTraceElement[] stacTraceElements = new Throwable().getStackTrace();
        if (stacTraceElements != null && stacTraceElements.length > 0) {
            // Ăяo\bh擾
            methodName = stacTraceElements[1].getMethodName();
        }
        param.setMethodName(methodName);
        params.add(param);
    }

    /**
     * ҒlL[ɒǉ܂B
     * 
     * @param result Ғl
     */
    public void addResult(Object result) {
        results.add(result);
    }

    /**
     * {@link Collection}œnꂽҒlSăL[ɒǉ܂B
     * @param results
     * @since 2.1.0
     */
    public void addResults(Collection<?> results) {
        this.results.addAll(results);
    }

    /**
     * \bhs̃p[^ێ郊Xgԋp܂B
     * 
     * @return \bhs̃p[^ێ郊Xg
     */
    public List<DaoParam> getParams() {
        return params;
    }

    /**
     * s܂B
     * 
     * <pre>
     * sʊҒlL[сAsp[^Xgɂ܂B
     * </pre>
     */
    public void clear() {
        results.clear();
        params.clear();
    }
}
