/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.message;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import jp.terasoluna.fw.message.DBMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.object.MappingSqlQuery;

public class DBMessageQuery
extends MappingSqlQuery {
    protected String rsCodeColumn = null;
    protected String rsLanguageColumn = null;
    protected String rsCountryColumn = null;
    protected String rsVariantColumn = null;
    protected String rsMessageColumn = null;
    private static Log log = LogFactory.getLog(DBMessageQuery.class);

    public DBMessageQuery(DataSource ds, String sql, String codeColumn, String languageColumn, String countryColumn, String variantColumn, String messageColumn) {
        super(ds, sql);
        this.rsCodeColumn = codeColumn;
        this.rsLanguageColumn = languageColumn;
        this.rsCountryColumn = countryColumn;
        this.rsVariantColumn = variantColumn;
        this.rsMessageColumn = messageColumn;
        this.compile();
    }

    protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        String code = null;
        String language = null;
        String country = null;
        String variant = null;
        String message = null;
        code = rs.getString(this.rsCodeColumn);
        if (code == null) {
            code = "";
            if (log.isWarnEnabled()) {
                log.warn((Object)"MessageCode is null");
            }
        }
        if (this.rsLanguageColumn != null && (language = rs.getString(this.rsLanguageColumn)) == null) {
            language = "";
        }
        if (this.rsCountryColumn != null && (country = rs.getString(this.rsCountryColumn)) == null) {
            country = "";
        }
        if (this.rsVariantColumn != null && (variant = rs.getString(this.rsVariantColumn)) == null) {
            variant = "";
        }
        if ((message = rs.getString(this.rsMessageColumn)) == null) {
            message = "";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(code + "," + language + "," + country + "," + variant + "," + message));
        }
        return new DBMessage(code, language, country, variant, message);
    }
}

