﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using TERASOLUNA.Fw.Common.Validation.Validators;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Configuration
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Validation.Configuration.HankakuKanaStringValidatorData のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Validation.Configuration.HankakuKanaStringValidatorData 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class HankakuKanaStringValidatorDataTest
    {
        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest01()
        {
            // 定義
            HankakuKanaStringValidatorData target = new HankakuKanaStringValidatorData();
            Type targetType = null;
            target.MessageTemplate = "メッセージテンプレート";
            target.Negated = false;
            target.Tag = "検証対象項目";

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(HankakuKanaStringValidator), "型が不正です");
            HankakuKanaStringValidator hksv = result as HankakuKanaStringValidator;
            Assert.AreEqual<string>(hksv.MessageTemplate, "メッセージテンプレート");
            Assert.IsNotNull(hksv.Tag, "Tagが不正です");
            Assert.IsFalse(hksv.Negated, "Negatedが不正です.");

            // 追加テスト 生成されたValidatorが正しいか実施
            ValidationResults results;
            results = hksv.Validate(null);
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("");
            Assert.IsTrue(results.IsValid);

            results = hksv.Validate("ｱｲｳｴｵ");
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("ｱｲｳｴｵア");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("あいうえお");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("Abc");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate(" ");
            Assert.IsFalse(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(HankakuKanaStringValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のTypeが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest02()
        {
            // 定義
            HankakuKanaStringValidatorData target = new HankakuKanaStringValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);
            target.MessageTemplate = "メッセージテンプレート";
            target.Negated = false;
            target.Tag = "検証対象項目";

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(HankakuKanaStringValidator), "型が不正です");
            HankakuKanaStringValidator hksv = result as HankakuKanaStringValidator;
            Assert.AreEqual<string>(hksv.MessageTemplate, "メッセージテンプレート");
            Assert.IsNotNull(hksv.Tag, "Tagが不正です");
            Assert.IsFalse(hksv.Negated, "Negatedが不正です.");

            // 追加テスト 生成されたValidatorが正しいか実施
            ValidationResults results;
            results = hksv.Validate(null);
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("");
            Assert.IsTrue(results.IsValid);

            results = hksv.Validate("ｱｲｳｴｵ");
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("ｱｲｳｴｵア");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("あいうえお");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("Abc");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate(" ");
            Assert.IsFalse(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(HankakuKanaStringValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのMessageTemplateが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest03()
        {
            // 定義
            HankakuKanaStringValidatorData target = new HankakuKanaStringValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = "検証対象項目";

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(HankakuKanaStringValidator), "型が不正です");
            HankakuKanaStringValidator hksv = result as HankakuKanaStringValidator;
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("HANKAKUKANA_STRING_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, hksv.MessageTemplate);
            Assert.IsNotNull(hksv.Tag, "Tagが不正です");
            Assert.IsFalse(hksv.Negated, "Negatedが不正です.");

            // 追加テスト 生成されたValidatorが正しいか実施
            ValidationResults results;
            results = hksv.Validate(null);
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("");
            Assert.IsTrue(results.IsValid);

            results = hksv.Validate("ｱｲｳｴｵ");
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("ｱｲｳｴｵア");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("あいうえお");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("Abc");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate(" ");
            Assert.IsFalse(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(HankakuKanaStringValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのNegatedがtrueの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest04()
        {
            // 定義
            HankakuKanaStringValidatorData target = new HankakuKanaStringValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);
            target.MessageTemplate = "メッセージテンプレート";
            target.Negated = true;
            target.Tag = "検証対象項目";

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(HankakuKanaStringValidator), "型が不正です");
            HankakuKanaStringValidator hksv = result as HankakuKanaStringValidator;
            Assert.AreEqual<string>(hksv.MessageTemplate, "メッセージテンプレート");
            Assert.IsNotNull(hksv.Tag, "Tagが不正です");
            Assert.IsTrue(hksv.Negated, "Negatedが不正です.");

            // 追加テスト 生成されたValidatorが正しいか実施
            ValidationResults results;
            results = hksv.Validate(null);
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("");
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("ｱｲｳｴｵ");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("ｱｲｳｴｵア");
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("あいうえお");
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("Abc");
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate(" ");
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(HankakuKanaStringValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのTagがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest05()
        {
            // 定義
            HankakuKanaStringValidatorData target = new HankakuKanaStringValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);
            target.MessageTemplate = "メッセージテンプレート";
            target.Negated = false;
            target.Tag = null;

            // 準備
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_HankakuKanaStringValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(HankakuKanaStringValidator), "型が不正です");
            HankakuKanaStringValidator hksv = result as HankakuKanaStringValidator;
            Assert.AreEqual<string>(hksv.MessageTemplate, "メッセージテンプレート");
            Assert.IsNull(hksv.Tag, "Tagが不正です");
            Assert.IsFalse(hksv.Negated, "Negatedが不正です.");

            // 追加テスト 生成されたValidatorが正しいか実施
            ValidationResults results;
            results = hksv.Validate(null);
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("");
            Assert.IsTrue(results.IsValid);

            results = hksv.Validate("ｱｲｳｴｵ");
            Assert.IsTrue(results.IsValid);
            results = hksv.Validate("ｱｲｳｴｵア");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("あいうえお");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate("Abc");
            Assert.IsFalse(results.IsValid);
            results = hksv.Validate(" ");
            Assert.IsFalse(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(HankakuKanaStringValidatorData), LogLevel.INFO));
        }
    }
}
