﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Logging.TraceSourceLog;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common;
using System.Diagnostics;
using System.Text.RegularExpressions;
using System.Reflection;
using System.IO;
namespace TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog
{
    /// <summary>
    /// TraceSourceLogger のテストクラスです。
    /// </summary>
    [TestClass()]
    public class TraceSourceLoggerTest
    {
        /// <summary>
        /// ログの出力結果を確認するための正規表現です。
        /// </summary>
        Regex _regexNoException = new Regex(@"(?<1>\w+)\s.*\(\w+\) - (?<2>.*) (?<3>.*)");
        
        /// <summary>
        /// ログの出力結果を確認するための正規表現です。
        /// </summary>
        /// <remarks>
        /// メッセージに例外が含まれる場合にこちらを用います。
        /// </remarks>
        Regex _regexException  = new Regex(@"(?<1>\w+)\s.*\(\w+\) - (?<2>.*) <(?<3>.*)>");

        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        #region コンストラクタ TraceSourceLogger (string, string) のテスト

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest01()
        {
            // 準備
            string className = null;
            string sourceName = "sourceName";

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(className, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: className", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が空文字列の場合、
        /// ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest02()
        {
            // 準備
            string className = string.Empty;
            string sourceName = "sourceName";

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(className, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual("引数 \"className\" の値を空文字列にすることはできません。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className と sourceName は正しい値だが、
        /// 構成ファイルに記述する TraceSource の設定が不正な場合、
        /// ConfigurationErrorsException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest03()
        {
            // 準備
            string className = "sourceName";
            string sourceName = "LogLevelIllegal";

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(className, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                Assert.AreEqual("クラス System.Diagnostics.IllegalSwitch の型が見つかりませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の sourceName が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest04()
        {
            // 準備
            string className = "className";
            string sourceName = null;

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(className, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: sourceName", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の sourceName が空文字列の場合、
        /// ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest05()
        {
            // 準備
            string className = "className";
            string sourceName = string.Empty;

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(className, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual("引数 \"sourceName\" の値を空文字列にすることはできません。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Off の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest06()
        {
            // 準備
            string className = "className";
            string sourceName = "LogLevelOff";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(className, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual("className", accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.OFF, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Critical の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest07()
        {
            // 準備
            string className = "className";
            string sourceName = "LogLevelCritical";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(className, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual("className", accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.FATAL, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Error の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest08()
        {
            // 準備
            string className = "className";
            string sourceName = "LogLevelError";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(className, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual("className", accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.ERROR,accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Warning の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest09()
        {
            // 準備
            string className = "className";
            string sourceName = "LogLevelWarning";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(className, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual("className", accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.WARN, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Information の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest10()
        {
            // 準備
            string className = "className";
            string sourceName = "LogLevelInformation";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(className, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual("className", accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.INFO, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Verbose の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest11()
        {
            // 準備
            string className = "className";
            string sourceName = "LogLevelVerbose";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(className, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual("className", accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.DEBUG, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が All の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest12()
        {
            // 準備
            string className = "className";
            string sourceName = "LogLevelAll";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(className, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual("className", accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.TRACE, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が ActivityTracing の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest13()
        {
            // 準備
            string className = "className";
            string sourceName = "LogLevelActivityTracing";

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(className, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("引数 \"sourceLevel\" が不正です。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されいない場合、
        /// TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest14()
        {
            // 準備
            string className = "className";
            string sourceName = "sourceName";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(className, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual("className", accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.OFF, accessor._logLevel);
        }

        #endregion

        #region コンストラクタ TraceSourceLogger (Type, string) のテスト

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest01()
        {
            // 準備
            Type classType = null;
            string sourceName = "sourceName";

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: classType", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType と sourceName は正しい値だが、
        /// 構成ファイルに記述する TraceSource の設定が不正な場合、
        /// ConfigurationErrorsException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest02()
        {
            // 準備
            Type classType = typeof(TraceSourceLoggerTest);
            string sourceName = "LogLevelIllegal";

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                Assert.AreEqual("クラス System.Diagnostics.IllegalSwitch の型が見つかりませんでした。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の sourceName が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest03()
        {
            // 準備
            Type classType = typeof(TraceSourceLoggerTest);
            string sourceName = null;

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: sourceName", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の sourceName が空文字列の場合、
        /// ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest04()
        {
            // 準備
            Type classType = typeof(TraceSourceLoggerTest);
            string sourceName = string.Empty;

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual("引数 \"sourceName\" の値を空文字列にすることはできません。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Off の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest05()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "LogLevelOff";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual(typeof(Object).FullName, accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.OFF, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Critical の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest06()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "LogLevelCritical";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual(typeof(Object).FullName, accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.FATAL, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Error の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest07()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "LogLevelError";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual(typeof(Object).FullName, accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.ERROR, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Warning の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest08()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "LogLevelWarning";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual(typeof(Object).FullName, accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.WARN, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Information の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest09()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "LogLevelInformation";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual(typeof(Object).FullName, accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.INFO, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が Verbose の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest10()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "LogLevelVerbose";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual(typeof(Object).FullName, accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.DEBUG, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が All の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest11()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "LogLevelAll";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual(typeof(Object).FullName, accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.TRACE, accessor._logLevel);
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されており、
        /// ログレベルの閾値が ActivityTracing の場合、TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest12()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "LogLevelActivityTracing";

            try
            {
                // 実施
                TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual("引数 \"sourceLevel\" が不正です。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// TraceSourceLogger (Type, string) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに sourceName に対応する source が設定されいない場合、
        /// TraceSourceLogger が正しく生成され、
        /// フィールドの値が正しく設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTypeStringTest13()
        {
            // 準備
            Type classType = typeof(Object);
            string sourceName = "sourceName";

            // 実施
            TraceSourceLogger target = new TraceSourceLogger(classType, sourceName);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            // 確認
            Assert.AreEqual(typeof(Object).FullName, accessor._className);
            Assert.IsNotNull(accessor._traceSource);
            Assert.AreEqual(LogLevel.OFF, accessor._logLevel);
        }

        #endregion

        #region Fatal のテスト

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest01()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);
            
            object message = null;
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest02()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest03()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = new Exception();
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("System.Exception - 種類 'System.Exception' の例外がスローされました。", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が -1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest04()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = -1;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(-1, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が 1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest05()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 1;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(1, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest06()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelOff");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest07()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelCritical");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest08()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelError");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest09()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelWarning");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest10()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelInformation");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest11()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelVerbose");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が1つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest12()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            int eventId = 0;

            // 実施
            target.Fatal(message, ex02, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);
            
            StringReader sr = new StringReader(listener._message);
            
            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message02", match.Groups[3].Value);
            
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Fatal (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が3つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionIntTest13()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            Exception ex03 = new TraceSourceLogger_ExceptionStub01("message03", ex02, "stackTrace03");
            Exception ex04 = new TraceSourceLogger_ExceptionStub01("message04", ex03, "stackTrace04");
            int eventId = 0;

            // 実施
            target.Fatal(message, ex04, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("FATAL", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message04", match.Groups[3].Value);
            
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message04", sr.ReadLine());
            Assert.AreEqual("stackTrace04", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message03", sr.ReadLine());
            Assert.AreEqual("stackTrace03", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Fatal (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = null;

            // 実施
            target.Fatal(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";

            // 実施
            target.Fatal(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";

            // 実施
            target.Fatal(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectIntTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = null;
            int eventId = 0;

            // 実施
            target.Fatal(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectIntTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Fatal(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が -1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectIntTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";
            int eventId = -1;

            // 実施
            target.Fatal(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(-1, target._eventId);
        }

        /// <summary>
        /// Fatal (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectIntTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";
            int eventId = 1;

            // 実施
            target.Fatal(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(1, target._eventId);
        }

        /// <summary>
        /// Fatal (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectIntTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Fatal(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = null;
            Exception exception = null;

            // 実施
            target.Fatal(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Fatal(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が not null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";
            Exception exception = new Exception();

            // 実施
            target.Fatal(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.FATAL, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNotNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Fatal (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void FatalObjectExceptionTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Fatal(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        #endregion

        #region Error のテスト

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest01()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);
            
            object message = null;
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest02()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest03()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = new Exception();
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("System.Exception - 種類 'System.Exception' の例外がスローされました。", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が -1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest04()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = -1;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(-1, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が 1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest05()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 1;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(1, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest06()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelOff");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest07()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelCritical");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest08()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelError");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest09()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelWarning");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest10()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelInformation");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest11()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelVerbose");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Error(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が1つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest12()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            int eventId = 0;

            // 実施
            target.Error(message, ex02, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message02", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Error (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が3つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionIntTest13()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            Exception ex03 = new TraceSourceLogger_ExceptionStub01("message03", ex02, "stackTrace03");
            Exception ex04 = new TraceSourceLogger_ExceptionStub01("message04", ex03, "stackTrace04");
            int eventId = 0;

            // 実施
            target.Error(message, ex04, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("ERROR", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message04", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message04", sr.ReadLine());
            Assert.AreEqual("stackTrace04", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message03", sr.ReadLine());
            Assert.AreEqual("stackTrace03", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Error (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = null;

            // 実施
            target.Error(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";

            // 実施
            target.Error(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";

            // 実施
            target.Error(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";

            // 実施
            target.Error(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectIntTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = null;
            int eventId = 0;

            // 実施
            target.Error(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectIntTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Error(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が -1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectIntTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";
            int eventId = -1;

            // 実施
            target.Error(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(-1, target._eventId);
        }

        /// <summary>
        /// Error (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectIntTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";
            int eventId = 1;

            // 実施
            target.Error(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(1, target._eventId);
        }

        /// <summary>
        /// Error (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectIntTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Error(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectIntTest06()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Error(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = null;
            Exception exception = null;

            // 実施
            target.Error(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Error(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が not null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";
            Exception exception = new Exception();

            // 実施
            target.Error(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.ERROR, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNotNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Error(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Error (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ErrorObjectExceptionTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelCritical");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Error(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        #endregion

        #region Warn のテスト

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest01()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = null;
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest02()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest03()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = new Exception();
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Match match = _regexException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("System.Exception - 種類 'System.Exception' の例外がスローされました。", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が -1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest04()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = -1;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(-1, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が 1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest05()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 1;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(1, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest06()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelOff");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest07()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelCritical");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest08()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelError");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest09()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelWarning");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest10()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelInformation");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest11()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelVerbose");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Warn(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が1つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest12()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            int eventId = 0;

            // 実施
            target.Warn(message, ex02, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message02", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Warn (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が3つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionIntTest13()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            Exception ex03 = new TraceSourceLogger_ExceptionStub01("message03", ex02, "stackTrace03");
            Exception ex04 = new TraceSourceLogger_ExceptionStub01("message04", ex03, "stackTrace04");
            int eventId = 0;

            // 実施
            target.Warn(message, ex04, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("WARN", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message04", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message04", sr.ReadLine());
            Assert.AreEqual("stackTrace04", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message03", sr.ReadLine());
            Assert.AreEqual("stackTrace03", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Warn (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = null;

            // 実施
            target.Warn(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";

            // 実施
            target.Warn(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";

            // 実施
            target.Warn(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";

            // 実施
            target.Warn(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectIntTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = null;
            int eventId = 0;

            // 実施
            target.Warn(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectIntTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Warn(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が -1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectIntTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";
            int eventId = -1;

            // 実施
            target.Warn(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(-1, target._eventId);
        }

        /// <summary>
        /// Warn (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectIntTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";
            int eventId = 1;

            // 実施
            target.Warn(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(1, target._eventId);
        }

        /// <summary>
        /// Warn (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectIntTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Warn(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectIntTest06()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Warn(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = null;
            Exception exception = null;

            // 実施
            target.Warn(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Warn(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が not null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";
            Exception exception = new Exception();

            // 実施
            target.Warn(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.WARN, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNotNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Warn(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Warn (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void WarnObjectExceptionTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelError");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Warn(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        #endregion

        #region Info のテスト

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest01()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = null;
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest02()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest03()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = new Exception();
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Match match = _regexException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("System.Exception - 種類 'System.Exception' の例外がスローされました。", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が -1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest04()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = -1;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(-1, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が 1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest05()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 1;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(1, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest06()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelOff");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest07()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelCritical");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest08()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelError");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest09()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelWarning");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest10()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelInformation");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest11()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelVerbose");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Info(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が1つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest12()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            int eventId = 0;

            // 実施
            target.Info(message, ex02, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message02", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Info (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が3つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionIntTest13()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            Exception ex03 = new TraceSourceLogger_ExceptionStub01("message03", ex02, "stackTrace03");
            Exception ex04 = new TraceSourceLogger_ExceptionStub01("message04", ex03, "stackTrace04");
            int eventId = 0;

            // 実施
            target.Info(message, ex04, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("INFO", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message04", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message04", sr.ReadLine());
            Assert.AreEqual("stackTrace04", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message03", sr.ReadLine());
            Assert.AreEqual("stackTrace03", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Info (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = null;

            // 実施
            target.Info(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";

            // 実施
            target.Info(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";

            // 実施
            target.Info(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";

            // 実施
            target.Info(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectIntTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = null;
            int eventId = 0;

            // 実施
            target.Info(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectIntTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Info(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が -1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectIntTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";
            int eventId = -1;

            // 実施
            target.Info(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(-1, target._eventId);
        }

        /// <summary>
        /// Info (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectIntTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";
            int eventId = 1;

            // 実施
            target.Info(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(1, target._eventId);
        }

        /// <summary>
        /// Info (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectIntTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Info(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectIntTest06()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Info(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = null;
            Exception exception = null;

            // 実施
            target.Info(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Info(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が not null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";
            Exception exception = new Exception();

            // 実施
            target.Info(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.INFO, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNotNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Info(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Info (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void InfoObjectExceptionTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelWarning");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Info(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        #endregion

        #region Debug のテスト

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest01()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = null;
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("DEBUG", match.Groups[1].Value);
            Assert.AreEqual("", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest02()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("DEBUG", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest03()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = new Exception();
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Match match = _regexException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("DEBUG", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("System.Exception - 種類 'System.Exception' の例外がスローされました。", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が -1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest04()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = -1;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("DEBUG", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(-1, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が 1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest05()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 1;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("DEBUG", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(1, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest06()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelOff");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest07()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelCritical");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest08()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelError");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest09()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelWarning");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest10()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelInformation");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest11()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelVerbose");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Debug(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("DEBUG", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が1つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest12()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            int eventId = 0;

            // 実施
            target.Debug(message, ex02, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("DEBUG", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message02", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Debug (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が3つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionIntTest13()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            Exception ex03 = new TraceSourceLogger_ExceptionStub01("message03", ex02, "stackTrace03");
            Exception ex04 = new TraceSourceLogger_ExceptionStub01("message04", ex03, "stackTrace04");
            int eventId = 0;

            // 実施
            target.Debug(message, ex04, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("DEBUG", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message04", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message04", sr.ReadLine());
            Assert.AreEqual("stackTrace04", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message03", sr.ReadLine());
            Assert.AreEqual("stackTrace03", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Debug (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = null;

            // 実施
            target.Debug(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";

            // 実施
            target.Debug(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";

            // 実施
            target.Debug(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";

            // 実施
            target.Debug(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectIntTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = null;
            int eventId = 0;

            // 実施
            target.Debug(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectIntTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Debug(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が -1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectIntTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";
            int eventId = -1;

            // 実施
            target.Debug(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(-1, target._eventId);
        }

        /// <summary>
        /// Debug (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectIntTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";
            int eventId = 1;

            // 実施
            target.Debug(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(1, target._eventId);
        }

        /// <summary>
        /// Debug (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectIntTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Debug(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectIntTest06()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Debug(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = null;
            Exception exception = null;

            // 実施
            target.Debug(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Debug(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が not null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";
            Exception exception = new Exception();

            // 実施
            target.Debug(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.DEBUG, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNotNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Debug(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Debug (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DebugObjectExceptionTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelInformation");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Debug(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        #endregion

        #region Trace のテスト

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest01()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = null;
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("TRACE", match.Groups[1].Value);
            Assert.AreEqual("", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest02()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("TRACE", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でない場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest03()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = new Exception();
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Match match = _regexException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("TRACE", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("System.Exception - 種類 'System.Exception' の例外がスローされました。", match.Groups[3].Value);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が -1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest04()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = -1;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("TRACE", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(-1, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の eventId が 1 の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest05()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 1;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Match match = _regexNoException.Match(listener._message);
            Assert.IsTrue(listener._flag);
            Assert.AreEqual("TRACE", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("", match.Groups[3].Value);
            Assert.AreEqual(1, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest06()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelOff");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Critical の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest07()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelCritical");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Error の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest08()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelError");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Warning の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest09()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelWarning");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Information の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest10()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelInformation");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれず、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest11()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelVerbose");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";
            Exception ex = null;
            int eventId = 0;

            // 実施
            target.Trace(message, ex, eventId);

            // 確認
            Assert.IsFalse(listener._flag);
            Assert.IsNull(listener._message);
            Assert.AreEqual(0, listener._id);
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が1つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest12()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            int eventId = 0;

            // 実施
            target.Trace(message, ex02, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("TRACE", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message02", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Trace (object, Exception, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の ex が null でなく、InnerExeption が3つの場合、
        /// TraceSourceLogger_TraceListenerStub01.TraceEvent メソッドが呼ばれ、
        /// TraceSourceLogger_TraceListenerStub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionIntTest13()
        {
            // 準備
            TraceSourceLogger target = new TraceSourceLogger("className", "LogLevelAll");

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(target);

            TraceSourceLogger_TraceListenerStub01 listener = new TraceSourceLogger_TraceListenerStub01();
            accessor._traceSource.Listeners.Add(listener);

            object message = "TERASOLUNA";

            Exception ex01 = new TraceSourceLogger_ExceptionStub01("message01", "stackTrace01");
            Exception ex02 = new TraceSourceLogger_ExceptionStub01("message02", ex01, "stackTrace02");
            Exception ex03 = new TraceSourceLogger_ExceptionStub01("message03", ex02, "stackTrace03");
            Exception ex04 = new TraceSourceLogger_ExceptionStub01("message04", ex03, "stackTrace04");
            int eventId = 0;

            // 実施
            target.Trace(message, ex04, eventId);

            // 確認
            Assert.IsTrue(listener._flag);
            Assert.AreEqual(0, listener._id);

            StringReader sr = new StringReader(listener._message);

            Match match = _regexException.Match(sr.ReadLine());
            Assert.AreEqual("TRACE", match.Groups[1].Value);
            Assert.AreEqual("TERASOLUNA", match.Groups[2].Value);
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 - message04", match.Groups[3].Value);

            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message04", sr.ReadLine());
            Assert.AreEqual("stackTrace04", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message03", sr.ReadLine());
            Assert.AreEqual("stackTrace03", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message02", sr.ReadLine());
            Assert.AreEqual("stackTrace02", sr.ReadLine());
            Assert.AreEqual("TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog.TraceSourceLogger_ExceptionStub01 : message01", sr.ReadLine());
            Assert.AreEqual("stackTrace01", sr.ReadLine());
            Assert.IsNull(sr.ReadLine());
        }

        /// <summary>
        /// Trace (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = null;

            // 実施
            target.Trace(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = "TERASOLUNA";

            // 実施
            target.Trace(message);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";

            // 実施
            target.Trace(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null でなく、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";

            // 実施
            target.Trace(message);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectIntTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = null;
            int eventId = 0;

            // 実施
            target.Trace(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectIntTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Trace(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が -1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectIntTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = "TERASOLUNA";
            int eventId = -1;

            // 実施
            target.Trace(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(-1, target._eventId);
        }

        /// <summary>
        /// Trace (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 1 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectIntTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = "TERASOLUNA";
            int eventId = 1;

            // 実施
            target.Trace(message, eventId);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(1, target._eventId);
        }

        /// <summary>
        /// Trace (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectIntTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Trace(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, int) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null、eventId が 0 であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectIntTest06()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";
            int eventId = 0;

            // 実施
            target.Trace(message, eventId);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionTest01()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = null;
            Exception exception = null;

            // 実施
            target.Trace(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionTest02()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Trace(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が not null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が All の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれ、
        /// TraceSourceLogger_Stub01 のフィールドの値が期待される値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionTest03()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelAll");

            object message = "TERASOLUNA";
            Exception exception = new Exception();

            // 実施
            target.Trace(message, exception);

            // 確認
            Assert.IsTrue(target._flag);
            Assert.AreEqual(LogLevel.TRACE, target._writeLogLevel);
            Assert.AreEqual("TERASOLUNA", target._message);
            Assert.IsNotNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Off の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionTest04()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelOff");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Trace(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        /// <summary>
        /// Trace (object, Exception) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の object が not null 、Exception が null であり、
        /// 構成ファイルに設定した TraceSource のログレベルの閾値が Verbose の場合、
        /// Write(LogLevel, object, Exception, int) メソッドが呼ばれず、
        /// TraceSourceLogger_Stub01 のフィールドの値が初期値であることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void TraceObjectExceptionTest05()
        {
            // 準備
            TraceSourceLogger_Stub01 target = new TraceSourceLogger_Stub01("className", "LogLevelVerbose");

            object message = "TERASOLUNA";
            Exception exception = null;

            // 実施
            target.Trace(message, exception);

            // 確認
            Assert.IsFalse(target._flag);
            Assert.AreEqual(LogLevel.OFF, target._writeLogLevel);
            Assert.IsNull(target._message);
            Assert.IsNull(target._ex);
            Assert.AreEqual(0, target._eventId);
        }

        #endregion

        /// <summary>
        /// DefaultEventId プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void DefaultEventIdTest01()
        {
            // 準備
            TraceSourceLogger logger = new TraceSourceLogger("className", "sourceName");
            TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(logger);
            
            // 実施
            int actual = accessor.DefaultEventId;

            // 確認
            Assert.AreEqual(0, actual);
        }

        /// <summary>
        /// BodyMessageFormat プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void BodyMessageFormatTest01()
        {
            // 準備
            TraceSourceLogger logger = new TraceSourceLogger("className", "sourceName");
            TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(logger);

            // 実施
            string actual = accessor.BodyMessageFormat;

            // 確認
            Assert.AreEqual("{0} {1:yyyy-MM-dd HH:mm:ss,fff} [{2}] ({3}) - {4} ", actual);
        }

        /// <summary>
        /// ClassName プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void ClassNameTest01()
        {
            // 準備
            TraceSourceLogger logger = new TraceSourceLogger("className", "sourceName");
            TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(logger);
            string expected = "terasoluna";

            // 実施
            accessor.ClassName = expected;
            string actual = accessor.ClassName;

            // 確認
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        /// CurrentTraceSource プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void CurrentTraceSourceTest01()
        {
            // 準備
            TraceSourceLogger logger = new TraceSourceLogger("className", "sourceName");
            TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(logger);
            TraceSource expected = new TraceSource("name");

            // 実施
            accessor.CurrentTraceSource = expected;
            TraceSource actual = accessor.CurrentTraceSource;

            // 確認
            Assert.AreSame(expected, actual);
        }

        /// <summary>
        /// CurrentLogLevel プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void CurrentLogLevelTest01()
        {
            // 準備
            TraceSourceLogger logger = new TraceSourceLogger("className", "sourceName");
            TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(logger);
            LogLevel expected = LogLevel.FATAL;

            // 実施
            accessor.CurrentLogLevel = expected;
            LogLevel actual = accessor.CurrentLogLevel;

            // 確認
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        /// GetTraceEventType のテスト
        /// </summary>
        /// <remarks>
        /// 引数の logLevel が OFF の場合、
        /// TerasolunaException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetTraceEventTypeTest01()
        {
            // 準備
            TraceSourceLogger logger = new TraceSourceLogger("className", "sourceName");
            TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor accessor =
                new TERASOLUNA_Fw_Common_Logging_TraceSourceLog_TraceSourceLoggerAccessor(logger);
            LogLevel logLevel = LogLevel.OFF;

            try
            {
                // 実施
                TraceEventType eventType = accessor.GetTraceEventType(logLevel);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException ex)
            {
                //Exception objInnerException = ex.InnerException;
                Assert.IsInstanceOfType(ex, typeof(TerasolunaException));
                Assert.AreEqual("引数 \"logLevel\" が不正です。LogLevel.OFF を TraceEventType に変換することはできません。",
                                   ex.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }
    }
}
