/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_03.blogic;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.toursample.common.blogic.ReserveDetailAcquireBLogic;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireInput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireOutput;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.uc_a01_03.dto.RP_A01_03_01_01Input;
import jp.terasoluna.toursample.uc_a01_03.dto.RP_A01_03_01_01Output;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * cA[\ύX擾BLogicNXB<br>
 * 
 * EUC_A01_03FcA[\ύX
 * 
 * 
 */
public class RP_A01_03_01_01BLogicImpl implements BLogic<RP_A01_03_01_01Input> {

    /**
     * ʏsNullԋpꂽꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_RESERVED = "error.common.00008";

    /**
     * \ڍ׏擾NX(ʏCP0006)B SpringɂCX^Xݒ肳B
     */
    protected ReserveDetailAcquireBLogic reserveDetailAcquireBLogic = null;

    /**
     * ʏCP0006ݒ肷B
     * 
     * @param reserveDetailAcquireBLogic
     *            ݒ肷鋤ʏCP0006
     */
    public void setReserveDetailAcquireBLogic(
            ReserveDetailAcquireBLogic reserveDetailAcquireBLogic) {

        this.reserveDetailAcquireBLogic = reserveDetailAcquireBLogic;
    }

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A01_03_01_01BLogicImpl.class);

    /**
     * cA[\ڍ׏擾rWlXWbNB<br>
     * \ڍ׏擾NX(ʏCP0006)ŗ\擾
     * 
     * @param params
     *            F\ԍAڋqԍ
     * @return cA[\ڍ׏
     * @exception RecordNotFoundException
     *                \񂪂Ȃꍇ̗O
     */
    public BLogicResult execute(RP_A01_03_01_01Input params) {

        // o͏i[NX𐶐B
        RP_A01_03_01_01Output result = new RP_A01_03_01_01Output();

        // \ڍ׏擾̈̃NX𐶐B
        ReserveDetailAcquireInput reserveDetailAcquireInput = 
            new ReserveDetailAcquireInput();

        // \ڍ׏擾̈ݒ肷B
        reserveDetailAcquireInput.setReserveNo(params.getReserveNo());
        reserveDetailAcquireInput.setCustomerCode(params.getUSER_VALUE_OBJECT()
            .getCustomerCode());

        // \ڍ׏擾(ʏCP0006)B
        ReserveDetailAcquireOutput reserveDetail = 
            reserveDetailAcquireBLogic.execute(reserveDetailAcquireInput);
        
        // \񂪂ȂꍇAOsB
        // ONXFRecordNotFoundException
        if (reserveDetail == null) {

            if (log.isErrorEnabled()) {
                log.error(ERROR_NOT_RESERVED + ":\񂪌܂B");
            }

            throw new RecordNotFoundException(ERROR_NOT_RESERVED);
        }
        
        // cA[\ڍ׏o͒lɃZbgB
        result.setReserveDetail(reserveDetail);

        // o͒l𐶐B
        BLogicResult bResult = new BLogicResult();
        bResult.setResultObject(result);
        bResult.setResultString("success");

        return bResult;

    }

}