/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;

import java.util.Iterator;

import jp.terasoluna.fw.ex.exception.BLogicException;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BLogicExceptionHandlerTest {

    private BLogicExceptionHandler bLogicExceptionHandler;

    @Before
    public void setUp() throws Exception {
        bLogicExceptionHandler = new BLogicExceptionHandler() {
        };
    }

    @After
    public void tearDown() throws Exception {
        bLogicExceptionHandler = null;
    }

    @Test
    public final void testGetErrorsNotBLogicException() {
        Exception exception = new Exception();
        ActionMessages actionMessages = bLogicExceptionHandler.getErrors(
                exception, null, null);
        assertEquals(0, actionMessages.size());
    }

    @Test
    public final void testGetErrorsWithNullBLogicMessages() {
        BLogicException bLogicException = new BLogicException(null) {
            private static final long serialVersionUID = 4683518795232321395L;
        };
        ActionMessages actionMessages = bLogicExceptionHandler.getErrors(
                bLogicException, null, null);
        assertNull(actionMessages);
    }

    @SuppressWarnings("unchecked")
    @Test
    public final void testGetErrorsWithBLogicMessages() {
        BLogicMessages bLogicMessages = new BLogicMessages();
        bLogicMessages.add("group1", new BLogicMessage("aaa", "bbb"));
        bLogicMessages.add("group1", new BLogicMessage("This is a message.",
                false));
        bLogicMessages.add("group2", new BLogicMessage("ccc", "ddd"));
        bLogicMessages.add("group2", new BLogicMessage("This is a message2.",
                false));
        BLogicException bLogicException = new BLogicException(bLogicMessages) {
            private static final long serialVersionUID = -3314968688862346224L;
        };
        ActionMessages actionMessages = bLogicExceptionHandler.getErrors(
                bLogicException, null, null);
        assertEquals(4, actionMessages.size());
        assertEquals(2, actionMessages.size("group1"));

        Iterator<ActionMessage> group1Iterator = actionMessages.get("group1");
        ActionMessage group1Next = group1Iterator.next();
        assertEquals("aaa", group1Next.getKey());
        assertEquals(1, group1Next.getValues().length);
        assertEquals("bbb", group1Next.getValues()[0]);

        group1Next = group1Iterator.next();
        assertEquals("This is a message.", group1Next.getKey());
        assertFalse(group1Next.isResource());

        assertEquals(2, actionMessages.size("group2"));

        Iterator<ActionMessage> group2Iterator = actionMessages.get("group2");
        ActionMessage group2Next = group2Iterator.next();
        assertEquals("ccc", group2Next.getKey());
        assertEquals(1, group2Next.getValues().length);
        assertEquals("ddd", group2Next.getValues()[0]);

        group2Next = group2Iterator.next();
        assertEquals("This is a message2.", group2Next.getKey());
        assertFalse(group2Next.isResource());
    }
}
