/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import java.util.Iterator;

import jp.terasoluna.fw.ex.exception.BLogicException;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;

import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;

/**
 * BLogicException用の例外ハンドラクラスです。
 * 
 * @version 1.0.0
 */
public abstract class BLogicExceptionHandler extends AbstractExceptionHandler {

    /**
     * BLogicExceptionが保持するBLogicMessagesインスタンスから、
     * エラーメッセージの一覧を表すActionMessagesのインスタンスを構築して返します。
     * 
     * @param ex 例外
     * @param ae ExceptionConfig
     * @param resources メッセージリソース
     * @return エラーメッセージの一覧を保持するActionMessagesインスタンス
     */
    @Override
    protected ActionMessages getErrors(Exception ex, ExceptionConfig ae,
            MessageResources resources) {
        if (!(ex instanceof BLogicException)) {
            return new ActionMessages();
        }
        BLogicException blex = (BLogicException) ex;
        BLogicMessages blogicMessages = blex.getBLogicMessages();
        boolean resourceExists = resources != null;
        return convertMessages(blogicMessages, resourceExists);
    }

    /**
     * BLogicMessagesをActionMessagesに変換します。
     * 
     * @param blogicMessages BLogicMessagesインスタンス
     * @return エラーメッセージの一覧を保持するActionMessagesインスタンス
     */
    @SuppressWarnings("unchecked")
    protected ActionMessages convertMessages(BLogicMessages blogicMessages,
            boolean resourceExists) {

        if (blogicMessages == null) {
            // blogicMessagesがnullの場合、nullを返却する
            return null;
        }

        ActionMessages messages = new ActionMessages();
        // BLogicMessages取得用イテレータ
        Iterator itr = blogicMessages.get();
        // メッセージグループ名取得用イテレータ
        Iterator groupItr = blogicMessages.getGroup();
        while (itr.hasNext()) {

            // BLogicMessageを取得
            BLogicMessage blogicMessage = (BLogicMessage) itr.next();

            // ActionMessageを作成
            ActionMessage actionMessage = null;
            if (blogicMessage.isResource()) {
                actionMessage = new ActionMessage(blogicMessage.getKey(),
                        blogicMessage.getValues());
            } else {
                actionMessage = new ActionMessage(blogicMessage.getKey(),
                        blogicMessage.isResource());
            }

            // メッセージグループ名を取得
            String group = (String) groupItr.next();

            // メッセージ情報を格納
            messages.add(group, actionMessage);
        }
        return messages;
    }

    /**
     * ActionForwardインスタンスに、遷移先モジュールを設定します。
     * 
     * @param forward 遷移先を表すActionForwardインスタンス
     * @param ex 例外
     * @param ae ExceptionConfig
     * @param mapping アクションマッピング
     */
    @Override
    protected void setModule(ActionForward forward, Exception ex,
            ExceptionConfig ae, ActionMapping mapping) {
        // N/A
    }
}
