/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.ex.exception.ApplicationException;

import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.ModuleUtils;

/**
 * AplicationException用の例外ハンドラクラスです。
 * 
 * @version 1.0.0
 */
public class ApplicationExceptionHandler extends BLogicExceptionHandler {

    /**
     * 遷移先を表すActionForwardインスタンスを取得します。 
     * 以下の順序で遷移先を特定します。
     * <ol>
     * <li>ApplicationExceptionが保持するフォワード名を持つローカルフォワード</li>
     * <li>ApplicationExceptionが保持するフォワード名を持つグローバルフォワード</li>
     * <li>exception要素のpath属性</li>
     * <li>実行中のaction要素のinput属性</li>
     * <li>いずれも取得できない場合はnull</li>
     * </ol>
     * 
     * @param ex 例外
     * @param ae ExceptionConfig
     * @param mapping アクションマッピング
     * @param request リクエスト
     * @return 遷移先を表すActionFowardインスタンス
     */
    @Override
    protected ActionForward getActionForward(Exception ex, ExceptionConfig ae,
            ActionMapping mapping, HttpServletRequest request) {
        if (ex instanceof ApplicationException) {
            ApplicationException aex = (ApplicationException) ex;
            String forwardName = aex.getForwardName();
            ActionForward forward = mapping.findForward(forwardName);
            if (forward != null) {
                return forward;
            }
            ModuleConfig moduleConfig = ModuleUtils.getInstance()
                    .getModuleConfig(request);
            ForwardConfig forwardConfig = moduleConfig
                    .findForwardConfig(forwardName);
            if (forwardConfig != null && forwardConfig instanceof ActionForward) {
                return (ActionForward) forwardConfig;
            }
        }
        return super.getActionForward(ex, ae, mapping, request);
    }
}
