/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.exception;

import jp.terasoluna.fw.service.thin.BLogicMessages;

/**
 * 業務処理中に何らかの不都合が発生し、処理が続行できないことを
 * クライアントに通知するための汎用例外クラスです。
 * メッセージ情報一覧、および遷移先（フォワード名）を指定できます。
 * 
 * @version 1.0.0
 */
public class ApplicationException extends BLogicException {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -6965884477263570390L;

    /**
     * 遷移先（フォワード名）
     */
    private String forwardName;

    /**
     * ApplicationExceptionのインスタンスを構築します。
     * 
     * @param logicMessages メッセージ情報一覧
     */
    public ApplicationException(BLogicMessages logicMessages) {
        this(logicMessages, null);
    }

    /**
     * ApplicationExceptionのインスタンスを構築します。
     * 
     * @param logicMessages メッセージ情報一覧
     * @param forwardName フォワード名
     */
    public ApplicationException(BLogicMessages logicMessages, String forwardName) {
        super(logicMessages);
        this.forwardName = forwardName;
    }

    /**
     * フォワード名を取得します。
     * 
     * @return フォワード名
     */
    public String getForwardName() {
        return forwardName;
    }

    /**
     * フォワード名を設定します。
     * 
     * @param forwardName フォワード名
     */
    public void setForwardName(String forwardName) {
        this.forwardName = forwardName;
    }
}
