/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.NestedNullException;

/**
 * {@link jp.terasoluna.fw.util.BeanUtil} NX ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Bean֘Ã[eBeBNXB
 * <p>
 * @see jp.terasoluna.fw.util.BeanUtil
 */
@SuppressWarnings("unused")
public class BeanUtilTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BeanUtilTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public BeanUtilTest(String name) {
        super(name);
    }

    /**
     * testSetBeanProperty01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:setParam1()\bhException<br>
     * () property:"param1"<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFException<br>
     * <br>
     * PropertyUtils#setProperty()\bhInvocationTargetExceptionA InvocationTargetExceptionbvĂOCX^X
     * PropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetBeanProperty01() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.setBeanProperty(bean, "param1", "PARAM1");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(Exception.class.getName(), e.getCause().getClass()
                    .getName());
        }
    }

    /**
     * testSetBeanProperty02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:param3Ȃ<br>
     * () property:"param3"<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFNoSuchMethodException<br>
     * <br>
     * PropertyUtils#setProperty()\bhNoSuchMethodExceptionAPropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetBeanProperty02() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.setBeanProperty(bean, "param3", "PARAM3");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(NoSuchMethodException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testSetBeanProperty03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:null<br>
     * () property:not null<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFIllegalArgumentException<br>
     * <br>
     * PropertyUtils#setProperty()\bhIllegalArgumentExceptionAPropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetBeanProperty03() throws Exception {
        // eXgs
        try {
            BeanUtil.setBeanProperty(null, "param1", "PARAM1");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testSetBeanProperty04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:not null<br>
     * () property:null<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFIllegalArgumentException<br>
     * <br>
     * PropertyUtils#setProperty()\bhIllegalArgumentExceptionAPropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetBeanProperty04() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.setBeanProperty(bean, null, "PARAM1");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testSetBeanProperty05() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:param2=null<br>
     * () property:"param2"<br>
     * () value:"PARAM2"<br>
     * <br>
     * ҒlF(ԕω) bean:param2="PARAM2"<br>
     * <br>
     * PropertyUtils#setProperty()\bhĂяoAɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetBeanProperty05() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        BeanUtil.setBeanProperty(bean, "param2", "PARAM2");

        // eXgʊmF
        assertEquals("PARAM2", UTUtil.getPrivateField(bean, "param2"));
    }

    /**
     * testSetBeanProperty06() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:param2="PARAM2"<br>
     * () property:"param2"<br>
     * () value:null<br>
     * <br>
     * ҒlF(ԕω) bean:param2=null<br>
     * <br>
     * PropertyUtils#setProperty()\bhĂяoAɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetBeanProperty06() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();
        bean.setParam2("PARAM2");

        // eXgs
        BeanUtil.setBeanProperty(bean, "param2", null);

        // eXgʊmF
        assertNull(UTUtil.getPrivateField(bean, "param2"));
    }

    /**
     * testSetBeanProperty07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:not null<br>
     * () property:""<br>
     * () value:"PARAM"<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFNoSuchMethodException<br>
     * <br>
     * property󕶎̎APropertyAccessExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSetBeanProperty07() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.setBeanProperty(bean, "", "PARAM");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(NoSuchMethodException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testGetBeanProperty01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:getParam1()\bhException<br>
     * () property:"param1"<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFException<br>
     * <br>
     * PropertyUtils#getProperty()\bhInvocationTargetExceptionA InvocationTargetExceptionbvĂOCX^X
     * PropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanProperty01() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.getBeanProperty(bean, "param1");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(Exception.class.getName(), e.getCause().getClass()
                    .getName());
        }
    }

    /**
     * testGetBeanProperty02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:param3Ȃ<br>
     * () property:"param3"<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFNoSuchMethodException<br>
     * <br>
     * PropertyUtils#getProperty()\bhNoSuchMethodExceptionAPropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanProperty02() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.getBeanProperty(bean, "param3");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(NoSuchMethodException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testGetBeanProperty03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:null<br>
     * () property:not null<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFIllegalArgumentException<br>
     * <br>
     * PropertyUtils#getProperty()\bhIllegalArgumentExceptionAPropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanProperty03() throws Exception {
        // eXgs
        try {
            BeanUtil.getBeanProperty(null, "param1");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testGetBeanProperty04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:not null<br>
     * () property:null<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFIllegalArgumentException<br>
     * <br>
     * PropertyUtils#getProperty()\bhIllegalArgumentExceptionAPropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanProperty04() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.getBeanProperty(bean, null);
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testGetBeanProperty05() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:param2="PARAM2"<br>
     * () property:"param2"<br>
     * <br>
     * ҒlF(߂l) Object:"PARAM2"<br>
     * <br>
     * PropertyUtils#getProperty()\bhĂяoAɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanProperty05() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();
        bean.setParam2("PARAM2");

        // eXgsE
        assertEquals("PARAM2", BeanUtil.getBeanProperty(bean, "param2"));
    }

    /**
     * testGetBeanProperty06() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:param2=null<br>
     * () property:"param2"<br>
     * <br>
     * ҒlF(߂l) Object:null<br>
     * <br>
     * PropertyUtils#getProperty()\bhĂяoAɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanProperty06() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgsE
        assertNull(BeanUtil.getBeanProperty(bean, "param2"));
    }

    /**
     * testGetBeanProperty07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:not null<br>
     * () property:""<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFNoSuchMethodException<br>
     * <br>
     * property󕶎̎APropertyAccessExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanProperty07() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.getBeanProperty(bean, "");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(NoSuchMethodException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testGetBeanPropertyType01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:getParam1()\bhException<br>
     * () property:"param1"<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFException<br>
     * <br>
     * PropertyUtils#getProperty()\bhInvocationTargetExceptionA InvocationTargetExceptionbvĂOCX^X
     * PropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType01() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.getBeanPropertyType(bean, "param1(0).");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertSame(InvocationTargetException.class, e.getCause().getClass());
        }
    }

    /**
     * testGetBeanPropertyType02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:param3Ȃ<br>
     * () property:"param3"<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFNoSuchMethodException<br>
     * <br>
     * PropertyUtils#getProperty()\bhNoSuchMethodExceptionA PropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType02() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        assertNull(BeanUtil.getBeanPropertyType(bean, "param3"));

    }

    /**
     * testGetBeanPropertyType03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:null<br>
     * () property:not null<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFIllegalArgumentException<br>
     * <br>
     * PropertyUtils#getProperty()\bhIllegalArgumentExceptionAPropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType03() throws Exception {
        // eXgs
        try {
            BeanUtil.getBeanPropertyType(null, "param1");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testGetBeanPropertyType04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:not null<br>
     * () property:null<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFIllegalArgumentException<br>
     * <br>
     * PropertyUtils#getProperty()\bhIllegalArgumentExceptionAPropertyAccessExceptionŃbv邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType04() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgs
        try {
            BeanUtil.getBeanPropertyType(bean, null);
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testGetBeanPropertyType05() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:param2="PARAM2"<br>
     * () property:"param2"<br>
     * <br>
     * ҒlF(߂l) Object:"PARAM2"<br>
     * <br>
     * PropertyUtils#getProperty()\bhĂяoAɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType05() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();
        bean.setParam2("PARAM2");

        // eXgsE
        assertSame(String.class, BeanUtil.getBeanPropertyType(bean, "param2"));
    }

    /**
     * testGetBeanPropertyType06() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:param2=null<br>
     * () property:"param2"<br>
     * <br>
     * ҒlF(߂l) Object:null<br>
     * <br>
     * PropertyUtils#getProperty()\bhĂяoAɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType06() throws Exception {
        // eXgpJavaBean
        BeanUtil_BeanStub01 bean = new BeanUtil_BeanStub01();

        // eXgsE
        assertSame(String.class, BeanUtil.getBeanPropertyType(bean, "param2"));
    }

    /**
     * testGetBeanPropertyType07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() bean:not null<br>
     * () property:""<br>
     * <br>
     * ҒlF(ԕω) O:PropertyAccessExceptionF<br>
     * bvOFNestedNullException<br>
     * <br>
     * property󕶎̎APropertyAccessExceptionX[邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType07() throws Exception {
        // eXgpJavaBean
        Map map = new HashMap();

        // eXgs
        try {
            BeanUtil.getBeanPropertyType(map, "aa.(a)");
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertEquals(NestedNullException.class.getName(), e.getCause()
                    .getClass().getName());
        }
    }

    /**
     * testGetBeanPropertyType08() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:BeanUtil_DynaBeanImpl01<br>
     * testString(String^)<br>
     * () property:"testString"<br>
     * <br>
     * ҒlF(߂l) Object:String.class<br>
     * <br>
     * DynaBeañtB[hzECollection^ł͂Ȃꍇ AɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType08() throws Exception {
        // O
        DynaProperty dynaProperty = new DynaProperty("testString", String.class);
        BeanUtil_DynaClassImpl01 dynaClass = new BeanUtil_DynaClassImpl01();
        dynaClass.setDynaProperty(dynaProperty);
        DynaBean bean = new BeanUtil_DynaBeanImpl01(dynaClass);

        // eXg{
        // 
        assertEquals(String.class, BeanUtil.getBeanPropertyType(bean,
                "testString"));
    }

    /**
     * testGetBeanPropertyType09() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:BeanUtil_DynaBeanImpl01<br>
     * testArray(String[]^)<br>
     * () property:"testArray"<br>
     * <br>
     * ҒlF(߂l) Object:String[].class<br>
     * <br>
     * DynaBeañtB[hzECollection^łꍇ AɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType09() throws Exception {
        // O
        DynaProperty dynaProperty = new DynaProperty("testArray",
                String[].class);
        BeanUtil_DynaClassImpl01 dynaClass = new BeanUtil_DynaClassImpl01();
        dynaClass.setDynaProperty(dynaProperty);
        DynaBean bean = new BeanUtil_DynaBeanImpl01(dynaClass);

        // eXg{
        // 
        assertEquals(String[].class, BeanUtil.getBeanPropertyType(bean,
                "testArray"));
    }

    /**
     * testGetBeanPropertyType10() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() bean:BeanUtil_DynaBeanImpl01<br>
     * () property:"testNull"<br>
     * <br>
     * ҒlF(߂l) Object:null<br>
     * <br>
     * w肳ꂽDynaBeanɑ݂ȂꍇAɍsȂ邱ƁB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanPropertyType10() throws Exception {
        // O
        BeanUtil_DynaClassImpl01 dynaClass = new BeanUtil_DynaClassImpl01();
        dynaClass.setDynaProperty(null);
        DynaBean bean = new BeanUtil_DynaBeanImpl01(dynaClass);

        // eXg{
        // 
        assertEquals(null, BeanUtil.getBeanPropertyType(bean, "testNull"));
    }
}
