/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import javax.servlet.ServletException;

import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;

/**
 *  StrutsTestCase p̍ւp ActionServlet NXB
 * <BR><BR>
 * StrutsTestCasepɖ肪Ă܂ CodeListPlugIn𖳌A
 * ActionNXX^uActionɒuʂB
 * <BR><BR>
 * struts-config.xmlvalidation.xmlp̒P̃eXgR[h
 * setUp()\bh̒ŁAL̂悤ɒ^IɋLqėpB
 * 
 * <PRE>
 * [gp]
 *  //eXgP[Xʂ̏
 *  protected void setUp() throws Exception {
 *      super.setUp();
 *
 *      // eXgpActionServletNX̐ݒ
 *      <B><U>setActionServlet(new UTActionServlet());</U></B>
 *
 *      // WebAvP[Ṽ[gfBNgw
 *      setContextDirectory(new File("webapps"));
 *
 *      // eXgΏۂ̃ANVpX܂struts-configt@Cw
 *      setConfigFile("logon", "/WEB-INF/struts-logon-config.xml");
 *
 *      // eXgΏۂ̃ANVpXw
 *      setRequestPathInfo("/logon", "/logonBLogic.do");
 *  }
 * </PRE>
 * 
 */
public class UTActionServlet extends ActionServlet {

    /**
     * R[hXgvOC̃NX
     */
    static final String codeListPlugInName = 
        "jp.terasoluna.framework.web.thinclient.plugins.CodeListPlugIn";

    /**
     * _~[vOC̃NX
     */
    static final String dummyPlugInName = DoNothingPlugIn.class.getName();
    
    /**
     * _~[ANṼNX
     */
    static final String dummyActionName = DoNothingAction.class.getName();
    

    /**
     * @see org.apache.struts.action.ActionServlet#initModuleConfig(java.lang.String, java.lang.String)
     */
    protected ModuleConfig initModuleConfig(String prefix, String paths)
        throws ServletException {

        // X[p[NX̓\bhĂяoB
        ModuleConfig moduleConfig = super.initModuleConfig(prefix, paths);
        
        // ActionMapping̎sActionׂă_~[ActionɍւB
        ActionConfig[] actionConfigs = moduleConfig.findActionConfigs();
        for(int i = 0; i < actionConfigs.length; i++) {
            actionConfigs[i].setType(dummyActionName);
        }
        
        // Hς݂ModuleConfigԋpB
        return moduleConfig;
    }

    /**
     * @see org.apache.struts.action.ActionServlet#initModulePlugIns(org.apache.struts.config.ModuleConfig)
     */
    protected void initModulePlugIns(ModuleConfig moduleConfig)
        throws ServletException {

        // pvOĈACodeListPlugIn_~[PlugInɍւ
        PlugInConfig[] pluginConfigs = moduleConfig.findPlugInConfigs();
        for (int i = 0; i < pluginConfigs.length; i++) {
            if (pluginConfigs[i].getClassName().equals(codeListPlugInName)) {
                pluginConfigs[i].setClassName(dummyPlugInName);
            }
        }
        
        // eNX̎\bhĂяoB
        super.initModulePlugIns(moduleConfig);
    }

}
