/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.AbstractBLogicMapper;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicMapperEx;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.action.resolver.ResolverActionMapping;
import jp.terasoluna.fw.web.struts.actions.AnnotationBLogicAction;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.easymock.classextension.EasyMock;
import org.junit.Test;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.util.ClassUtils;

/**
 * 
 */
public class AnnotationBLogicActionTest extends TestCase {

    /**
     * doExecuteBLogic\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>param : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>BLogicResult : null</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testDoExecuteBLogic001() throws Exception {
        AnnotationBLogicAction<?> action = new AnnotationBLogicAction();

        // eXg
        BLogicResult result = action.doExecuteBLogic(null);

        // 
        assertNull(result);
    }

    /**
     * getTargetClass\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>businessLogic : AOPvLVIuWFNg(AnnotationBLogicActionTestBLogic.class)CX^X</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : AnnotationBLogicActionTestBLogic.class</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetTargetClass() throws Exception {
        AnnotationBLogicAction<?> action = new AnnotationBLogicAction();

        BLogic businessLogic = null;

        // p[^
        AdvisedSupport advised = new AdvisedSupport();
        advised.addInterface(BLogic.class);
        Class[] proxiedInterfaces = AopProxyUtils
                .completeProxiedInterfaces(advised);
        InvocationHandler handler = new InvocationHandler() {
            public Object invoke(Object proxy, Method method, Object[] args)
                                                                            throws Throwable {
                return AnnotationBLogicActionTestBLogic.class;
            }
        };
        // vLVIuWFNg
        Object businessLogicObj = Proxy.newProxyInstance(ClassUtils
                .getDefaultClassLoader(), proxiedInterfaces, handler);
        if (businessLogicObj instanceof BLogic) {
            businessLogic = (BLogic) businessLogicObj;
        }

        action.setBusinessLogic(businessLogic);

        // eXg
        Class<?> result = action.getTargetClass();

        // 
        assertNotNull(result);
        assertEquals(AnnotationBLogicActionTestBLogic.class, result);
    }

    /**
     * getInputBeanClass\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>businessLogic : AnnotationBLogicActionTestBLogicCX^X</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : AnnotationBLogicActionTestBLogicInput.class</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetInputBeanClass() throws Exception {
        AnnotationBLogicAction<AnnotationBLogicActionTestBLogicInput> action = new AnnotationBLogicAction<AnnotationBLogicActionTestBLogicInput>();

        AnnotationBLogicActionTestBLogic blogic = new AnnotationBLogicActionTestBLogic();

        // eXg
        Class<?> result = action.getInputBeanClass(blogic);

        // 
        assertNotNull(result);
        assertEquals(AnnotationBLogicActionTestBLogicInput.class, result);
    }

    /**
     * doExecute\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : new ActionMapping()</li>
     * <li>form : null</li>
     * <li>request : null</li>
     * <li>response : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OFSystemException(cause : ClassCastException, message : "errors.blogic.mapping")</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIllegalActionMappingType() throws Exception {
        AnnotationBLogicAction<?> action = new AnnotationBLogicAction();
        // p[^
        ActionMapping actionMappingMock = new ActionMapping();
        try {
            // eXg
            action.doExecute(actionMappingMock, null, null, null);
        } catch (Exception e) {
            // 
            assertTrue(e instanceof SystemException);
            assertTrue(e.getCause() instanceof ClassCastException);
            assertEquals("errors.blogic.mapping", e.getMessage());
        }
    }

    /**
     * setBusinessLogic\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>businessLogic : new BLogic()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OFIllegalArgumentException(message : "businessLogic must be an instance of jp.terasoluna.fw.service.thin.BLogic.")</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testSetBusinessLogic() throws Exception {
        AnnotationBLogicAction<?> action = new AnnotationBLogicAction();
        // p[^
        BLogic bLogicMock = new BLogic<Object>() {
            public BLogicResult execute(Object params) {
                return null;
            }
        };
        try {
            // eXg
            action.setBusinessLogic(bLogicMock);
        } catch (Exception e) {
            // 
            assertTrue(e instanceof IllegalArgumentException);
            assertEquals(
                    "businessLogic must be an instance of jp.terasoluna.fw.service.thin.BLogic.",
                    e.getMessage());
        }
    }

    /**
     * execute\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : EasyMock.createMock(ActionMappingEx.class)</li>
     * <li>form : EasyMock.createMock(ActionForm.class)</li>
     * <li>request : new MockHttpServletRequest()</li>
     * <li>response : new MockHttpServletResponse()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>OFSystemException(cause : NullPointerException, message : "errors.blogic.result.null")</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testResultObjectIsNull() throws Exception {
        AnnotationBLogicAction<?> action = new AnnotationBLogicAction() {
            @Override
            protected AbstractBLogicMapper getBLogicMapper(
                    HttpServletRequest req) {
                return new BLogicMapperEx();
            }

            @Override
            protected Class getInputBeanClass(BLogic blogic) {
                return Object.class;
            }
        };

        // p[^
        BLogic bLogicMock = EasyMock.createMock(BLogic.class);
        EasyMock.expect(bLogicMock.execute(EasyMock.anyObject())).andReturn(
                null);
        action.setBusinessLogic(bLogicMock);

        ActionMapping actionMappingMock = EasyMock
                .createMock(ActionMappingEx.class);
        EasyMock.expect(actionMappingMock.getPath()).andReturn(null);

        ActionForm actionFormMock = EasyMock.createMock(ActionForm.class);
        EasyMock.replay(bLogicMock, actionMappingMock, actionFormMock);

        try {
            // eXg
            action
                    .execute(actionMappingMock, actionFormMock,
                            new MockHttpServletRequest(),
                            new MockHttpServletResponse());
        } catch (Exception e) {
            // 
            assertTrue(e instanceof SystemException);
            assertTrue(e.getCause() instanceof NullPointerException);
            assertEquals("errors.blogic.result.null", e.getMessage());
        }

        EasyMock.verify(bLogicMock, actionMappingMock);
    }

    /**
     * execute\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : EasyMock.createMock(ActionMappingEx.class)</li>
     * <li>form : new ActionFormMock()</li>
     * <li>request : new MockHttpServletRequest()</li>
     * <li>response : new MockHttpServletResponse()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testResultStringIsNull() throws Exception {
        AnnotationBLogicAction<?> action = new AnnotationBLogicAction() {
            @Override
            protected AbstractBLogicMapper getBLogicMapper(
                    HttpServletRequest req) {
                return new BLogicMapperEx();
            }

            @Override
            protected Class getInputBeanClass(BLogic blogic) {
                return Object.class;
            }
        };

        // p[^
        BLogic blogicMock = EasyMock.createMock(BLogic.class);

        BLogicResult expectedResult = new BLogicResult();
        expectedResult.setResultObject(new ResultObjectMock());
        EasyMock.expect(blogicMock.execute(EasyMock.anyObject())).andReturn(
                expectedResult);

        action.setBusinessLogic(blogicMock);
        ResolverActionMapping actionMappingMock = EasyMock
                .createMock(ResolverActionMapping.class);
        EasyMock.expect(actionMappingMock.getPath()).andReturn(null);

        EasyMock.expect(actionMappingMock.findForward(null)).andReturn(null);

        EasyMock.expect(actionMappingMock.getScope()).andReturn("request");
        EasyMock.expect(actionMappingMock.getAttribute()).andReturn("form");

        actionMappingMock.setModuleConfig(new ModuleConfigImpl());
        EasyMock.replay(blogicMock, actionMappingMock);

        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute(Globals.MAPPING_KEY, actionMappingMock);
        request.setAttribute("form", new MockActionForm());

        // eXg
        ActionForward actualForward = action.execute(actionMappingMock,
                new ActionFormMock(), request, new MockHttpServletResponse());

        // 
        assertNull(actualForward);

        EasyMock.verify(blogicMock);
    }

    /**
     * execute\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>mapping : EasyMock.createMock(ActionMappingEx.class)</li>
     * <li>form : EasyMock.createMock(ActionForm.class)</li>
     * <li>request : new MockHttpServletRequest()</li>
     * <li>response : new MockHttpServletResponse()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : ActionForward</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testResultStringIsNotNull() throws Exception {
        AnnotationBLogicAction<?> action = new AnnotationBLogicAction() {
            @Override
            protected AbstractBLogicMapper getBLogicMapper(
                    HttpServletRequest req) {
                return new BLogicMapperEx();
            }

            @Override
            protected Class getInputBeanClass(BLogic blogic) {
                return Object.class;
            }
        };

        // p[^
        BLogic blogicMock = EasyMock.createMock(BLogic.class);
        String expectedResultString = "aaa";
        BLogicResult expectedResult = new BLogicResult();
        expectedResult.setResultObject(new ResultObjectMock());
        expectedResult.setResultString(expectedResultString);
        EasyMock.expect(blogicMock.execute(EasyMock.anyObject())).andReturn(
                expectedResult);
        action.setBusinessLogic(blogicMock);

        ActionForward expectedForward = new ActionForward();
        ActionMapping actionMappingMock = EasyMock
                .createMock(ActionMappingEx.class);
        EasyMock.expect(actionMappingMock.findForward(expectedResultString))
                .andReturn(expectedForward);
        EasyMock.expect(actionMappingMock.getPath()).andReturn(null);

        EasyMock.expect(actionMappingMock.getScope()).andReturn("request");
        EasyMock.expect(actionMappingMock.getAttribute()).andReturn("form");

        ActionForm actionFormMock = EasyMock.createMock(ActionForm.class);
        EasyMock.replay(blogicMock, actionMappingMock, actionFormMock);

        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute(Globals.MAPPING_KEY, actionMappingMock);
        request.setAttribute("form", new MockActionForm());

        // eXg
        ActionForward actualForward = action.execute(actionMappingMock,
                actionFormMock, request, new MockHttpServletResponse());

        // 
        assertEquals(expectedForward, actualForward);
        EasyMock.verify(blogicMock, actionMappingMock, actionFormMock);
    }
}
