/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.core.OrderComparator;
import org.springframework.web.context.WebApplicationContext;

/**
 * DefaultProcessPopulateHandler
 * <p>
 * processPopulategۂɗpB
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 */
public class DefaultProcessPopulateHandler implements ProcessPopulateHandler {

    /** ProcessPopulatorXg */
    protected List<ProcessPopulator> processPopulatorList = null;

    /*
     * (non-Javadoc)
     * @see
     * jp.terasoluna.fw.web.struts.action.handler.ProcessPopulateHandler#processPopulate(javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionForm, org.apache.struts.action.ActionMapping,
     * org.apache.struts.config.ModuleConfig, org.apache.struts.action.ActionServlet,
     * org.springframework.web.context.WebApplicationContext)
     */
    @SuppressWarnings("unchecked")
    public boolean processPopulate(HttpServletRequest req,
            HttpServletResponse res, ActionForm form, ActionMapping mapping,
            ModuleConfig moduleConfig, ActionServlet servlet,
            WebApplicationContext wac) throws ServletException {

        boolean populateSuccess = false;

        if (this.processPopulatorList == null && wac != null) {
            // ReiProcessPopulatorQꊇ擾
            Map<?, ?> processPopulatorMap = BeanFactoryUtils
                    .beansOfTypeIncludingAncestors(wac, ProcessPopulator.class);
            if (!processPopulatorMap.isEmpty()) {
                this.processPopulatorList = new ArrayList<ProcessPopulator>(
                        (Collection<? extends ProcessPopulator>) processPopulatorMap
                                .values());
                Collections.sort(this.processPopulatorList,
                        new OrderComparator());
            }
        }

        // ProcessPopulatorQ𓪂Ȃ߂
        if (this.processPopulatorList != null) {
            for (ProcessPopulator processPopulator : this.processPopulatorList) {
                if (processPopulator.supports(req, res, form, mapping, servlet,
                        wac)) {
                    // ProcessPopulator processPopulate() \bhs
                    populateSuccess = processPopulator.processPopulate(req,
                            res, form, mapping, servlet, wac);
                    if (populateSuccess) {
                        break;
                    }
                }

            }
        }

        return populateSuccess;
    }

}
